/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.ShutdownDBProcessor;
import com.huawei.ism.drm.db.recovery.process.ShutdownProDBSubProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.HashSet;
import java.util.List;

public class ShutdownProDBProcessor
extends ShutdownDBProcessor {
    private static final long serialVersionUID = 8209306570159471738L;

    public ShutdownProDBProcessor() {
        this.setIsNeedSave(false);
    }

    public ShutdownProDBProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    @Override
    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected List<ProtectObject> getShutdownProtectObjects(RecoveryProcessorContext context) {
        return DBRecoveryTools.appCurrentPosFilter((RecoveryProcessorContext)context);
    }

    @Override
    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<ShutdownProDBSubProcessor> shutdownDBSubProcessors = new HashSet<ShutdownProDBSubProcessor>();
        List<ProtectObject> allPOs = this.getShutdownProtectObjects(context);
        for (ProtectObject po : allPOs) {
            ShutdownProDBSubProcessor processor = new ShutdownProDBSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setPoId(po.getUuid());
            processor.setDbName(this.getNewDatabaseName(context.getRecoveryPlan(), po));
            shutdownDBSubProcessors.add(processor);
        }
        this.setChildProc(shutdownDBSubProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    protected String getNewDatabaseName(RecoveryPlan recoveryPlan, ProtectObject po) {
        return po.getName();
    }
}

