/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.recovery.process.ShutdownDBProcessor;
import com.huawei.ism.drm.db.recovery.process.StartupDBProcessor;
import com.huawei.ism.drm.db.recovery.process.TestConnDBProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceProcessor;
import com.huawei.ism.drm.host.recovery.provider.HostRecoveryProcessProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DBRecoveryProcessProvider
extends HostRecoveryProcessProvider {
    private static Log logger = LogFactory.getInstance(DBRecoveryProcessProvider.class);

    public RecoveryProcessor getStartDBProcessor() {
        return new StartupDBProcessor();
    }

    public abstract RecoveryProcessor getTestConnDBProcessor();

    public RecoveryProcessor getShutdownDBProcessor() {
        return new ShutdownDBProcessor();
    }

    public abstract RecoveryProcessor getMountFsProcessor();

    public abstract RecoveryProcessor getUnMountFsProcessor();

    public abstract RecoveryProcessor getRebuildAppProcessor();

    public void resetRecoveryProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, boolean isNeedSaveToDb) {
        if (null == recoveryPlan) {
            logger.error((Object)"reset RecoveryProcessDefinition,recoveryPlan is null.", 90160758786989L);
            return;
        }
        boolean isManauConfig = this.getManualConfig(recoveryPlan);
        if (this.isUnknownStorageType(recoveryPlan) || isManauConfig) {
            ArrayList procClsList = new ArrayList();
            procClsList.add(this.getShutdownDBProcessor().getClass());
            procClsList.add(this.getUnMountFsProcessor().getClass());
            procClsList.add(this.getMountFsProcessor().getClass());
            procClsList.add(this.getStartDBProcessor().getClass());
            procClsList.add(this.getTestConnDBProcessor().getClass());
            this.deleteRecoveryProcessors(rpDefinition, procClsList, isNeedSaveToDb);
        }
    }

    public List<RecoveryProcessor> filterProcessor(List<RecoveryProcessor> processors, Map<String, String> filters) {
        ArrayList<RecoveryProcessor> results = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor processor : processors) {
            if (processor instanceof MountHostDeviceProcessor) {
                results.add(processor);
            }
            if (!"false".equals(filters.get("startDB"))) continue;
            if (processor instanceof StartupDBProcessor) {
                processor.setIsEnabled(Boolean.valueOf(false));
            }
            if (!(processor instanceof TestConnDBProcessor)) continue;
            processor.setIsEnabled(Boolean.valueOf(false));
        }
        return results;
    }

    private boolean getManualConfig(RecoveryPlan recoveryPlan) {
        Iterator pgs = recoveryPlan.getProtectGroups().iterator();
        if (!pgs.hasNext()) {
            logger.error((Object)"pgs is not content!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)pgs.next();
        String result = (String)pg.getProps().get("IS_MANUAL_CONFIG_LUN");
        return Boolean.valueOf(result);
    }

    private boolean isUnknownStorageType(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            return true;
        }
        Iterator pgIter = recoveryPlan.getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            return true;
        }
        ProtectGroup pg = (ProtectGroup)pgIter.next();
        if (pg == null || VerifyUtil.isEmpty((Collection)pg.getPolist())) {
            return true;
        }
        Iterator poIter = pg.getPolist().iterator();
        if (!poIter.hasNext()) {
            return true;
        }
        ProtectObject po = (ProtectObject)poIter.next();
        if (po != null && !VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
            Iterator storageIter = po.getUsedStorageResourceSet().iterator();
            if (!storageIter.hasNext()) {
                return true;
            }
            ProtectObjectStorageInfo poStorage = (ProtectObjectStorageInfo)storageIter.next();
            int storageType = poStorage.getStorageType();
            boolean isUnknownStorageType = DrmEnumDefine.StorageTypeE.UNKNOWN.getValue() == storageType;
            return isUnknownStorageType;
        }
        return true;
    }
}

