/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.db.recovery.provider;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DBRefactorConfigurationProvider
extends BaseRefactorConfigurationProvider {
    private static Log logger = LogFactory.getInstance(DBRefactorConfigurationProvider.class);

    public void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        if (protectObject.getPoType() == 14) {
            this.reverseNasProtectObjectAttributes(protectObject);
            return;
        }
        this.reverseAppProtectObjectsAttrs(protectObject, params);
    }

    private void reverseNasProtectObjectAttributes(ProtectObject protectObject) {
        Iterator storageIter = protectObject.getUsedStorageResourceSet().iterator();
        if (!storageIter.hasNext()) {
            return;
        }
        ProtectObjectStorageInfo poStorage = (ProtectObjectStorageInfo)storageIter.next();
        if (null != poStorage) {
            String newProductSN = poStorage.getResourceProviderSN();
            protectObject.setProviderSN(newProductSN);
            String newResourceId = poStorage.getResourceId();
            String vstoreId = poStorage.getVstoreId();
            ArrayUnit arrayUnit = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageBySn(newProductSN);
            if (null == arrayUnit) {
                logger.error((Object)"arrayUnit is not exist!");
                throw new LegoCheckedException(1073947393L);
            }
            protectObject.setProviderName(arrayUnit.getName());
            String uuId = arrayUnit instanceof XveUnit ? (VerifyUtil.isEmpty((String)vstoreId) ? new XveUUID(newProductSN, XveMOType.FILESYSTEM, newResourceId + "_vstoreId=0").toString() : new XveUUID(newProductSN, XveMOType.FILESYSTEM, newResourceId + "_vstoreId=" + vstoreId).toString()) : newProductSN + ":3:0:" + newResourceId;
            protectObject.setMoUuid(uuId);
            ManagedObject newMo = CommonDAOLocator.getMoDao().getMoByUuid(uuId, Boolean.valueOf(true));
            if (newMo != null) {
                protectObject.setName(newMo.getName());
            }
            protectObject.getProps().put("nasFsId", newResourceId);
        }
    }

    protected void reverseAppProtectObjectsAttrs(ProtectObject protectObject, Map<String, Object> params) {
        IRecoveryResourceService recoveryService;
        DrResource drResource;
        String hostOrGroupId = null;
        if (null != params) {
            Map pgAndDisasterHosts = (Map)params.get("PG_DISASTER_HOST");
            if (null == pgAndDisasterHosts) {
                logger.error((Object)"pgAndDisasterHosts is not exist!");
                throw new LegoCheckedException(1073947393L);
            }
            hostOrGroupId = (String)pgAndDisasterHosts.get(protectObject.getProtectGroup().getUuid());
        }
        if (null == (drResource = (recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getDrResourceByID(hostOrGroupId))) {
            logger.error((Object)("The host or group does not exist. Id:" + hostOrGroupId), 90160758784001L);
            throw new LegoCheckedException(1073948686L);
        }
        this.reverseAppProviderAttr(protectObject, hostOrGroupId, drResource);
    }

    protected void reverseAppProviderAttr(ProtectObject protectObject, String hostOrGroupId, DrResource drResource) {
        String oldMoUuid = protectObject.getMoUuid();
        String[] strArray = oldMoUuid.split(":");
        if (strArray.length < 3) {
            logger.error((Object)"strArray length < 3, the param is not correct", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String dbNameHashCode = strArray[2];
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        DatabaseInstance dbInstance = this.getMatchedDatabaseInstance(protectObject.getName(), protectObject.getPoType(), hostOrGroupId);
        if (null == dbInstance) {
            logger.error((Object)("There is no matched db instance. DbName:" + protectObject.getName() + ",HostOrGroupId:" + hostOrGroupId), 90160758784001L);
            throw new LegoCheckedException(1073948745L, new String[]{drResource.getName(), protectObject.getName()});
        }
        String newMoUuid = this.getNewMoUuid(protectObject, dbInstance, oldMoUuid);
        protectObject.setMoUuid(newMoUuid);
        DrResource matchedDrHost = recoveryService.getDrResourceByID(dbInstance.getHostSN());
        if (null == matchedDrHost) {
            logger.error((Object)("The host does not exist. Id:" + dbInstance.getHostSN()), 90160758784001L);
            throw new LegoCheckedException(1073948686L);
        }
        DrResource provider = matchedDrHost;
        if (null != provider.getParentDrResource()) {
            provider = provider.getParentDrResource();
        }
        protectObject.setProviderSN(provider.getDeviceSn());
        protectObject.setProviderName(provider.getName());
    }

    protected String getNewMoUuid(ProtectObject protectObject, DatabaseInstance dbInstance, String oldMoUuid) {
        String[] strArray = oldMoUuid.split(":");
        return dbInstance.getHostSN() + ":" + dbInstance.getInstanceName() + ":" + strArray[2];
    }

    protected void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        Map pgAndDisasterHosts = (Map)params.get("PG_DISASTER_HOST");
        String hostOrGroupId = (String)pgAndDisasterHosts.get(protectGroup.getUuid());
        protectGroup.setPoProviderSN(hostOrGroupId);
    }

    private DatabaseInstance getMatchedDatabaseInstance(String dbName, int dbType, String hostOrGroupId) {
        IRecoveryResourceService resourceService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        List dbInstances = resourceService.getDatabaseInstancesByDbName(dbName, dbType);
        if (VerifyUtil.isEmpty((Collection)dbInstances)) {
            return null;
        }
        List drHosts = resourceService.getDrHostsByDrHostOrGroupId(hostOrGroupId);
        drHosts.sort((o1, o2) -> o2.getDeviceSn().compareTo(o1.getDeviceSn()));
        DatabaseInstance matchedBbInstance = null;
        for (DrHost drHost : drHosts) {
            DatabaseInstance dbInstance = this.getMatchedDbInstance(drHost, dbInstances);
            if (null == dbInstance) continue;
            matchedBbInstance = dbInstance;
            break;
        }
        return matchedBbInstance;
    }

    private DatabaseInstance getMatchedDbInstance(DrHost drHost, List<DatabaseInstance> databaseInstances) {
        for (DatabaseInstance databaseInstance : databaseInstances) {
            if (!drHost.getDeviceSn().equals(databaseInstance.getHostSN())) continue;
            return databaseInstance;
        }
        return null;
    }

    public void refactorPolicyTemplate(ProtectGroup pg) {
        boolean isCascadeTpl;
        super.refactorPolicyTemplate(pg);
        DrmEnumDefine.AppType eAppType = DrmEnumDefine.AppType.getType((int)pg.getPoType());
        int templateType = pg.getTemplate().getType();
        Map prop = pg.getTemplate().getProps();
        boolean isConcurrentTpl = templateType == 6 || PolicyTemplateType.REP_4DC_CONCURRENT_POLICYTEMPLATE.contains(templateType);
        boolean bl = isCascadeTpl = templateType == 4 || PolicyTemplateType.REP_4DC_CASCADE_POLICYTEMPLATE.contains(templateType);
        if (isConcurrentTpl) {
            this.updateConcurrentAsyncAsyncTemplate(pg, eAppType);
        } else if (isCascadeTpl) {
            this.updateCascadeAsyncAsyncTemplate(pg, eAppType);
        } else if (prop.containsKey("APP_FREEZE_FLAG") && !this.getIsReversed().booleanValue()) {
            prop.put("APP_FREEZE_FLAG", "1");
        }
    }

    private void updateCascadeAsyncAsyncTemplate(ProtectGroup pg, DrmEnumDefine.AppType eAppType) {
        Map props = pg.getTemplate().getProps();
        if (eAppType != DrmEnumDefine.AppType.ORACLE && props.containsKey("APP_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_B.getValue())) {
            props.put("APP_FREEZE_FLAG", "1");
            props.remove("APP_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_B.getValue());
            props.remove("APP_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_C.getValue());
        } else if (eAppType == DrmEnumDefine.AppType.ORACLE && props.containsKey("ORACLE_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_B.getValue())) {
            this.updateOracleCascadeAsyncAsyncTemplate(pg);
        }
    }

    private void updateOracleCascadeAsyncAsyncTemplate(ProtectGroup pg) {
        Map props = pg.getTemplate().getProps();
        props.put("ORACLE_FREEZE_FLAG", "1");
        props.put("ORACLE_CAP_THREASHOLD", "0");
        props.remove("ORACLE_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_B.getValue());
        props.remove("ORACLE_FREEZE_FLAG" + DrmEnumDefine.ProtectLocation.A_C.getValue());
        props.remove("ORACLE_CAP_THREASHOLD" + DrmEnumDefine.ProtectLocation.A_B.getValue());
        props.remove("ORACLE_CAP_THREASHOLD" + DrmEnumDefine.ProtectLocation.A_C.getValue());
    }

    private void updateConcurrentAsyncAsyncTemplate(ProtectGroup pg, DrmEnumDefine.AppType eAppType) {
        int abLocationValue = DrmEnumDefine.ProtectLocation.A_B.getValue();
        int acLocationValue = DrmEnumDefine.ProtectLocation.A_C.getValue();
        Map tempProps = pg.getTemplate().getProps();
        if (eAppType != DrmEnumDefine.AppType.ORACLE && tempProps.containsKey("APP_FREEZE_FLAG")) {
            tempProps.put("APP_FREEZE_FLAG" + abLocationValue, "1");
            tempProps.put("APP_FREEZE_FLAG" + acLocationValue, "1");
            tempProps.remove("APP_FREEZE_FLAG");
        } else if (eAppType == DrmEnumDefine.AppType.ORACLE && tempProps.containsKey("ORACLE_FREEZE_FLAG")) {
            tempProps.put("ORACLE_FREEZE_FLAG" + abLocationValue, "1");
            tempProps.put("ORACLE_FREEZE_FLAG" + acLocationValue, "1");
            tempProps.put("ORACLE_CAP_THREASHOLD" + abLocationValue, "0");
            tempProps.put("ORACLE_CAP_THREASHOLD" + acLocationValue, "0");
            tempProps.remove("ORACLE_FREEZE_FLAG");
            tempProps.remove("ORACLE_CAP_THREASHOLD");
        }
    }

    public void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        super.updateProtectObject(oldProtectObject, newProtectObject);
        if (oldProtectObject.getPoType() == 14) {
            oldProtectObject.setName(newProtectObject.getName());
            return;
        }
        this.updateAppProtectObject(oldProtectObject, newProtectObject);
    }

    protected void updateAppProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        logger.debug((Object)"Update app ProtectObject.");
    }

    public void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        super.refactorRecoveryPlan(recoveryPlan, params);
        if (this.getIsReversed().booleanValue()) {
            return;
        }
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if ("startOrder".equals(recoverySetting.getName())) {
                recoverySetting.setValue(String.valueOf(10));
                continue;
            }
            if (!"isStart".equals(recoverySetting.getName())) continue;
            recoverySetting.setValue("true");
        }
    }
}

