/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.adapter.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.app.sdk.service.IOracleAppProxy;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

public class OracleAppProxyImpl
implements IOracleAppProxy {
    private static final Log LOGGER = LogFactory.getInstance(OracleAppProxyImpl.class);
    private INeMgrProtocolExtendService neMgr;

    public void forcedArchive(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"forcedArchive: po is null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("forced archive on " + po.getName() + "," + po.getProviderSN()), 90160758786989L);
        List<ProtectObject> protectObjects = OracleAppUtil.buildProtectObjects(po);
        int instanceStartFailNum = 0;
        for (ProtectObject tempPo : protectObjects) {
            try {
                this.forcedArchiveForEveryHost(tempPo);
            }
            catch (LegoCheckedException e) {
                if (1073948956L == e.getErrorCode()) {
                    ++instanceStartFailNum;
                    continue;
                }
                throw e;
            }
        }
        if (instanceStartFailNum == protectObjects.size()) {
            throw new LegoCheckedException(1073948956L);
        }
    }

    private void forcedArchiveForEveryHost(ProtectObject tempPo) {
        try {
            OracleAppUtil.checkOperationParameters(tempPo);
            ProtectObject poParam = OracleAppUtil.getOperateParam(tempPo);
            NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)tempPo.getProviderSN());
            OracleAppUtil.forcedArchive(poParam, ne);
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)("forcedArchive error on " + tempPo.getName() + "," + tempPo.getProviderSN()), (Throwable)le, 90160758786989L);
            throw le;
        }
        catch (Exception e) {
            String errorMsg = "forcedArchive error on " + tempPo.getName() + "," + tempPo.getProviderSN();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, null, (Log)LOGGER);
        }
    }

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }
}

