/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.adapter.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.ObjectConvert;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.Database;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.db.provider.AbstractDataBaseProvider;
import com.huawei.ism.drm.db.util.DatabaseApplicationUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostGroupService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.host.util.DrHostValidUtil;
import com.huawei.ism.drm.oracle.adapter.service.impl.OracleManagerImpl;
import com.huawei.ism.drm.oracle.constant.OracleErrorCode;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectTempStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;

public class OracleProvider
extends AbstractDataBaseProvider {
    private static Log logger = LogFactory.getInstance(OracleProvider.class);
    private static final int MAX_THREASHOLD = 0x100000;
    private static final List<Integer> POLICIES = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 16, 15, 18, 19, 20, 23, 24, 26, 27, 30, 31, 32, 35, 36, 58, 59, 47, 14);
    private OracleManagerImpl oracleManager;
    private IPolicyTemplateManager policyTemplateManager;

    private static void resetProtectObject(ProtectObject po, ProtectObject oraclePo) {
        oraclePo.getProps().put("USERNAME", po.getProps().get("USERNAME"));
        oraclePo.getProps().put("PASSWD", po.getProps().get("PASSWD"));
        oraclePo.getProps().put("ASM_USERNAME", po.getProps().get("ASM_USERNAME"));
        oraclePo.getProps().put("ASM_PASSWD", po.getProps().get("ASM_PASSWD"));
        oraclePo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
        oraclePo.getProps().put("IS_CLUSTER", String.valueOf(1));
        oraclePo.getProps().put("AUTH_TYPE", po.getProps().get("AUTH_TYPE"));
        oraclePo.getProps().put("ARCHIVE_LOG", po.getProps().get("ARCHIVE_LOG"));
        oraclePo.getProps().put("ORACLE_HOME", po.getProps().get("ORACLE_HOME"));
    }

    public void setOracleManager(OracleManagerImpl manager) {
        this.oracleManager = manager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public List<ProtectObject> getSupportProtectObjectTypes() {
        logger.debug((Object)"get oracle support protect object types.", 90160758786988L);
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(1);
        po.setName("Oracle");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        return 1;
    }

    public void buildSubAppProtectObjects(ProtectGroup protectGroup) {
        if (protectGroup == null || protectGroup.getPolist() == null) {
            logger.error((Object)"build po,pg is null or poList is null.", 90160758786989L);
            return;
        }
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>(protectGroup.getPolist());
        for (ProtectObject protectObject : poList) {
            String archiveLog = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (VerifyUtil.isEmpty((String)archiveLog)) {
                protectObject.getProps().put("ARCHIVE_LOG", "0");
            }
            this.updateDatabaseProtectObject(protectObject, protectGroup.getPoProviderSN());
        }
        this.checkparam(poList);
        this.loadProtectObjectStorageInfo(poList);
    }

    private void checkparam(List<ProtectObject> poList) {
        if (null == poList || poList.isEmpty()) {
            logger.error((Object)"poList is null or empty.", 90160758786989L);
            return;
        }
        String archiveLog = null;
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : poList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (null == tempList || tempList.isEmpty()) {
                logger.debug((Object)("storageInfo is null or empty on " + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786989L);
                continue;
            }
            protectObject.clearUsedStorageResource();
            archiveLog = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (!"1".equals(archiveLog)) continue;
            break;
        }
    }

    public void updateProtectObjectsProps(ProtectGroup protectGroup) {
        Set poList = protectGroup.getPolist();
        for (ProtectObject po : poList) {
            if (!"1".equals(po.getProps().get("IS_CDB"))) continue;
            logger.info((Object)"start refresh oracle 12c plug database.");
            this.queryPlugDatabase(po);
            logger.info((Object)"end refresh oracle 12c plug database.");
        }
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> terms) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(poProviderSn);
        if (drResource instanceof DrHost) {
            return this.getAvailableProtectObjectByHostSn(poProviderSn, DrmEnumDefine.ProviderTypeE.HOST.getValue(), null, terms);
        }
        if (drResource instanceof DrHostGroup) {
            int hostGroup = DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue();
            return this.getAvailableProtectObjectByHostGrpSn(poProviderSn, hostGroup, null, terms);
        }
        logger.debug((Object)("get oracle available protect object is null,poProviderSn=" + poProviderSn), 90160758786989L);
        return null;
    }

    private void updateDatabaseProtectObject(ProtectObject porotectObject, String poProviderSn) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(poProviderSn);
        Database database = this.getEntityByCondition(Database.class, "uuid", porotectObject.getMoUuid());
        if (database == null) {
            logger.error((Object)("database is null,MoUuid=" + porotectObject.getMoUuid()), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        ManagedObject mo = database.getParentMo();
        if (mo == null || !(mo instanceof DatabaseInstance)) {
            logger.error((Object)"databaseInstance is null or nut instanceof DatabaseInstance");
            throw new LegoCheckedException(1073947394L);
        }
        DatabaseInstance instance = (DatabaseInstance)mo;
        String version = instance.getDbVersion();
        if (null != version && version.startsWith("12.2") && !"0".equals(database.getDbStatus())) {
            logger.error((Object)"databaseInstance status is 1");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        conditionMap.put("name", database.getName());
        List<ProtectObject> origins = Arrays.asList(porotectObject);
        if (drResource instanceof DrHost) {
            this.getAvailableProtectObjectByHostSn(poProviderSn, DrmEnumDefine.ProviderTypeE.HOST.getValue(), origins, conditionMap);
        } else if (drResource instanceof DrHostGroup) {
            this.getAvailableProtectObjectByHostGrpSn(poProviderSn, DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue(), origins, conditionMap);
        }
    }

    private <T extends ManagedObject> T getEntityByCondition(Class<T> clazz, String key, Object value) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(key, value);
        List items = CommonDAOLocator.getMoDao().findMoBy(clazz, props);
        if (items == null || items.isEmpty() || items.size() > 1) {
            return null;
        }
        return (T)((ManagedObject)items.get(0));
    }

    private List<ProtectObject> getAvailableProtectObjectByHostGrpSn(String hostGrpSn, int providerType, List<ProtectObject> origins, Map<String, Object> terms) {
        List<String> hostSNList = this.getHostGroupListByDeviceSN(hostGrpSn);
        HashMap<String, ProtectObject> poMap = new HashMap<String, ProtectObject>();
        for (String hostSN : hostSNList) {
            List<ProtectObject> pos = this.getAvailableProtectObjectByHostSn(hostSN, providerType, origins, terms);
            for (int i = 0; i < pos.size(); ++i) {
                ProtectObject po = pos.get(i);
                if (poMap.get(po.getName()) == null) {
                    poMap.put(po.getName(), po);
                }
                this.updateServiceName(poMap, po);
            }
        }
        ArrayList list = new ArrayList();
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
        list.addAll(poMap.values());
        for (ProtectObject po : list) {
            String countStr = (String)((ProtectObject)poMap.get(po.getName())).getProps().get("DBCOUNT");
            if (countStr == null || NumberUtil.convertToInteger((Object)countStr).intValue() != hostSNList.size()) {
                logger.error((Object)("po(" + po.getName() + ") size =" + countStr + ",host size = " + hostSNList.size()), 90160758786896L);
                continue;
            }
            ((ProtectObject)poMap.get(po.getName())).getProps().remove("DBCOUNT");
            po.setProviderSN(hostGrpSn);
            result.add(po);
        }
        return result;
    }

    private void updateServiceName(Map<String, ProtectObject> map, ProtectObject protectObject) {
        this.buildInstanceOrServiceName("INSTANCENAME", map, protectObject);
        this.buildInstanceOrServiceName("SERVICENAME", map, protectObject);
        ProtectObject po = map.get(protectObject.getName());
        if (null == po) {
            logger.error((Object)"po is null");
            throw new LegoCheckedException(1073947393L);
        }
        String countStr = (String)po.getProps().get("DBCOUNT");
        if (null == countStr) {
            po.getProps().put("DBCOUNT", "1");
        } else {
            int count = NumberUtil.convertToInteger((Object)countStr);
            po.getProps().put("DBCOUNT", String.valueOf(++count));
        }
    }

    private void buildInstanceOrServiceName(String instOrServiceKey, Map<String, ProtectObject> map, ProtectObject protectObject) {
        ProtectObject po;
        String instOrServiceValue;
        ProtectObject tempPo = map.get(protectObject.getName());
        if (null == tempPo) {
            throw new LegoCheckedException(1073947393L);
        }
        String instances = (String)tempPo.getProps().get(instOrServiceKey);
        JSONArray jsonArray = null;
        if (instances != null) {
            try {
                jsonArray = JSONArray.fromObject((Object)instances);
            }
            catch (Exception e) {
                jsonArray = null;
                logger.error((Object)("Convert JsonArray error. instances: " + instances), 90160758786896L);
            }
        }
        if (null == jsonArray) {
            jsonArray = new JSONArray();
        }
        if (null == (instOrServiceValue = (String)protectObject.getProps().get(instOrServiceKey))) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExistValue = false;
        for (Object object : jsonArray) {
            JSONObject jsonObject = JSONObject.fromObject(object);
            if (!instOrServiceValue.equals(JsonUtil.getString((JSONObject)jsonObject, (String)instOrServiceKey, (String[])new String[]{""}))) continue;
            isExistValue = true;
            break;
        }
        if (!isExistValue) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)instOrServiceKey, (Object)instOrServiceValue);
            jsonObject.put((Object)"ip", (Object)protectObject.getProviderSN());
            jsonArray.add((Object)jsonObject);
        }
        if (null == (po = map.get(protectObject.getName()))) {
            throw new LegoCheckedException(1073947393L);
        }
        po.getProps().put(instOrServiceKey, jsonArray.toString());
    }

    private List<String> getHostGroupListByDeviceSN(String hostGrpSn) {
        ArrayList<String> hostSNList = new ArrayList<String>();
        IHostGroupService hostGroupService = (IHostGroupService)ServiceContext.getInstance().lookup("DRM_Host/" + IHostGroupService.class.getName());
        List drGroups = hostGroupService.getHostGroupListByDeviceSN(hostGrpSn);
        for (DrHostGroup group : drGroups) {
            for (DrResource host : group.getChildResources()) {
                hostSNList.add(host.getDeviceSn());
            }
        }
        Collections.sort(hostSNList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareTo(o1);
            }
        });
        return hostSNList;
    }

    private List<ProtectObject> getAvailableProtectObjectByHostSn(String hostSn, int providerType, List<ProtectObject> origins, Map<String, Object> terms) {
        List databases = DatabaseApplicationUtil.queryAllDatabaseInstance((String)hostSn, (int)1, terms);
        if (VerifyUtil.isEmpty((Collection)databases)) {
            return Collections.emptyList();
        }
        ArrayList<ProtectObject> list = new ArrayList<ProtectObject>();
        origins = Optional.ofNullable(origins).orElseGet(Collections::emptyList);
        databases.removeIf(database -> Boolean.TRUE.equals(database.getStandby()));
        for (Database database2 : databases) {
            OracleInstance dbInstance = (OracleInstance)database2.getParentMo();
            ProtectObject protectObject = this.getProtectObjectByUuid(origins, database2.getUuid());
            protectObject = this.convertDatabaseToProtectObject(dbInstance, database2, hostSn, providerType, protectObject);
            list.add(protectObject);
        }
        return list;
    }

    private ProtectObject getProtectObjectByUuid(List<ProtectObject> protectObjects, String uuid) {
        for (ProtectObject protectObject : protectObjects) {
            if (!uuid.equals(protectObject.getMoUuid())) continue;
            return protectObject;
        }
        return null;
    }

    private ProtectObject convertDatabaseToProtectObject(OracleInstance dbInstance, Database database, String hostSn, int providerType, ProtectObject origin) {
        ProtectObject protectObject = origin != null ? origin : new ProtectObject();
        protectObject.setMoUuid(database.getUuid());
        if (VerifyUtil.isEmpty((String)protectObject.getUuid())) {
            protectObject.setUuid(UUIDGenerator.getUUID());
        }
        protectObject.setName(database.getName());
        protectObject.setPoStatus(NumberUtil.convertToInteger((Object)database.getDbStatus()).intValue());
        protectObject.setPoType(1);
        protectObject.setProviderSN(hostSn);
        protectObject.setProviderName(dbInstance.getParentMo().getName());
        protectObject.getProps().put("VERSION", dbInstance.getDbVersion());
        protectObject.getProps().put("IS_ASM", dbInstance.getUseAsm() != false ? "1" : "0");
        protectObject.getProps().put("DATABASES", database.getName());
        protectObject.getProps().put("INSTANCENAME", dbInstance.getInstanceName());
        protectObject.getProps().put("SERVICENAME", dbInstance.getServiceName());
        protectObject.getProps().put("PROVIDER_TYPE", String.valueOf(providerType));
        protectObject.getProps().put("ORACLE_HOME", dbInstance.getOracleHome());
        protectObject.getProps().put("DB_ID", dbInstance.getDbId());
        return protectObject;
    }

    public List<ProtectObjectStorageInfo> getPoStorageInfo(ProtectObject po) {
        if (null == po) {
            logger.error((Object)"get storageInfo fail,po is null", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List<ProtectObjectStorageInfo> list = this.getPoStorageInfoForHostGroup(po);
        if (null == list || list.isEmpty()) {
            logger.error((Object)("get po(" + po.getName() + "," + po.getProviderSN() + ") storage info,result is null."), 90160758786989L);
            return null;
        }
        po.setUsedStorageResourceSet(new HashSet<ProtectObjectStorageInfo>(list));
        this.filterArchieveLogLun(list, po);
        this.checkLunInfo(list, po);
        this.initStorageInfoID(list);
        return list;
    }

    private List<ProtectObjectStorageInfo> getPoStorageInfoForHostGroup(ProtectObject po) {
        List<ProtectObject> poList;
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(po.getProviderSN());
        List<ProtectObject> list = poList = resource instanceof DrHost ? this.makeHostGroupPO(po) : this.makeHostGroupPOs(po.getProviderSN(), po.getName());
        if (VerifyUtil.isEmpty(poList)) {
            logger.info((Object)("get po(" + po.getName() + "," + po.getProviderSN() + ") storage info,poList is null."), 90160758786989L);
            throw new LegoCheckedException(1073947393L, "the po list is empty.");
        }
        LegoCheckedException legoException = null;
        ArrayList<ProtectObjectStorageInfo> list2 = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject oraclePo : poList) {
            OracleProvider.resetProtectObject(po, oraclePo);
            try {
                this.queryLun(list2, oraclePo, "0");
                if (VerifyUtil.isEmpty(list2)) {
                    logger.error((Object)("get storage info is null on " + oraclePo.getName() + "," + oraclePo.getProviderSN()), 90160758786989L);
                    return null;
                }
                this.queryArchiveLogLun(list2, oraclePo);
                legoException = null;
                int rac = DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue();
                if (!(resource instanceof DrHostGroup) || ((DrHostGroup)resource).getClusterType() == rac) continue;
                logger.debug((Object)("ap cluster:" + oraclePo.getName() + "," + oraclePo.getProviderSN()), 90160758786989L);
                break;
            }
            catch (LegoCheckedException le) {
                logger.error((Object)("get storage info failed on " + oraclePo.getName() + "," + oraclePo.getProviderSN()), (Throwable)le, le.getErrorCode());
                legoException = le;
            }
        }
        if (null != legoException) {
            throw legoException;
        }
        return list2;
    }

    private void queryLun(List<ProtectObjectStorageInfo> list, ProtectObject oraclePo, String archiveTag) {
        if (!VerifyUtil.isEmpty(list) && "0".equals(archiveTag)) {
            return;
        }
        oraclePo.getProps().put("ARCHIVE_LOG", archiveTag);
        this.oracleManager.generateLUNDetail(oraclePo);
        if (VerifyUtil.isEmpty((Collection)oraclePo.getUsedStorageResourceSet())) {
            logger.error((Object)("get storage info is null on " + oraclePo.getName() + "," + oraclePo.getProviderSN() + ",archiveTag=" + archiveTag), 90160758786989L);
            return;
        }
        for (ProtectObjectStorageInfo protectObjectStorageInfo : oraclePo.getUsedStorageResourceSet()) {
            protectObjectStorageInfo.setArchiveLog(Integer.valueOf(Integer.parseInt(archiveTag)));
        }
        list.addAll(oraclePo.getUsedStorageResourceSet());
        oraclePo.clearUsedStorageResource();
    }

    private void queryArchiveLogLun(List<ProtectObjectStorageInfo> list, ProtectObject oraclePo) {
        try {
            this.queryLun(list, oraclePo, "1");
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("query archive log exception on " + oraclePo.getName() + "," + oraclePo.getProviderSN()), (Throwable)le, 90160758786989L);
        }
        catch (Exception e) {
            logger.error((Object)("query archive log exception on " + oraclePo.getName() + "," + oraclePo.getProviderSN() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private List<ProtectObject> makeHostGroupPO(ProtectObject protectObject) {
        ArrayList<ProtectObject> list = new ArrayList<ProtectObject>();
        String sn = protectObject.getProviderSN();
        ProtectObject temp = new ProtectObject();
        temp.setProviderSN(sn);
        temp.setPoType(1);
        temp.getProps().putAll(protectObject.getProps());
        temp.setUsedStorageResourceSet(protectObject.getUsedStorageResourceSet());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("hostSN", sn);
        props.put("dbType", 1);
        List instances = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, props);
        Object[] moIds = new Long[instances.size()];
        for (int i = 0; i < instances.size(); ++i) {
            moIds[i] = ((DatabaseInstance)instances.get(i)).getMoId();
        }
        props = new HashMap();
        props.put("parentMo.moId", moIds);
        List databases = CommonDAOLocator.getMoDao().findMoBy(Database.class, props);
        if (VerifyUtil.isEmpty((Collection)databases)) {
            logger.error((Object)("Database is empty in DB,hostSN:" + sn + ",parentMo.moId:" + Arrays.toString(moIds) + ",poName:" + protectObject.getName()));
        }
        for (Database db : databases) {
            if (!db.getName().equalsIgnoreCase(protectObject.getName())) continue;
            OracleInstance instace = (OracleInstance)db.getParentMo();
            temp.getProps().put("SERVICENAME", instace.getServiceName());
            temp.getProps().put("INSTANCENAME", instace.getInstanceName());
            break;
        }
        String serviceName = (String)temp.getProps().get("SERVICENAME");
        String instanceName = (String)temp.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)serviceName) || VerifyUtil.isEmpty((String)instanceName)) {
            logger.error((Object)("Database is empty in DB,hostSN:" + sn + ",parentMo.moId:" + Arrays.toString(moIds) + ",poName:" + protectObject.getName() + ",SERVICENAME:" + serviceName + ",INSTANCENAME:" + instanceName));
        }
        logger.debug((Object)("po:" + temp.getName() + ",SERVICENAME:" + serviceName + ",INSTANCENAME:" + instanceName));
        list.add(temp);
        return list;
    }

    private void initStorageInfoID(List<ProtectObjectStorageInfo> infos) {
        for (ProtectObjectStorageInfo info : infos) {
            if (!VerifyUtil.isEmpty((String)info.getId())) continue;
            info.setId(UUIDGenerator.getUUID());
        }
    }

    private void filterArchieveLogLun(List<ProtectObjectStorageInfo> infos, ProtectObject po) {
        String archieve = (String)po.getProps().get("ARCHIVE_LOG");
        ProtectGroup protectGroup = po.getProtectGroup();
        po.getProps().put("DrRing.Limits", "1");
        if (VerifyUtil.isEmpty((String)archieve) || null == protectGroup) {
            logger.debug((Object)("archieve or pg is null on " + po.getName() + "," + po.getProviderSN()), 90160758786988L);
            return;
        }
        if ("1".equals(archieve)) {
            po.getProps().put("DrRing.Limits", "2");
            return;
        }
        ArrayList<ProtectObjectStorageInfo> dataStorageInfo = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObjectStorageInfo info : infos) {
            if (null != info.getArchiveLog() && info.getArchiveLog() != 0) continue;
            dataStorageInfo.add(info);
        }
        infos.clear();
        infos.addAll(dataStorageInfo);
    }

    private void checkLunInfo(List<ProtectObjectStorageInfo> storageInfoList, ProtectObject po) {
        String archive = (String)po.getProps().get("ARCHIVE_LOG");
        if (!"1".equals(archive)) {
            logger.debug((Object)"The archive is null or 0 on, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            return;
        }
        ArrayList<String> dataLunWwns = new ArrayList<String>();
        ArrayList<String> logLunWwns = new ArrayList<String>();
        storageInfoList.forEach(storageInfo -> {
            if (storageInfo.getArchiveLog() == 1) {
                logLunWwns.add(storageInfo.getLunWWN());
            } else {
                dataLunWwns.add(storageInfo.getLunWWN());
            }
        });
        if (this.isOracleAdg(po)) {
            logger.info((Object)"The po is for oracle ADG, should not check.");
            return;
        }
        Optional<String> checkOpt = logLunWwns.stream().filter(dataLunWwns::contains).findAny();
        if (checkOpt.isPresent()) {
            logger.error((Object)"The oracle data lun and archive log lun is same, poName: %s, providerSn: %s, dataLunWwns: %s, logLunWwns: %s", new Object[]{po.getName(), po.getProviderSN(), dataLunWwns, logLunWwns});
            throw new LegoCheckedException(1073948235L);
        }
        if (VerifyUtil.isEmpty(logLunWwns)) {
            logger.error((Object)"StorageInfo no contain archive log, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073948236L);
        }
        this.checkConsistent(dataLunWwns, logLunWwns);
    }

    private boolean isOracleAdg(ProtectObject po) {
        try {
            if (po.getUsedStorageResourceSet().stream().allMatch(r -> r.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue())) {
                return false;
            }
            Set hosts = DrHostUtil.getDrHostsByHostOrGroupId((String)po.getProviderSN());
            DrResource drResource = (DrResource)hosts.stream().findFirst().orElseThrow(() -> new LegoCheckedException(1073947700L));
            INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend neExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)drResource.getDeviceSn());
            Map extendParams = neExtend.getExtendParams();
            if (!extendParams.containsKey("isAgentless") || !Boolean.parseBoolean((String)extendParams.get("isAgentless"))) {
                return false;
            }
            OracleAppUtil.checkAllInstanceStatus(po, false);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"The poName: %s is not a normal Oracle ADG.", new Object[]{po.getName()});
            if (OracleErrorCode.CONTROL_FILE_ERRORS.contains(e.getErrorCode()) || e.getErrorCode() == 1073948515L) {
                throw e;
            }
            if (e.getErrorCode() == 1073948534L) {
                logger.warn((Object)"The adg is not max performance.");
                return true;
            }
            return false;
        }
        return true;
    }

    public List<PolicyTemplate> getAppSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        List list = this.policyTemplateManager.getAllTemplate(0L);
        ArrayList<PolicyTemplate> supportList = new ArrayList<PolicyTemplate>();
        for (PolicyTemplate policy : list) {
            if (!POLICIES.contains(policy.getType())) continue;
            supportList.add(policy);
        }
        logger.debug((Object)"get oracle support policy template.", 90160758786988L);
        return supportList;
    }

    public boolean testProtectObject(ProtectObject po) {
        if (null == po) {
            logger.error((Object)"test po,po is null", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (po.getPoType() == 14) {
            logger.debug((Object)("po is nas,not test,po:" + po.getName() + "," + po.getProviderSN()), 90160758786988L);
            return true;
        }
        this.initPasswords(po, po.getProps());
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(po.getProviderSN());
        if (resource == null) {
            logger.debug((Object)("test po, the Resource of testProtectObject is null on " + po.getName() + "," + po.getProviderSN()), 90160758786989L);
            throw new LegoCheckedException(1073947393L, "the Resource of testProtectObject is null");
        }
        if (resource instanceof DrHost) {
            return this.testPoForHost(po);
        }
        return this.testPoForHostGroup(po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPasswords(ProtectObject protectObject, Map<String, String> props) {
        List results;
        String poUuid = protectObject.getUuid();
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        Session session = null;
        try {
            session = baseDao.getHibernateTemplate().getSessionFactory().openSession();
            String sql = "select p.PROPNAME, p.PROPVALUE from ti_po_prop p left join ti_protectobject o on o.POID = p.POID where p.POID=:poid";
            NativeQuery query = session.createSQLQuery(sql);
            query.setParameter("poid", (Object)poUuid);
            results = query.list();
        }
        catch (Throwable throwable) {
            DBOperationUtil.closeSession(session);
            throw throwable;
        }
        DBOperationUtil.closeSession((Session)session);
        if (VerifyUtil.isEmpty((Collection)results)) {
            return;
        }
        this.updatePropValue(protectObject, props, results, "AUTH_TYPE");
        this.updatePropValue(protectObject, props, results, "IS_ASM");
        this.updatePropValue(protectObject, props, results, "ARCHIVE_LOG");
        if ("1".equals(String.valueOf(props.get("AUTH_TYPE")))) {
            this.updatePropValue(protectObject, props, results, "ASM_INSTANCENAME");
        } else {
            this.updatePropValue(protectObject, props, results, "USERNAME");
            this.updatePropValue(protectObject, props, results, "PASSWD");
            this.updatePropValue(protectObject, props, results, "ASM_USERNAME");
            this.updatePropValue(protectObject, props, results, "ASM_INSTANCENAME");
            this.updatePropValue(protectObject, props, results, "ASM_PASSWD");
        }
    }

    private void updatePropValue(ProtectObject protectObject, Map<String, String> props, List<?> items, String key) {
        if (props == null) {
            logger.debug((Object)"props is null,not update PropValue.");
            return;
        }
        if (!VerifyUtil.isEmpty((String)props.get(key))) {
            protectObject.getProps().put(key, props.get(key));
            return;
        }
        for (Object item : items) {
            Object[] record = (Object[])item;
            if (!key.equals(record[0])) continue;
            if (!(record[1] instanceof String)) break;
            props.put(key, (String)record[1]);
            protectObject.getProps().put(key, (String)record[1]);
            break;
        }
    }

    private boolean testPoForHostGroup(ProtectObject po) {
        List<ProtectObject> poList = this.makeHostGroupPOs(po.getProviderSN(), po.getName());
        if (VerifyUtil.isEmpty(poList)) {
            logger.debug((Object)("test po,poList is null on" + po.getName() + "," + po.getProviderSN()), 90160758786989L);
            throw new LegoCheckedException(1073947393L, "the po list is empty.");
        }
        LegoCheckedException legoException = null;
        for (ProtectObject oraclePo : poList) {
            oraclePo.getProps().put("USERNAME", po.getProps().get("USERNAME"));
            oraclePo.getProps().put("PASSWD", po.getProps().get("PASSWD"));
            oraclePo.getProps().put("IS_ASM", po.getProps().get("IS_ASM"));
            oraclePo.getProps().put("ASM_INSTANCENAME", po.getProps().get("ASM_INSTANCENAME"));
            oraclePo.getProps().put("ASM_USERNAME", po.getProps().get("ASM_USERNAME"));
            oraclePo.getProps().put("ASM_PASSWD", po.getProps().get("ASM_PASSWD"));
            oraclePo.getProps().put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
            oraclePo.getProps().put("AUTH_TYPE", po.getProps().get("AUTH_TYPE"));
            oraclePo.getProps().put("ORACLE_HOME", po.getProps().get("ORACLE_HOME"));
            try {
                this.oracleManager.testConnecting(oraclePo);
                return true;
            }
            catch (LegoCheckedException le) {
                logger.error((Object)("testProtectObject failed on" + po.getName() + "," + po.getProviderSN()), (Throwable)le, le.getErrorCode());
                legoException = le;
            }
            catch (Exception e) {
                logger.error((Object)("testProtectObject failed on" + po.getName() + "," + po.getProviderSN() + ExceptionUtil.getErrorMessage((Throwable)e)), 1073948167L);
                legoException = new LegoCheckedException(1073948167L);
            }
        }
        if (null != legoException) {
            throw legoException;
        }
        return true;
    }

    private boolean testPoForHost(ProtectObject po) {
        try {
            this.oracleManager.testConnecting(po);
            return true;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("test po failed on" + po.getName() + "," + po.getProviderSN()), (Throwable)le, le.getErrorCode());
            throw le;
        }
    }

    private List<ProtectObject> makeHostGroupPOs(String hostGroupSN, String dbName) {
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        List<String> hostSNList = this.getHostGroupListByDeviceSN(hostGroupSN);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("dbType", 1);
        Iterator<String> iterator = hostSNList.iterator();
        HashMap<String, Object> otherProps = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            this.updatePoList(dbName, poList, props, iterator, otherProps);
        }
        return poList;
    }

    private void updatePoList(String dbName, List<ProtectObject> poList, Map<String, Object> props, Iterator<String> iterator, Map<String, Object> otherProps) {
        if (!iterator.hasNext()) {
            logger.error((Object)"hostsn iterator is null");
            return;
        }
        String hostSN = iterator.next();
        ProtectObject po = new ProtectObject();
        po.setProviderSN(hostSN);
        po.setPoType(1);
        props.put("hostSN", hostSN);
        List allDBIns = CommonDAOLocator.getMoDao().findMoBy(DatabaseInstance.class, "name", true, props);
        if (VerifyUtil.isEmpty((Collection)allDBIns)) {
            logger.error((Object)("DatabaseInstance is empty in DB,hostSN:" + hostSN));
        }
        for (DatabaseInstance baseInstance : allDBIns) {
            if (!(baseInstance instanceof OracleInstance)) {
                logger.error((Object)("DatabaseInstance is not OracleInstance,hostSN:" + hostSN + "," + baseInstance.getName()));
                continue;
            }
            OracleInstance current = (OracleInstance)baseInstance;
            Database db = null;
            otherProps.put("parentMo.moId", current.getMoId());
            List allDB = CommonDAOLocator.getMoDao().findMoBy(Database.class, "name", true, otherProps);
            for (Database temp : allDB) {
                if (!dbName.equals(temp.getName())) continue;
                db = temp;
                break;
            }
            if (null == db) {
                logger.error((Object)("db(" + dbName + ") is not exist in db,hostSN:" + hostSN + "," + baseInstance.getName() + ",parentMo.moId=" + current.getMoId()));
                continue;
            }
            po.setProtectMo(db);
            po.setMoUuid(db.getUuid());
            po.setUuid(UUIDGenerator.getUUID());
            po.setPoType(1);
            po.setProviderSN(hostSN);
            po.setProviderName(current.getParentMo().getName());
            po.setName(db.getName());
            po.setPoStatus(current.getInstanceStatus());
            po.getProps().put("INSTANCENAME", current.getInstanceName());
            po.getProps().put("DATABASES", dbName);
            po.getProps().put("SERVICENAME", current.getServiceName());
            po.getProps().put("APP_VERSION", current.getDbVersion());
            logger.debug((Object)("db:" + db.getName() + ",SERVICENAME:" + current.getServiceName() + ",INSTANCENAME:" + current.getInstanceName()));
            break;
        }
        poList.add(po);
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(poProviderSn);
        List<ProtectObject> allDB = null;
        if (drResource instanceof DrHost) {
            allDB = this.getAvailableProtectObjectByHostSn(poProviderSn, DrmEnumDefine.ProviderTypeE.HOST.getValue(), null, extParamInQueryParam);
        } else if (drResource instanceof DrHostGroup) {
            allDB = this.getAvailableProtectObjectByHostGrpSn(poProviderSn, DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue(), null, extParamInQueryParam);
        } else {
            logger.info((Object)("invalid drResource:" + drResource.getClass()), 90160758786989L);
        }
        List existPos = this.getRegisteredProtectObjectByHost(poProviderSn, pgId, 1);
        if (VerifyUtil.isEmpty((Collection)existPos) || null == allDB) {
            logger.debug((Object)("has no po in db or in pg,poProviderSn=" + poProviderSn), 90160758786989L);
            return null;
        }
        this.removeExistPo(pgId, allDB, existPos);
        return allDB;
    }

    private void removeExistPo(String pgId, List<ProtectObject> allDB, List<ProtectObject> existPos) {
        ArrayList<ProtectObject> tempPos = new ArrayList<ProtectObject>();
        block0: for (int i = allDB.size() - 1; i >= 0; --i) {
            ProtectObject db = allDB.get(i);
            for (ProtectObject po : existPos) {
                if (!db.getName().equals(po.getName()) || !po.getProtectGroup().getUuid().equals(pgId)) continue;
                tempPos.add(db);
                continue block0;
            }
        }
        allDB.removeAll(tempPos);
    }

    public void refreshAppProtectObjectProperties(List<ProtectObject> protectObjectList) {
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        for (ProtectObject po : protectObjectList) {
            if (null == po.getProps()) continue;
            po.getProps().remove("PASSWD");
            po.getProps().remove("ASM_PASSWD");
        }
        logger.debug((Object)"refresh oracle protect object properties.", 90160758786988L);
    }

    public void updateProtectObjectProps(ProtectObject protectObject, Map<String, String> props) {
        if (props == null) {
            logger.error((Object)"update po props, props is null", 90160758786989L);
            return;
        }
        super.updateProtectObjectProps(protectObject, props);
        if (protectObject.getPoType() == 14) {
            String msg = "po is nas,po:" + protectObject.getName() + "," + protectObject.getProviderSN();
            logger.debug((Object)msg, 90160758786988L);
            return;
        }
        this.initPasswords(protectObject, props);
        String authType = props.get("AUTH_TYPE");
        if (!"0".equals(authType) && !"1".equals(authType)) {
            logger.error((Object)("authType is not db or os on" + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        this.checkDbParam(props);
        this.checkAsmParam(props);
        this.checkArchieveParam(protectObject, props);
        this.queryPlugDatabase(protectObject);
    }

    private void queryPlugDatabase(ProtectObject po) {
        List<ProtectObject> poList;
        if (VerifyUtil.isEmpty((Object)po.getProtectGroup())) {
            logger.error((Object)"po.getProtectGroup is null >>>>> ");
            return;
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource resource = resourceService.getDrResourceBySn(po.getProviderSN());
        List<ProtectObject> list = poList = resource instanceof DrHost ? this.makeHostGroupPO(po) : this.makeHostGroupPOs(po.getProviderSN(), po.getName());
        if (VerifyUtil.isEmpty(poList)) {
            logger.info((Object)("get po(" + po.getName() + "," + po.getProviderSN() + ") plug database info,poList is null."), 90160758786989L);
            throw new LegoCheckedException(1073947393L, "the po list is empty.");
        }
        LegoCheckedException legoException = null;
        for (ProtectObject oraclePo : poList) {
            try {
                oraclePo.getProps().put("USERNAME", po.getProps().get("USERNAME"));
                oraclePo.getProps().put("PASSWD", po.getProps().get("PASSWD"));
                oraclePo.getProps().put("ASM_USERNAME", po.getProps().get("ASM_USERNAME"));
                oraclePo.getProps().put("ASM_PASSWD", po.getProps().get("ASM_PASSWD"));
                OracleAppUtil.queryPlugDatabase(oraclePo);
                po.getProps().put("IS_CDB", oraclePo.getProps().get("IS_CDB"));
                po.getProps().put("PDB", oraclePo.getProps().get("PDB"));
                legoException = null;
                break;
            }
            catch (LegoCheckedException le) {
                logger.error((Object)("query plug database fail,name is " + po.getName() + ",providerSN is " + po.getProviderSN()));
                legoException = le;
            }
            catch (Exception e) {
                logger.error((Object)("query plug database fail,name is " + po.getName() + ",providerSN is " + po.getProviderSN()));
                legoException = new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        if (null != legoException) {
            throw legoException;
        }
    }

    private void checkDbParam(Map<String, String> props) {
        String authType = props.get("AUTH_TYPE");
        String userName = props.get("USERNAME");
        String pwd = props.get("PASSWD");
        if ("0".equals(authType)) {
            this.checkParam(userName);
            this.checkParam(pwd);
        }
    }

    private void checkAsmParam(Map<String, String> props) {
        String authType = props.get("AUTH_TYPE");
        String asmUserName = props.get("ASM_USERNAME");
        String asmpwd = props.get("ASM_PASSWD");
        String dbIsAsm = props.get("IS_ASM");
        if (!"1".equals(dbIsAsm)) {
            logger.debug((Object)"po is not asm.", 90160758786988L);
            return;
        }
        String asmInstance = props.get("ASM_INSTANCENAME");
        if (!DrHostValidUtil.checkUserName((String)asmInstance)) {
            logger.error((Object)("asmInstance is valid:" + asmInstance), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if ("0".equals(authType)) {
            this.checkParam(asmUserName);
            this.checkParam(asmpwd);
        }
    }

    private void checkParam(String param) {
        if (null == param || param.isEmpty()) {
            logger.error((Object)"param is valid.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkArchieveParam(ProtectObject protectObject, Map<String, String> props) {
        String archieve = props.get("ARCHIVE_LOG");
        if (VerifyUtil.isEmpty((String)archieve)) {
            logger.debug((Object)("archieve is null on " + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786988L);
            return;
        }
        if (!"0".equals(archieve) && !"1".equals(archieve)) {
            logger.error((Object)("archieve is not 0 or 1 on " + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (null == protectObject.getProtectGroup()) {
            logger.debug((Object)("pg is null on " + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786988L);
            return;
        }
        if ("0".equals(archieve)) {
            logger.debug((Object)("archieve is 0 on " + protectObject.getName() + "," + protectObject.getProviderSN()), 90160758786988L);
            return;
        }
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
        super.checkPolicyProps(policyTemplate);
        Set scheduleSet = policyTemplate.getSchedules();
        for (Schedule schedule : scheduleSet) {
            String capacity = (String)schedule.getExtParameters().get("ORACLE_CAP_THREASHOLD");
            if (VerifyUtil.isEmpty((String)capacity)) {
                logger.info((Object)("capacity is null when enable hot recorver,ptId=" + policyTemplate.getPtId()), 90160758787071L);
                continue;
            }
            this.validThreasholdCap(capacity);
        }
    }

    private List<ProtectGroup> getProtectGroupByTypeNoScope(int poType) {
        List list;
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria crit = session.createCriteria(ProtectGroup.class);
            crit.add((Criterion)Restrictions.eq((String)"poType", (Object)poType));
            list = crit.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)("failed to query ProtectGroup,poType=" + poType), (Throwable)e, 90160758786896L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    private void validThreasholdCap(String capacity) {
        int capThreshold = 0;
        try {
            capThreshold = Integer.parseInt(capacity);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Parsing failed. obj:" + capacity), (long)1073947393L, null, (Log)logger);
        }
        if (0 > capThreshold || 0x100000 < capThreshold) {
            logger.error((Object)("capacity out of range:" + capThreshold), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        if (capThreshold > 1024 && 0 != capThreshold % 1024) {
            logger.error((Object)("capacity is invalid when more than 1024M\uff1a" + capThreshold), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void loadAppStorageInfo(List<ProtectObject> protectObjectList) {
        if (null == protectObjectList || protectObjectList.isEmpty()) {
            logger.error((Object)"load app storageInfo,polist is null.", 90160758787071L);
            return;
        }
        IBaseDao baseDao = CommonDAOLocator.getBaseDao();
        for (ProtectObject protectObject : protectObjectList) {
            String uuid = protectObject.getUuid();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("protectObjectUuId", uuid);
            List criterionList = baseDao.translatePropsToCriterions(map);
            List tempList = baseDao.createCriteria(ProtectObjectTempStorageInfo.class, criterionList.toArray(new Criterion[criterionList.size()]));
            if (null == tempList || tempList.isEmpty()) continue;
            protectObject.clearUsedStorageResource();
            String archiveLog = (String)protectObject.getProps().get("ARCHIVE_LOG");
            if (VerifyUtil.isEmpty((String)archiveLog)) {
                archiveLog = "0";
            }
            this.loadAppStorageInfo(protectObject, tempList, archiveLog);
        }
    }

    private void loadAppStorageInfo(ProtectObject po, List<ProtectObjectTempStorageInfo> tempList, String archiveLog) {
        ArrayList<String> dataLunWwns = new ArrayList<String>();
        ArrayList<String> logLunWwns = new ArrayList<String>();
        String drRingLimits = "0".equals(archiveLog) ? "1" : "2";
        po.getProps().put("DrRing.Limits", drRingLimits);
        for (ProtectObjectTempStorageInfo tempStorageInfo : tempList) {
            if ("0".equals(archiveLog) && tempStorageInfo.getArchiveLog() == 1) continue;
            if (tempStorageInfo.getArchiveLog() == 1) {
                logLunWwns.add(tempStorageInfo.getLunWWN());
            } else {
                dataLunWwns.add(tempStorageInfo.getLunWWN());
            }
            ProtectObjectStorageInfo storageInfo = new ProtectObjectStorageInfo();
            ObjectConvert.convert((Object)tempStorageInfo, (Object)storageInfo);
            storageInfo.setArchiveLog(tempStorageInfo.getArchiveLog());
            storageInfo.setPoType(tempStorageInfo.getPoType());
            storageInfo.setResourceType(tempStorageInfo.getResourceType());
            storageInfo.setStorageType(tempStorageInfo.getStorageType());
            storageInfo.setStorageSubType(tempStorageInfo.getStorageSubType());
            po.setProviderSN(tempStorageInfo.getHostSN());
            po.addHostStorageResourceInfo(storageInfo);
        }
        if ("0".equals(archiveLog)) {
            return;
        }
        if (this.isOracleAdg(po)) {
            logger.info((Object)"The po is for oracle ADG, no need to check.");
            return;
        }
        Optional<String> checkOpt = logLunWwns.stream().filter(dataLunWwns::contains).findAny();
        if (checkOpt.isPresent()) {
            logger.error((Object)"The oracle data lun and archive log lun is same, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073948235L);
        }
        if ("1".equals(archiveLog) && VerifyUtil.isEmpty(logLunWwns)) {
            logger.error((Object)"StorageInfo no contain archive log, poName: %s, providerSn: %s", new Object[]{po.getName(), po.getProviderSN()});
            throw new LegoCheckedException(1073948236L);
        }
        this.checkConsistent(dataLunWwns, logLunWwns);
    }

    private void checkConsistent(List<String> dataLunWwns, List<String> logLunWwns) {
        if (VerifyUtil.isEmpty(dataLunWwns) || VerifyUtil.isEmpty(logLunWwns)) {
            logger.error((Object)"check consistent,lun is null.", 90160758787071L);
            return;
        }
        List dataReplicationPair = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunWWN(dataLunWwns);
        if (VerifyUtil.isEmpty((Collection)dataReplicationPair)) {
            logger.debug((Object)"check consistent,replication pair is null.", 90160758786816L);
            return;
        }
        ArrayList<String> dataConsGroupIdList = new ArrayList<String>();
        for (ReplicationPair replicationPair : dataReplicationPair) {
            String groupId = replicationPair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)groupId) || "--".equals(groupId)) continue;
            dataConsGroupIdList.add(groupId);
        }
        List logReplicationPair = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunWWN(logLunWwns);
        for (ReplicationPair replicationPair : logReplicationPair) {
            String consistentGroupId = replicationPair.getConsistentGroupId();
            if (VerifyUtil.isEmpty((String)consistentGroupId) || "--".equals(consistentGroupId) || !dataConsGroupIdList.contains(consistentGroupId)) continue;
            logger.error((Object)("data lun and log lun has same consistent group,consistentGroupId=" + consistentGroupId), 90160758787071L);
            throw new LegoCheckedException(1073948237L);
        }
    }

    public boolean isProtectArchieveLog(ProtectObjectStorageInfo storageInfo) {
        return null != storageInfo.getArchiveLog() && storageInfo.getArchiveLog() == 1;
    }
}

