/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.cluster;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.agent.action.ClusterAction;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.cluster.OracleDefaultAdapter;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;

public class OraclePowerHAAdapter
extends OracleDefaultAdapter {
    private static final Log LOGGER = LogFactory.getInstance(OraclePowerHAAdapter.class);

    @Override
    public void startDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"start db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("begin start db(" + po.getName() + ") on " + po.getProviderSN()), 90160758786988L);
        ServiceLocator locator = ServiceLocator.getInstance();
        IResourceService resourceService = (IResourceService)locator.getService(IResourceService.class);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)locator.getService(INeMgrProtocolExtendService.class);
        DrHostGroup hostGroup = (DrHostGroup)resourceService.getDrResourceBySn(po.getProviderSN());
        Integer providerType = NumberUtil.parseInteger(po.getProps().get("PROVIDER_TYPE"));
        boolean isCluster = DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() == providerType.intValue();
        DrHostUtil.startCluster((DrHostGroup)hostGroup, (ProtectObject)po);
        LegoCheckedException ex = null;
        for (DrResource childDrResource : hostGroup.getChildResources()) {
            ProtectObject temp = OracleAppUtil.clone(po);
            temp.setProviderSN(childDrResource.getDeviceSn());
            if (isCluster) {
                OracleAppUtil.updateProtectObjectInstanceAndServiceName(temp);
            }
            Map props = temp.getProps();
            props.put("IS_CLUSTER", isCluster ? "1" : "0");
            if (!props.containsKey("APP_VERSION")) {
                props.put("APP_VERSION", props.get("VERSION"));
            }
            try {
                temp = OracleAppUtil.getOperateParam(temp);
                props = temp.getProps();
                NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)childDrResource.getDeviceSn());
                ClusterAction action = new ClusterAction(extend, (String)extend.getExtendParams().get("mac_address"));
                String resoureGroupName = (String)props.get("RESOURCEGROUP_NAME");
                Map<String, String> params = this.getResourceGroupParam(po);
                action.startResourceGroup(params);
                OracleAppUtil.startOracleDatabase(temp, extend);
                ex = null;
                LOGGER.info((Object)("Start db(" + po.getName() + "," + po.getProviderSN() + ") success in " + childDrResource.getIpAddress() + ", resource group: " + resoureGroupName), 90160758786988L);
                break;
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)("Start db(" + po.getName() + "," + po.getProviderSN() + ") error in " + childDrResource.getIpAddress()), (Throwable)le, 90160758786989L);
                ex = le;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Start db(" + po.getName() + "," + po.getProviderSN() + ") error in " + childDrResource.getIpAddress() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                ex = new LegoCheckedException(1073948170L);
            }
        }
        if (null != ex) {
            throw ex;
        }
    }

    @Override
    public void stopDatabase(ProtectObject po) {
        if (null == po) {
            LOGGER.error((Object)"stop db,po is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)("begin stop db(" + po.getName() + ") on " + po.getProviderSN()), 90160758786988L);
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        DrHostGroup hostGroup = (DrHostGroup)resourceService.getDrResourceBySn(po.getProviderSN());
        LegoCheckedException ex = null;
        for (DrResource childDrResource : hostGroup.getChildResources()) {
            try {
                NeMgrProtocolExtend extend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)childDrResource.getDeviceSn());
                ClusterAction action = new ClusterAction(extend, (String)extend.getExtendParams().get("mac_address"));
                String resourceGroup = (String)po.getProps().get("RESOURCEGROUP_NAME");
                Map<String, String> reqParams = this.getResourceGroupParam(po);
                action.stopResourceGroup(reqParams);
                ex = null;
                LOGGER.info((Object)("Stop resource group success in " + childDrResource.getIpAddress() + ", resource group: " + resourceGroup), 90160758786988L);
                break;
            }
            catch (LegoCheckedException le) {
                LOGGER.error((Object)("Stop resource group error in " + childDrResource.getIpAddress() + "," + po.getName()), (Throwable)le, 90160758786989L);
                ex = le;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Stop resource group error in " + childDrResource.getIpAddress() + "," + po.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                ex = new LegoCheckedException(1073948169L);
            }
        }
        if (null != ex) {
            throw ex;
        }
    }

    public Map<String, String> getResourceGroupParam(ProtectObject po) {
        String clusterType = (String)po.getProps().get("CLUSTER_TYPE");
        String resourceGroup = (String)po.getProps().get("RESOURCEGROUP_NAME");
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("clusterType", clusterType);
        reqParams.put("resourceGroup", resourceGroup);
        reqParams.put("appType", String.valueOf(po.getPoType()));
        return reqParams;
    }
}

