/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.hostagent.action;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.host.agent.action.RemoteShellAction;
import com.huawei.ism.drm.oracle.hostagent.action.OracleActionApi;
import com.huawei.ism.drm.oracle.hostagent.action.OracleParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AgentlessOracleActionApi
extends RemoteShellAction
implements OracleActionApi {
    private static final Log LOGGER = LogFactory.getInstance(AgentlessOracleActionApi.class);
    private static final String DEFAULT_QUERY_TYPE = "1";
    private static final String KEY_INSTANCE = "--instance";
    private static final String KEY_STANDBY_NAME = "--standby_name";
    private static final String KEY_PDB_NAME = "--pdb_name";
    private static final String KEY_QUERY_TYPE = "--query_type";
    private static final String KEY_PRIMARY_DB_ID = "--primary_db_id";
    private static final String KEY_DB_NAME = "--db_name";
    private static final String KEY_ARCHIVE_LEN = "--db_archive_lit";
    private static final String KEY_IS_ARCHIVE = "--is_archive";
    private static final String KEY_IS_ASM = "--is_asm";
    private static final String KEY_ORACLE_HOME = "--in_oracle_home";
    private static final String KEY_ASM_DGS = "--asm_disk_groups";
    private static final String KEY_ASM_SID_NAME = "--asm_sid_name";
    private static final String KEY_IS_INCLUDE_ARCH = "--is_include_arch";
    private static final String KEY_ADG_MAPPING = "--mapping";
    private static final String KEY_DB = "-db";
    private static final String KEY_DB_ROLE = "--role";
    private static final String KEY_DB_TARGET_ROLE = "--target_role";
    private static final String KEY_OPEN_MODE = "--open_mode";
    private static final String KEY_IS_ASM_LIB = "--is_asm_lib";
    private static final int MAX_RETRY_TIME = 3;
    private static final String KEY_DG_NAMES = "--disk_group_names";

    public AgentlessOracleActionApi(NeMgrProtocolExtend extend) {
        super(extend);
    }

    @Override
    public String queryDatabases() {
        try {
            return this.execute("guard oracle query_db_info", new Object[0]).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to query database info failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948168L);
        }
    }

    @Override
    public String queryLunList(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_DB_NAME);
        bodyList.add(oracleParam.getDatabaseName());
        bodyList.add(KEY_ASM_SID_NAME);
        bodyList.add(oracleParam.getAsmInstName());
        bodyList.add(KEY_IS_ARCHIVE);
        bodyList.add(oracleParam.getIsArchieve());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        try {
            return this.execute("guard oracle query_lun_info", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to query oracle lun info failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948535L);
        }
    }

    @Override
    public void startDatabase(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_DB_NAME);
        bodyList.add(oracleParam.getDatabaseName());
        bodyList.add(KEY_IS_ASM);
        bodyList.add(oracleParam.getIsASM());
        bodyList.add(KEY_ASM_DGS);
        bodyList.add(oracleParam.getAsmDiskGroups());
        bodyList.add(KEY_ASM_SID_NAME);
        bodyList.add(oracleParam.getAsmInstName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        bodyList.add(KEY_IS_INCLUDE_ARCH);
        bodyList.add(oracleParam.getIsIncludeArchLog());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        try {
            this.execute("guard oracle db_start", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to start database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949120L);
        }
    }

    @Override
    public void stopDatabase(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_DB_NAME);
        bodyList.add(oracleParam.getDatabaseName());
        bodyList.add(KEY_IS_ASM);
        bodyList.add(oracleParam.getIsASM());
        bodyList.add(KEY_ASM_DGS);
        bodyList.add(oracleParam.getAsmDiskGroups());
        bodyList.add(KEY_ASM_SID_NAME);
        bodyList.add(oracleParam.getAsmInstName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        try {
            this.execute("guard oracle db_stop", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to stop database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949121L);
        }
    }

    @Override
    public void testConnection(OracleParam oracleParam) {
        List<Object> requestList = this.getReqStringByParam(oracleParam);
        try {
            this.execute("guard oracle db_test", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec to test database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947427L);
        }
    }

    @Override
    public String queryDatabaseAuth(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        return this.execute("guard oracle query_db_auth", requestList.toArray()).get();
    }

    @Override
    public String queryPlugDatabase(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_PDB_NAME);
        bodyList.add(oracleParam.getPdbName());
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        return this.execute("guard oracle query_pdb_info", requestList.toArray()).get();
    }

    @Override
    public String queryAdgStandby(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_PRIMARY_DB_ID);
        bodyList.add(oracleParam.getDbId());
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        return this.execute("guard oracle query_standby_db", requestList.toArray()).get();
    }

    @Override
    public void freeze(OracleParam oracleParam) {
        List<Object> requestList = this.getReqStringByParam(oracleParam);
        try {
            this.execute("guard oracle db_freeze", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to freeze database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948978L);
        }
    }

    @Override
    public void thaw(OracleParam oracleParam) {
        List<Object> reqList = this.getReqStringByParam(oracleParam);
        try {
            this.execute("guard oracle db_thaw", reqList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to thaw database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948979L);
        }
    }

    private List<Object> getReqStringByParam(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_DB_NAME);
        bodyList.add(oracleParam.getDatabaseName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        return this.getReqListByParamAndBody(oracleParam, bodyList);
    }

    @Override
    public void forcedArchive(OracleParam oracleParam) {
        List<Object> reqList = this.getReqStringByParam(oracleParam);
        try {
            this.execute("guard oracle archive", reqList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec to forcedArchive database failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949080L);
        }
    }

    @Override
    public void checkThreshold(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_ASM_SID_NAME);
        bodyList.add(oracleParam.getAsmInstName());
        bodyList.add(KEY_ARCHIVE_LEN);
        bodyList.add(oracleParam.getCapThreshold());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        try {
            this.execute("guard oracle check_archive_threshold", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec checkThreshold failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949076L);
        }
    }

    private List<Object> getReqListByParamAndBody(OracleParam oracleParam, List<String> bodyList) {
        String reqBody = String.join((CharSequence)" ", bodyList);
        LOGGER.info((Object)"The request body is: %s", new Object[]{reqBody});
        Map<String, String> param = oracleParam.getExtendParam();
        List headerList = AgentlessOracleActionApi.buildAgentlessAuthStr(param);
        return Stream.concat(headerList.stream(), bodyList.stream()).collect(Collectors.toList());
    }

    @Override
    public String inspectAdgStatus(OracleParam oracleParam) {
        Map<String, String> params = oracleParam.getExtendParam();
        String queryType = params.get("QUERY_TYPE");
        String type = VerifyUtil.isEmpty((String)queryType) ? DEFAULT_QUERY_TYPE : queryType;
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_QUERY_TYPE);
        bodyList.add(type);
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_DB_TARGET_ROLE);
        bodyList.add(oracleParam.getDbRole());
        String isAsmLib = this.getExtendParam(oracleParam, "IS_ASM_LIB", "false");
        bodyList.add(KEY_IS_ASM_LIB);
        bodyList.add(isAsmLib);
        if (params.containsKey("controlfile")) {
            bodyList.add("--controlfile");
            bodyList.add(params.get("controlfile"));
        }
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        return this.execute("guard oracle inspect", requestList.toArray()).get();
    }

    @Override
    public void startAsmInstance(OracleParam oracleParam) {
        List<Object> requestList = this.getAsmInstanceRequest(oracleParam);
        try {
            this.execute("guard oracle asm_start", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec startAsmInstance failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948935L);
        }
    }

    @Override
    public void stopAsmInstance(OracleParam oracleParam) {
        List<Object> requestList = this.getAsmInstanceRequest(oracleParam);
        try {
            this.execute("guard oracle asm_stop", requestList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() != -1L) {
                throw e;
            }
            LOGGER.error((Object)"Exec stopAsmInstance failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948731L);
        }
    }

    private List<Object> getAsmInstanceRequest(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_ASM_SID_NAME);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_ASM_DGS);
        bodyList.add(oracleParam.getAsmDiskGroups());
        return this.getReqListByParamAndBody(oracleParam, bodyList);
    }

    @Override
    public void startPDB(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        bodyList.add(KEY_ORACLE_HOME);
        bodyList.add(oracleParam.getOracleHome());
        bodyList.add(KEY_PDB_NAME);
        bodyList.add(oracleParam.getPdbName());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        this.execute("guard oracle pdb_start", requestList.toArray()).get();
    }

    @Override
    public void switchoverDatabase(OracleParam oracleParam) {
        Map<String, String> params = oracleParam.getExtendParam();
        String passwd = params.get("PASSWD");
        String standbyDbName = params.get("STANDBY_DB_NAME");
        if (VerifyUtil.isEmpty((String)standbyDbName) || VerifyUtil.isEmpty((String)passwd)) {
            LOGGER.error((Object)"The input param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_DB_NAME);
        bodyList.add(oracleParam.getDatabaseName());
        bodyList.add(KEY_STANDBY_NAME);
        bodyList.add(standbyDbName);
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        this.execute("guard oracle switchover", requestList.toArray()).get();
    }

    @Override
    public void adgSwitchoverDatabase(OracleParam oracleParam) {
        Map<String, String> extendParam;
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        if (!VerifyUtil.isEmpty((String)oracleParam.getDbRole())) {
            bodyList.add(KEY_DB_ROLE);
            bodyList.add(oracleParam.getDbRole());
        }
        if ((extendParam = oracleParam.getExtendParam()).containsKey("openMode")) {
            bodyList.add(KEY_OPEN_MODE);
            bodyList.add(extendParam.get("openMode"));
        }
        String isAsmLib = this.getExtendParam(oracleParam, "IS_ASM_LIB", "false");
        bodyList.add(KEY_IS_ASM_LIB);
        bodyList.add(isAsmLib);
        this.execute("guard oracle adg_switchover", bodyList.toArray()).get();
    }

    @Override
    public String queryDbStatus(OracleParam oracleParam) {
        ArrayList<String> bodyList = new ArrayList<String>();
        bodyList.add(KEY_INSTANCE);
        bodyList.add(oracleParam.getInstanceName());
        List<Object> reqListByParamAndBody = this.getReqListByParamAndBody(oracleParam, bodyList);
        return this.execute("guard oracle query_db_status", reqListByParamAndBody.toArray()).get();
    }

    @Override
    public void replaceUdevRule(OracleParam oracleParam) {
        String[] lunMappings = oracleParam.getLunMapping().split(",");
        ArrayList<String> bodyList = new ArrayList<String>();
        for (String lunMapping : lunMappings) {
            bodyList.add(KEY_ADG_MAPPING);
            bodyList.add(lunMapping);
        }
        bodyList.add(KEY_DB);
        bodyList.add(oracleParam.getDatabaseName());
        String isAsmLib = this.getExtendParam(oracleParam, "IS_ASM_LIB", "false");
        bodyList.add(KEY_IS_ASM_LIB);
        bodyList.add(isAsmLib);
        List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
        this.execute("guard oracle restore_prepare replace_udev_rule", requestList.toArray()).get();
    }

    @Override
    public void adgRecovery(OracleParam oracleParam) {
        int retryTimes = 0;
        while (retryTimes++ <= 3) {
            try {
                ArrayList<String> bodyList = new ArrayList<String>();
                bodyList.add(KEY_INSTANCE);
                bodyList.add(oracleParam.getInstanceName());
                bodyList.add(KEY_DB);
                bodyList.add(oracleParam.getDatabaseName());
                bodyList.add(KEY_DG_NAMES);
                bodyList.add(this.getExtendParam(oracleParam, "ASM_DISK_GROUP_NAMES", ""));
                String isAsmLib = this.getExtendParam(oracleParam, "IS_ASM_LIB", "false");
                bodyList.add(KEY_IS_ASM_LIB);
                bodyList.add(isAsmLib);
                List<Object> requestList = this.getReqListByParamAndBody(oracleParam, bodyList);
                this.execute("guard oracle restore_prepare adg_recovery", requestList.toArray()).get();
                break;
            }
            catch (LegoCheckedException ex) {
                if (ex.getErrorCode() == 77L) {
                    LOGGER.info((Object)"Db is in recover progress. wait and try again.");
                    CommonUtil.sleep((long)10000L);
                    --retryTimes;
                    continue;
                }
                if (ex.getErrorCode() == 83L) {
                    LOGGER.warn((Object)"Db status is resolvable gap, need wait.");
                    throw ex;
                }
                LOGGER.error((Object)"The startup takes a long time. Send the startup command again. Times:%s, ErrMsg:%s.", new Object[]{String.valueOf(retryTimes), ExceptionUtil.getErrorMessage((Throwable)ex)});
                if (retryTimes != 3) continue;
                throw ex;
            }
        }
    }

    private String getExtendParam(OracleParam oracleParam, String propKey, String defaultVal) {
        Map extendParam = Optional.ofNullable(oracleParam.getExtendParam()).orElseGet(Collections::emptyMap);
        return extendParam.getOrDefault(propKey, defaultVal);
    }

    @Override
    public void adgDrilling(OracleParam oracleParam) {
        Map extendParam = Optional.ofNullable(oracleParam.getExtendParam()).orElseGet(Collections::emptyMap);
        String isAsmLib = extendParam.getOrDefault("IS_ASM_LIB", "false");
        this.execute("guard oracle restore_prepare replace_udev_rule_drilling", new Object[]{KEY_ADG_MAPPING, oracleParam.getLunMapping(), KEY_DB, oracleParam.getDatabaseName(), KEY_IS_ASM_LIB, isAsmLib}).get();
    }

    @Override
    public void cleanDrilling(OracleParam oracleParam) {
        Map extendParam = Optional.ofNullable(oracleParam.getExtendParam()).orElseGet(Collections::emptyMap);
        String isAsmLib = extendParam.getOrDefault("IS_ASM_LIB", "false");
        this.execute("guard oracle restore_prepare clean_drilling", new Object[]{KEY_ADG_MAPPING, oracleParam.getLunMapping(), KEY_DB, oracleParam.getDatabaseName(), KEY_IS_ASM_LIB, isAsmLib}).get();
    }

    @Override
    public String queryAdgRpo(OracleParam oracleParam) {
        try {
            ArrayList<String> bodyList = new ArrayList<String>();
            bodyList.add(KEY_INSTANCE);
            bodyList.add(oracleParam.getInstanceName());
            return this.execute("guard oracle query_adg_rpo", bodyList.toArray()).get();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query adg rpo failed, errmsg:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073949091L);
        }
    }
}

