/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.msg;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class OracleAllFlashObserver
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashObserver.class);
    private static final List<Integer> NORMAL_STATUS_LIST = ImmutableList.of((Object)DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus(), (Object)DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
    private static final String[] ALARM_IDS = new String[]{"0x3230099", "0x3230091"};

    public void before(MessageEvent event) {
        if (event.getMessageType() == 0) {
            return;
        }
        if (VerifyUtil.isEmpty((Collection)event.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : event.getObjectList()) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 47 || !NORMAL_STATUS_LIST.contains(protectGroup.getStatus())) continue;
            LOGGER.debug((Object)"Begin check adg status at %s", new Object[]{this.getClass().getSimpleName()});
            OracleAppUtil.checkAdgStatus(protectGroup);
        }
    }

    public void after(MessageEvent event) {
        block5: for (DRMObject drmObj : Optional.ofNullable(event.getObjectList()).orElseGet(Collections::emptyList)) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 47) continue;
            switch (event.getMessageType()) {
                case 1: {
                    this.updateRemoteReplica(protectGroup);
                    continue block5;
                }
                case 2: {
                    this.doAfterDeletePg(protectGroup);
                    continue block5;
                }
                case 4: {
                    this.doAfterRemovePo(event.getMessageMap());
                    continue block5;
                }
            }
            logger.debug((Object)"Not support for event: %s", new Object[]{String.valueOf(event.getMessageType())});
        }
    }

    private void doAfterRemovePo(Map<String, Object> messageMap) {
        Object taskObjs = messageMap.get("TASK_RESULT_ITEM_LIST_KEY");
        if (!(taskObjs instanceof Set)) {
            logger.info((Object)"Not found po task item.");
            return;
        }
        logger.info((Object)"Start to clear alarm of remove po.");
        Set taskResultItems = (Set)taskObjs;
        for (TaskResultItem taskResultItem : taskResultItems) {
            String resId = taskResultItem.getResId();
            AlarmReporter.restoreAlarm((String)"0x3230091", (String[])new String[]{resId});
        }
    }

    private void doAfterDeletePg(ProtectGroup protectGroup) {
        String pgId = protectGroup.getUuid();
        for (String alarmIdStr : ALARM_IDS) {
            long alarmId = Long.parseLong(alarmIdStr.replaceAll("0x", ""), 16);
            List legoAlarms = AlarmReporter.getAlarmListWithAlarmId((long)alarmId);
            List alarmForPg = legoAlarms.stream().filter(alarm -> alarm.getSourceId().contains(pgId)).collect(Collectors.toList());
            for (LegoAlarm legoAlarm : alarmForPg) {
                if (legoAlarm.getClearStatus().getValue() != 0) continue;
                String entity = legoAlarm.getEntity();
                String entityId = entity.substring(entity.indexOf(alarmIdStr) + alarmIdStr.length());
                String[] alarmParam = legoAlarm.getAlarmParam();
                alarmParam[0] = entityId;
                AlarmReporter.restoreAlarm((String)alarmIdStr, (String[])alarmParam);
            }
        }
    }

    private void updateRemoteReplica(ProtectGroup protectGroup) {
        HashSet<Integer> acceptedStatus = new HashSet<Integer>(NORMAL_STATUS_LIST);
        acceptedStatus.add(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
        if (!acceptedStatus.contains(protectGroup.getStatus())) {
            return;
        }
        Set replicaList = Optional.ofNullable(protectGroup.getReplicaList()).orElse(Collections.emptySet());
        HashSet totalRemoteLunIdSet = new HashSet();
        for (ProtectGroupReplica protectGroupReplica : replicaList) {
            Set replicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica replica : replicas) {
                Set storageInfos = Optional.ofNullable(replica.getStorageInfos()).orElse(Collections.emptySet());
                Set remoteLunIdSet = storageInfos.stream().map(remoteReplica -> (RemoteStorageReplica)CastUtil.castTo((Object)remoteReplica, RemoteStorageReplica.class)).map(RelicaStorageInfo::getStorageId).collect(Collectors.toSet());
                totalRemoteLunIdSet.addAll(remoteLunIdSet);
            }
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"Pg does not has po list: %s", new Object[]{protectGroup.getUuid()});
            return;
        }
        Set poList = protectGroup.getPolist();
        ProtectObject po = (ProtectObject)CommonUtil.getFirstElement((Collection)poList);
        Set storageResourceSet = po.getUsedStorageResourceSet();
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)Optional.ofNullable(CommonUtil.getFirstElement((Collection)storageResourceSet)).orElseThrow(() -> new LegoCheckedException(1073947393L));
        String devSn = storageInfo.getResourceProviderSN();
        List newPoSet = poList.stream().flatMap(tmpPo -> tmpPo.getUsedStorageResourceSet().stream()).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toList());
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List realPairs = storageService.getReplicationPairsByResourceIds(devSn, newPoSet, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        Set realTgtLunIdSet = realPairs.stream().flatMap(pair -> pair.getRepTgtLuns().stream()).map(ReplicationTargetLun::getTgtLunId).collect(Collectors.toSet());
        totalRemoteLunIdSet.removeAll(realTgtLunIdSet);
        if (!totalRemoteLunIdSet.isEmpty() || !po.getProps().containsKey("PRD_DATA_LUN_WWN")) {
            logger.info((Object)"Pairs of adg pg has changed, need rebuild replica: newPairsSize=%s, oldPairSize=%s", new Object[]{String.valueOf(realPairs.size()), totalRemoteLunIdSet.size()});
            this.deleteOldReplicaInDb(protectGroup);
            OracleAllFlashObserver.updateProtect(protectGroup);
        }
    }

    private static void updateProtect(ProtectGroup protectGroup) {
        ProtectGroupHelper.getInstance().buildReplica(protectGroup, false);
        IReplicaService iReplicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        protectGroup.getReplicaList().forEach(arg_0 -> ((IReplicaService)iReplicaService).saveOrUpdateReplica(arg_0));
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        protectGroup.getProps().remove("PRD_DATA_LUN_WWN");
        protectGroup.getProps().remove("REDO_LUN_WWN");
        protectGroup.getProps().remove("ARCHIVE_LUN_WWN");
        protectGroup.getProps().remove("DATA_LUN_WWN");
        protectGroup.getProps().remove("REDO_BACK_UP_LUN_IDS");
        protectGroup.getProps().remove("STANDBY_DB_NAME");
        protectGroup.getProps().remove("REMOTE_PAIR_SRCLUNIDS");
        protectGroup.getProps().remove("REMOTE_PAIR_TRGLUNIDS");
        protectGroupService.saveProtectGroup(protectGroup);
    }

    private void deleteOldReplicaInDb(ProtectGroup protectGroup) {
        IReplicaBaseService replicaBaseService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
        protectGroup.getReplicaList().forEach(replica -> replicaBaseService.deleteProtectGroupReplicaById(replica.getId()));
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

