/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.msg;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OracleNasObserver
implements IObjectObserver {
    private static final Log LOGGER = LogFactory.getInstance(OracleNasObserver.class);
    private INeMgrProtocolExtendService neMgr;

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public void before(MessageEvent event) {
        if (event.getMessageType() != 0 && event.getMessageType() != 1) {
            return;
        }
        if (VerifyUtil.isEmpty((Collection)event.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : event.getObjectList()) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 14 || protectGroup.getPoType() != 1) continue;
            LOGGER.info((Object)"Start handle oracle nas observer event");
            this.handleOracleNasObserverEvent(protectGroup, event.getMessageType());
        }
    }

    public void after(MessageEvent event) {
        if (event.getMessageType() != 2 && event.getMessageType() != 4) {
            return;
        }
        if (VerifyUtil.isEmpty((Collection)event.getObjectList())) {
            return;
        }
        for (DRMObject drmObj : event.getObjectList()) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 14 || protectGroup.getPoType() != 1) continue;
            switch (event.getMessageType()) {
                case 2: {
                    this.afterDeleteProtectGroup(protectGroup);
                    break;
                }
                case 4: {
                    this.afterRemoveProtectObject(event.getMessageMap());
                    break;
                }
            }
        }
    }

    private void afterRemoveProtectObject(Map<String, Object> messageMap) {
        if (VerifyUtil.isEmpty(messageMap)) {
            return;
        }
        Object removedItems = messageMap.get("TASK_RESULT_REMOVED_ITEM_LIST_KEY");
        if (VerifyUtil.isEmpty((Object)removedItems) || !(removedItems instanceof Set)) {
            return;
        }
        Set protectObjectObjs = (Set)removedItems;
        for (Object obj : protectObjectObjs) {
            ProtectObject po;
            if (!(obj instanceof ProtectObject) || VerifyUtil.isEmpty((Object)(po = (ProtectObject)obj))) continue;
            this.clearProtectObjectAlarm(po);
        }
    }

    private void afterDeleteProtectGroup(ProtectGroup protectGroup) {
        Set protectObjects = protectGroup.getPolist();
        for (ProtectObject protectObject : protectObjects) {
            this.clearProtectObjectAlarm(protectObject);
        }
    }

    private void clearProtectObjectAlarm(ProtectObject protectObject) {
        LOGGER.info((Object)"Start clear alarms of ProtectObject ( name: %s, id: %s )", new Object[]{protectObject.getName(), protectObject.getUuid()});
        List<String> instanceNames = this.getInstanceNames(protectObject);
        for (String instance : instanceNames) {
            AlarmReporter.restoreAlarm((String)"0x3230100", (String[])new String[]{protectObject.getUuid() + instance});
        }
    }

    private void handleOracleNasObserverEvent(ProtectGroup protectGroup, int messageType) {
        Set hosts = DrHostUtil.getDrHostsByHostOrGroupId((String)protectGroup.getPoProviderSN());
        Set protectObjects = protectGroup.getPolist();
        for (ProtectObject po : protectObjects) {
            ArrayList<String> offlineInstances = new ArrayList<String>();
            for (DrResource drResource : hosts) {
                NeMgrProtocolExtend neMgrProtocolExtend = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)this.neMgr, (String)drResource.getDeviceSn());
                Optional<String> offlineOpt = this.testConnectionAndGetOfflineInstance(po, drResource, neMgrProtocolExtend);
                offlineOpt.ifPresent(offlineInstances::add);
            }
            if (offlineInstances.size() != this.getInstanceNames(po).size()) {
                this.sendAlarm(offlineInstances, po);
                continue;
            }
            if (messageType == 1) {
                this.sendAlarm(offlineInstances, po);
            }
            LOGGER.error((Object)"Connect to database %s failed, cause all instances is offline", new Object[]{po.getName()});
            throw new LegoCheckedException(1073948167L);
        }
    }

    private void sendAlarm(List<String> offlineInstances, ProtectObject po) {
        for (String offlineInstance : offlineInstances) {
            String[] params = new String[]{po.getName(), offlineInstance, po.getProtectGroup().getName(), po.getUuid() + offlineInstance};
            AlarmReporter.sendAlarm((String)"0x3230100", (String)po.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
        }
    }

    private Optional<String> testConnectionAndGetOfflineInstance(ProtectObject po, DrResource drResource, NeMgrProtocolExtend neMgrProtocolExtend) {
        String instance = this.getInstanceName(po, drResource);
        try {
            Object tempPoObj = po.clone();
            if (!(tempPoObj instanceof ProtectObject)) {
                throw new LegoCheckedException(1073947393L);
            }
            ProtectObject tempPo = (ProtectObject)tempPoObj;
            tempPo.setProperty("INSTANCENAME", (Object)instance);
            OracleAppUtil.testConnection(tempPo, neMgrProtocolExtend);
            AlarmReporter.restoreAlarm((String)"0x3230100", (String[])new String[]{po.getUuid() + instance});
            return Optional.empty();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Throwable)e, (Object)"Connect to oracle instance ( %s ) failed", new Object[]{instance});
            return Optional.of(instance);
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error((Throwable)e, (Object)"Clone protect object failed", new Object[0]);
            throw new LegoCheckedException(-1L);
        }
    }

    private List<String> getInstanceNames(ProtectObject po) {
        String instanceStr = po.getProperty("INSTANCENAME");
        if (!instanceStr.startsWith("[")) {
            return Collections.singletonList(instanceStr);
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceStr);
        ArrayList<String> instances = new ArrayList<String>();
        for (Object instanceObj : instanceArray) {
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName)) continue;
            instances.add(instanceName);
        }
        return instances;
    }

    private String getInstanceName(ProtectObject po, DrResource drResource) {
        String instanceStr = po.getProperty("INSTANCENAME");
        if (!instanceStr.startsWith("[")) {
            return instanceStr;
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceStr);
        for (Object instanceObj : instanceArray) {
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
            String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn) || !hostSn.equals(drResource.getDeviceSn())) continue;
            return instanceName;
        }
        LOGGER.error((Object)"Could not find oracle instance from ProtectObject %s", new Object[]{po.getName()});
        throw new LegoCheckedException(1073947393L);
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

