/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.poller;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.oracle.poller.GetAndSaveRpoTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Session;

public class OracleQueryRpoPoller
implements IPoller {
    private static final Log LOGGER = LogFactory.getInstance(OracleQueryRpoPoller.class);
    private static final Long ADMIN_USER_ID = 1L;
    private final String uuid;
    private final String pollerType;
    private INeMgrProtocolExtendService neMgr;

    public OracleQueryRpoPoller(String uuid, String pollerType) {
        this.uuid = uuid;
        this.pollerType = pollerType;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public String getPollerID() {
        return this.uuid;
    }

    public String getPollerType() {
        return this.pollerType;
    }

    public void run() {
        LOGGER.info((Object)"Start get rpo.");
        QueryProtectGroupRefineService instance = QueryProtectGroupRefineService.getInstance();
        List protectGroups = instance.getProtectGroupByType(1, ADMIN_USER_ID, true);
        protectGroups.removeIf(protectGroup -> protectGroup.getTemplate().getType() != 47);
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            return;
        }
        for (ProtectGroup protectGroup2 : protectGroups) {
            Boolean enableRpoCheck;
            Optional schedule;
            if (protectGroup2.getStatus() != DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() || !(schedule = protectGroup2.getTemplate().getSchedules().stream().findAny()).isPresent() || VerifyUtil.isEmpty((Object)(enableRpoCheck = ((Schedule)schedule.get()).isEnableRpoCheck()))) continue;
            if (enableRpoCheck.booleanValue()) {
                ExecutionService.map(Collections.singletonList(protectGroup2), pg -> {
                    new GetAndSaveRpoTask((ProtectGroup)pg, (Schedule)schedule.get(), this.neMgr).call();
                    return null;
                });
                continue;
            }
            Session session = HibernateUtil.openSession();
            Map pgProps = instance.getProtectGroupProps(protectGroup2.getUuid(), session);
            HibernateUtil.close((Session)session);
            String rpoConfig = (String)pgProps.get("RPO_ITEM_KEY");
            if (!VerifyUtil.isEmpty((String)rpoConfig) && !"[]".equals(rpoConfig)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("RPO_ITEM_KEY", "[]");
                ProtectGroupUtil.saveRPOAndRTOResult((ProtectGroup)protectGroup2, map);
            }
            for (ProtectObject protectObject : protectGroup2.getPolist()) {
                AlarmReporter.restoreAlarm((String)"0x3230091", (String[])new String[]{protectObject.getUuid()});
            }
        }
    }
}

