/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.oracle.protect.action.OracleCreateArchiveNasSnapshotAction;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.CreateNasSnapshotAction;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class OracleCreateNasSnapshotAction
extends CreateNasSnapshotAction {
    private static final Log LOGGER = LogFactory.getInstance(OracleCreateNasSnapshotAction.class);

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)ProtectGroup.class.cast(context.getObject("PG_ENTITY"));
        LOGGER.info((Object)"BaseNasSnapshotAction begin to execute,pgId: %s pgName: %s. Code: %d", new Object[]{protectGroup.getUuid(), protectGroup.getName(), 90160758786988L});
        ProtectGroupReplica pgReplica = ExecuteReplicaManager.getInstance().getExecuteReplica(protectGroup, NumberUtil.convertToInteger((Object)context.getObject("PG_EXECUTE_LOCATION")).intValue());
        if (pgReplica == null) {
            LOGGER.error((Object)"OracleCreateNasSnapshotAction get replica error,pgId: %s pgName: %s.", new Object[]{protectGroup.getUuid(), protectGroup.getName()});
            this.setDetail("lego.err.2117645");
            return false;
        }
        Set<String> archieveLogNasWWNs = this.getArchiveLogNasWWNs(protectGroup.getPolist());
        Set createSnapshotReplicas = pgReplica.getReplicas();
        if (((Object)((Object)this)).getClass().getName().equals(OracleCreateArchiveNasSnapshotAction.class.getName())) {
            Map<String, Set> collect = ((Set)context.getObject("PO_REPLICA_ENTITY")).stream().collect(Collectors.toMap(ProtectObjectReplica::getPoId, ProtectObjectReplica::getStorageInfos));
            context.addObject("dataSnapshotReplicas", collect);
        }
        this.filterNasReplica(archieveLogNasWWNs, createSnapshotReplicas);
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        context.addObject("PO_REPLICA_ENTITY", (Object)createSnapshotReplicas);
        boolean isRefreshSuccess = super.refreshSnapShort(context);
        if (((Object)((Object)this)).getClass().getName().equals(OracleCreateArchiveNasSnapshotAction.class.getName())) {
            Map tempPo = (Map)context.getObject("dataSnapshotReplicas");
            for (ProtectObjectReplica createSnapshotReplica : createSnapshotReplicas) {
                createSnapshotReplica.getStorageInfos().addAll((Collection)tempPo.get(createSnapshotReplica.getPoId()));
            }
        }
        return isRefreshSuccess;
    }

    private Set<String> getArchiveLogNasWWNs(Set<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            LOGGER.warn((Object)"PoList is null.");
            return new HashSet<String>();
        }
        HashSet<String> archieveLogNasWWNs = new HashSet<String>();
        for (ProtectObject po : poList) {
            Set storageInfoSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
                if (storageInfo.getArchiveLog() == null || storageInfo.getArchiveLog() != 1) continue;
                archieveLogNasWWNs.add(storageInfo.getLunWWN());
            }
        }
        return archieveLogNasWWNs;
    }

    protected abstract void filterNasReplica(Set<String> var1, Set<ProtectObjectReplica> var2);
}

