/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.action;

import com.huawei.ism.drm.app.sdk.service.IOracleAppProxy;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.host.protection.action.BaseThawAction;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Set;

public class OracleForcedArchiveAction
extends AbstractBaseProtectAction {
    private static final Log LOGGER = LogFactory.getInstance(BaseThawAction.class);

    public void preExcute(ActionContext context) {
        this.setIgnoreFailure(true);
        this.setEnable(this.isAppConsistent(context));
    }

    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        LOGGER.debug((Object)("OracleForcedArchiveAction begin to execute,pgId:" + protectGroup.getUuid()), 90160758786988L);
        Set freezePo = (Set)context.getObject("FREEZE_PO_ENTITY");
        long errorCode = 0L;
        for (ProtectObject po : freezePo) {
            LOGGER.debug((Object)("begin to ForcedArchive app,pgId:" + protectGroup.getUuid() + ",poName:" + po.getName() + ",poProviderSN:" + po.getProviderSN()), 90160758786988L);
            try {
                ((IOracleAppProxy)ServiceLocator.getInstance().getService(IOracleAppProxy.class)).forcedArchive(po);
                AlarmReporter.restoreAlarm((long)52625437L, (String[])new String[]{protectGroup.getUuid() + "_" + po.getMoUuid()});
            }
            catch (LegoCheckedException e) {
                this.setDetail(e.getErrorMessageKey());
                this.setDetailParams(this.constructParams(e.getParameters()));
                LOGGER.error((Object)("OracleForcedArchiveAction failed,pgId:" + protectGroup.getUuid() + ",poName:" + po.getName() + ",poProviderSN:" + po.getProviderSN()), (Throwable)e, 90160758786989L);
                AlarmReporter.sendAlarm((long)52625437L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{protectGroup.getUuid() + "_" + po.getMoUuid(), protectGroup.getName(), po.getName()});
            }
            catch (Exception e) {
                errorCode = 1073948172L;
                this.setDetail("lego.err.1073948172");
                LOGGER.error((Object)("OracleForcedArchiveAction failed,pgId:" + protectGroup.getUuid() + ",poName:" + po.getName() + ",poProviderSN:" + po.getProviderSN() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                AlarmReporter.sendAlarm((long)52625437L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{protectGroup.getUuid() + "_" + po.getMoUuid(), protectGroup.getName(), po.getName()});
            }
            LOGGER.debug((Object)("End to forced archive app:" + protectGroup.getUuid() + ",poName:" + po.getName() + ",poProviderSN:" + po.getProviderSN()), 90160758786988L);
        }
        return 0L == errorCode;
    }
}

