/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.protect.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.database.oracle.sdk.model.OracleInstance;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.drm.app.util.JsonUtil;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.util.DrHostUtil;
import com.huawei.ism.drm.oracle.constant.OracleConst;
import com.huawei.ism.drm.oracle.hostagent.action.OracleAction;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OracleAllFlashFilter
extends ArraySyncReplicationFilter {
    public static final String SITE_A_SN = "siteASn";
    public static final String SITE_B_SN = "siteBSn";
    public static final String OCACLE_SITE_A = "OCACLE_SITE_A";
    public static final String OCACLE_SITE_B = "OCACLE_SITE_B";
    public static final String STAND_BY_HOSTSNS = "STAND_BY_HOSTSNS";
    public static final String REMOTE_PAIR_SRCLUNIDS = "REMOTE_PAIR_SRCLUNIDS";
    public static final String REMOTE_PAIR_TRGLUNIDS = "REMOTE_PAIR_TRGLUNIDS";
    public static final String PRD_DATA_LUN_WWN = "PRD_DATA_LUN_WWN";
    public static final String DATA_LUN_WWN = "DATA_LUN_WWN";
    public static final String REDO_LUN_WWN = "REDO_LUN_WWN";
    public static final String ARCHIVE_LUN_WWN = "ARCHIVE_LUN_WWN";
    public static final String REDO_BACK_UP_LUN_IDS = "REDO_BACK_UP_LUN_IDS";
    public static final String REDO = "REDO";
    public static final String ARCHIVE = "ARCHIVE";
    public static final int FILTER_TMOUT = 1200;
    public static final long FILTER_SUCCESS_CODE = 0L;
    private static final String PRD_HOST_SN = "PRD_HOST_SN";
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashFilter.class);
    private static final long PAIR_NOT_IN_SAME_CG = 1073948176L;

    public int getType() {
        return 47;
    }

    public boolean isMatch(List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            LOGGER.warn((Object)"The parameter protectObjects is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        LOGGER.info((Object)"Start %s isMatch", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{arraySn});
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        return this.isMatchByLocation(DrmEnumDefine.ProtectLocation.A_B.getValue(), protectObjects);
    }

    protected boolean isMatchByLocation(int locationType, List<ProtectObject> protectObjects) {
        boolean isMatch;
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        ExecutionContext context = this.init(locationType, protectObjects);
        try {
            isMatch = this.arrayFilterRules(protectObjects, context);
        }
        catch (LegoCheckedException e) {
            LOGGER.warn((Object)"Array replication filter failed!");
            throw e;
        }
        this.getLunTgtDevs().clear();
        this.getLunTgtdevSn().clear();
        if (!isMatch) {
            LOGGER.error((Object)"The template is not match.");
            throw new LegoCheckedException(1073948191L);
        }
        return true;
    }

    public boolean arrayFilterRules(List<ProtectObject> protectObjects, ExecutionContext context) {
        ArrayList filterTasks = new ArrayList();
        ConcurrentHashMap tmpContext = new ConcurrentHashMap();
        protectObjects.forEach(po -> this.createFilterTask((ProtectObject)po, context, tmpContext, filterTasks));
        List results = ExecutionService.batchSubmit(filterTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)1200, (int)filterTasks.size());
        this.calculateResult(results, protectObjects);
        this.getFilterContext().putAll(tmpContext);
        return true;
    }

    private void calculateResult(List<Map<String, LegoCheckedException>> results, List<ProtectObject> protectObjects) {
        Map<String, ProtectObject> uuidPoMap = protectObjects.stream().collect(Collectors.toMap(DRMObject::getUuid, po -> po));
        for (Map<String, LegoCheckedException> result : results) {
            Set<Map.Entry<String, LegoCheckedException>> entries = result.entrySet();
            Map.Entry entry = (Map.Entry)entries.stream().findFirst().get();
            String poName = (String)uuidPoMap.get(entry.getKey()).getProps().get("DATABASES");
            if (result.values().iterator().next() == null) {
                LOGGER.info((Object)"Protect object: %s filter success.", new Object[]{poName});
                continue;
            }
            LOGGER.error((Object)"Protect object: %s filter failed with error:%s.", new Object[]{poName, entry.getValue()});
            throw (LegoCheckedException)((Object)entry.getValue());
        }
    }

    private void createFilterTask(ProtectObject po, ExecutionContext context, Map<String, Object> tmpContext, List<Callable<Map<String, LegoCheckedException>>> filterTasks) {
        filterTasks.add(() -> {
            HashMap<String, LegoCheckedException> resultMap = new HashMap<String, LegoCheckedException>();
            resultMap.put(po.getUuid(), null);
            try {
                this.checkAndUpdateDbId(po);
                List<ApplicationResource> appStandbyResource = this.getApplicationResources(po);
                Map<String, String> siteSns = this.getSiteSns(po, appStandbyResource);
                this.checkSites(siteSns);
                Set<String> resourceIdSet = this.getPoStorageInfoList(po);
                String devSn = (String)context.getAttribute("DEVICE_SN", String.class);
                List lunList = this.queryLuns(devSn, resourceIdSet);
                Lun[] lunArray = new Lun[lunList.size()];
                lunList.toArray(lunArray);
                List pairList = this.getPairsByLun(lunArray);
                List<String> hostSnList = this.getStandbyHostSns(appStandbyResource, po);
                HashMap<String, String> extendParams = new HashMap<String, String>();
                extendParams.put(STAND_BY_HOSTSNS, String.join((CharSequence)",", hostSnList));
                this.filterPairsByTgtSN(pairList, siteSns.get(SITE_B_SN));
                List<ReplicationPair> remotePairs = this.getpairsByApplicationResource(appStandbyResource);
                this.filterPairsByTgtSN(remotePairs, siteSns.get(SITE_A_SN));
                ApplicationResource applicationResource = appStandbyResource.get(0);
                extendParams.put("STANDBY_DB_NAME", (String)applicationResource.getExtendParams().get("STANDBY_DB_NAME"));
                this.checkAsmInst(po, appStandbyResource, (String)extendParams.get("STANDBY_DB_NAME"));
                Map appResExtendParams = applicationResource.getExtendParams();
                tmpContext.put("IS_ASM_LIB", appResExtendParams.get("IS_ASM_LIB"));
                if (!(this.checkPairEqualNum(pairList, remotePairs) && this.checkReplicationPairs(siteSns, applicationResource, pairList, remotePairs) && this.checkArchivePairs(po, remotePairs, appStandbyResource))) {
                    throw new LegoCheckedException(1073947793L, new String[]{(String)po.getProps().get("DATABASES")});
                }
                this.updatePrdWwnInfo(extendParams, lunList, pairList, po);
                OracleAllFlashFilter.updateStandbyWwnInfo(extendParams, applicationResource.getAppStorageInfos());
                this.fillContext(siteSns, extendParams, tmpContext, remotePairs, po);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Filter po:%s failed with error:%s", new Object[]{po.getProps().get("DATABASES"), e.getErrorCode()});
                resultMap.put(po.getUuid(), e);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Filter po:%s failed with error:%s", new Object[]{po.getProps().get("DATABASES"), ExceptionUtil.getErrorMessage((Throwable)e)});
                resultMap.put(po.getUuid(), new LegoCheckedException(-1L));
            }
            return resultMap;
        });
    }

    private void checkAsmInst(ProtectObject po, List<ApplicationResource> appResource, String standbyDbName) {
        HashSet<String> primaryAsmSet = new HashSet<String>();
        String isAsm = (String)po.getProps().get("IS_ASM");
        primaryAsmSet.add(isAsm);
        HashSet<String> standbyIsAsmSet = new HashSet<String>();
        for (ApplicationResource standbyRes : appResource) {
            if (VerifyUtil.isEmpty((Collection)standbyRes.getAppStorageInfos())) continue;
            DatabaseInstance standbyInst = OracleAppUtil.getOracleInstanceByHostAndName(standbyRes.getHostSn(), standbyDbName);
            OracleInstance oracleInstance = (OracleInstance)CastUtil.castTo((Object)standbyInst, OracleInstance.class);
            standbyIsAsmSet.add(oracleInstance.getUseAsm() != false ? "1" : "0");
        }
        if (!primaryAsmSet.containsAll(standbyIsAsmSet) || !standbyIsAsmSet.containsAll(primaryAsmSet)) {
            LOGGER.error((Object)"Primary db and standby db asm names are not matched. prdIsAsm=%s, standbyIsAsm=%s", new Object[]{isAsm, standbyIsAsmSet});
            throw new LegoCheckedException(1073947793L, new String[]{(String)po.getProps().get("DATABASES")});
        }
    }

    private void checkAndUpdateDbId(ProtectObject po) {
        String dbId = (String)po.getProps().get("DB_ID");
        if (!VerifyUtil.isEmpty((String)dbId)) {
            return;
        }
        LOGGER.info((Object)"DbId is empty, start to get dbId.");
        JSONObject dbInstInfo = OracleAppUtil.queryDbInfo(po);
        if (VerifyUtil.isEmpty((Map)dbInstInfo)) {
            LOGGER.warn((Object)"Not found db instance info.");
            return;
        }
        dbId = dbInstInfo.getString("DB_ID", "");
        po.getProps().put("DB_ID", dbId);
    }

    private Map<String, String> getSiteSns(ProtectObject po, List<ApplicationResource> appStandbyResource) {
        HashMap<String, String> siteSns = new HashMap<String, String>();
        siteSns.put(SITE_A_SN, ((ProtectObjectStorageInfo)po.getUsedStorageResourceSet().iterator().next()).getResourceProviderSN());
        ApplicationResource applicationResource = appStandbyResource.get(0);
        siteSns.put(SITE_B_SN, applicationResource.getDevSn());
        return siteSns;
    }

    private Set<String> getPoStorageInfoList(ProtectObject po) {
        if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
            LOGGER.error((Object)"PolicyTemplate check protectObject storageInfo is empty, po is:%s", new Object[]{po.getName()});
            throw new LegoCheckedException(1073948453L);
        }
        for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
            if (!VerifyUtil.isEmpty((String)info.getAsmDiskGroupName()) && !VerifyUtil.isEmpty((String)info.getAsmDiskNumber())) continue;
            LOGGER.error((Object)"ProtectObject storageInfo has empty value.");
            throw new LegoCheckedException(1073947793L, new String[]{(String)po.getProps().get("DATABASES")});
        }
        return po.getUsedStorageResourceSet().stream().map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toSet());
    }

    private List<String> getStandbyHostSns(List<ApplicationResource> appStandbyResource, ProtectObject po) {
        Object[] hostSnArray = (String[])appStandbyResource.stream().map(ApplicationResource::getHostSn).toArray(String[]::new);
        IHostService hostService = (IHostService)ServiceLocator.getInstance().getService(IHostService.class);
        Optional hostOp = hostService.getDrHostsBySns((String[])hostSnArray).stream().findAny();
        if (!hostOp.isPresent()) {
            LOGGER.error((Object)"Can not get host by sns:%s", new Object[]{Arrays.toString(hostSnArray)});
            throw new LegoCheckedException(2117645L);
        }
        DrHost drHost = (DrHost)hostOp.get();
        int proType = NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE"));
        ArrayList<String> snList = new ArrayList<String>();
        if (DrmEnumDefine.ProviderTypeE.HOST.getValue() == proType) {
            snList.add(drHost.getDeviceSn());
        } else {
            DrResource drResource = drHost.getParentDrResource();
            if (VerifyUtil.isEmpty((Object)drResource)) {
                LOGGER.error((Object)"Host do not have parent resource, sn:%s", new Object[]{drHost.getDeviceSn()});
                throw new LegoCheckedException(2117645L);
            }
            if (drResource instanceof DrHostGroup) {
                Set hosts = drResource.getChildResources();
                hosts.forEach(host -> snList.add(host.getDeviceSn()));
            }
        }
        return snList;
    }

    private void updatePrdWwnInfo(Map<String, String> extendParams, List<Lun> lunList, List<ReplicationPair> pairList, ProtectObject protectObject) {
        List<Set<ProtectObjectStorageInfo>> storageInfoOfHosts = this.getStorageInfoOfHosts(protectObject);
        Set storageInfos = storageInfoOfHosts.stream().filter(list -> !list.isEmpty()).findFirst().orElseThrow(() -> new LegoCheckedException(1073948516L));
        Set<String> redoLunIdSet = storageInfos.stream().filter(storageInfo -> OracleConst.DiskGroupType.LOG.getVal().equals(storageInfo.getAsmDiskGroupType())).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toSet());
        this.checkRedoPairNum(redoLunIdSet, pairList);
        String prdDataWwnStr = this.getPrdDataWwnStr(storageInfos);
        extendParams.put(PRD_DATA_LUN_WWN, prdDataWwnStr);
        HashMap<String, Lun> lunMap = new HashMap<String, Lun>();
        for (Lun lun : lunList) {
            lunMap.put(lun.getLunId(), lun);
        }
        HashSet<ReplicationPair> prdControlPairSet = new HashSet<ReplicationPair>();
        Set<String> controlLunIdSet = this.getControlLunIdSet(storageInfos);
        for (ReplicationPair pair : pairList) {
            pair.setSrcLunWWN(((Lun)lunMap.get(pair.getSrcLunId())).getWwn());
            if (controlLunIdSet.contains(pair.getSrcLunId())) {
                prdControlPairSet.add(pair);
            }
            if (!prdDataWwnStr.contains(pair.getSrcLunWWN())) continue;
            LOGGER.error((Object)"Data lun has pair: %s", new Object[]{pair.getSrcLunWWN()});
            throw new LegoCheckedException(1073948191L);
        }
        if (!controlLunIdSet.isEmpty() && prdControlPairSet.isEmpty()) {
            LOGGER.error((Object)"Control file lun doesnt have pair: %s", new Object[]{controlLunIdSet});
            throw new LegoCheckedException(1073948518L);
        }
        extendParams.put(REDO_BACK_UP_LUN_IDS, OracleAllFlashFilter.updateRedoBackupLunIdByGroup(storageInfos, pairList).toString());
    }

    private String getPrdDataWwnStr(Set<ProtectObjectStorageInfo> storageInfos) {
        return storageInfos.stream().filter(storageInfo -> OracleConst.DiskGroupType.DATA.getVal().equals(storageInfo.getAsmDiskGroupType())).map(ProtectObjectStorageInfo::getLunWWN).collect(Collectors.joining(","));
    }

    private Set<String> getControlLunIdSet(Set<ProtectObjectStorageInfo> storageInfos) {
        return storageInfos.stream().filter(info -> OracleConst.DiskGroupType.CONTROL.getVal().equals(info.getAsmDiskGroupType())).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toSet());
    }

    private List<Set<ProtectObjectStorageInfo>> getStorageInfoOfHosts(ProtectObject protectObject) {
        Set<String> hostSnSet = this.getPrdHostSnSet(protectObject);
        return ExecutionService.map(hostSnSet, hostSn -> {
            ProtectObject clonePo = OracleAppUtil.clone(protectObject);
            clonePo.setProviderSN(hostSn);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("instanceName", OracleAppUtil.getInstanceNameByHostSn(protectObject, hostSn));
            return OracleAppUtil.queryMatchedStorages(clonePo, map);
        }, null, (int)1800, (int)20);
    }

    private Set<String> getPrdHostSnSet(ProtectObject protectObject) {
        Object hostSnObj = this.getFilterContext().get(PRD_HOST_SN);
        if (hostSnObj != null) {
            return (Set)CastUtil.castTo(hostSnObj, Set.class);
        }
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(protectObject.getProviderSN());
        HashSet<String> hostSnSet = new HashSet<String>();
        if (drResource instanceof DrHostGroup) {
            DrHostGroup drHostGroup = (DrHostGroup)CastUtil.castTo((Object)drResource, DrHostGroup.class);
            Set childResources = drHostGroup.getChildResources();
            childResources.stream().map(DrResource::getDeviceSn).forEach(hostSnSet::add);
        } else {
            hostSnSet.add(drResource.getDeviceSn());
        }
        this.getFilterContext().put(PRD_HOST_SN, hostSnSet);
        return hostSnSet;
    }

    public static JSONObject updateRedoBackupLunIdByGroup(Set<ProtectObjectStorageInfo> storageInfos, List<ReplicationPair> pairList) {
        HashMap<String, Set<String>> backupArchLunMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> backupRedoLunMap = new HashMap<String, Set<String>>();
        for (ProtectObjectStorageInfo storageInfo : storageInfos) {
            if (OracleConst.DiskGroupType.DATA.getVal().equals(storageInfo.getAsmDiskGroupType())) continue;
            String dgName = storageInfo.getAsmDiskGroupName();
            Integer archiveLog = storageInfo.getArchiveLog();
            String wwn = storageInfo.getLunWWN();
            AppStorageInfo info = new AppStorageInfo();
            info.setWwn(wwn);
            info.setAsmDg(dgName);
            if ("1".equals(archiveLog.toString())) {
                OracleAllFlashFilter.groupWwnByDiskGroup(info, backupArchLunMap);
                continue;
            }
            OracleAllFlashFilter.groupWwnByDiskGroup(info, backupRedoLunMap);
        }
        JSONObject redoBackupIdByGroup = OracleAllFlashFilter.queryBackupLunByGroup(backupRedoLunMap, pairList);
        JSONObject archBackupIdByGroup = OracleAllFlashFilter.queryBackupLunByGroup(backupArchLunMap, pairList);
        JSONObject backupIdObj = new JSONObject();
        backupIdObj.put((Object)REDO, (Object)redoBackupIdByGroup);
        backupIdObj.put((Object)ARCHIVE, (Object)archBackupIdByGroup);
        return backupIdObj;
    }

    private static JSONObject queryBackupLunByGroup(Map<String, Set<String>> wwnLunByGroup, List<ReplicationPair> pairList) {
        HashMap<String, String> wwnToPair = new HashMap<String, String>();
        for (ReplicationPair replicationPair : pairList) {
            wwnToPair.put(replicationPair.getSrcLunWWN(), replicationPair.getTgtLunId());
        }
        HashMap lunIdByGroup = new HashMap();
        Set<Map.Entry<String, Set<String>>> entrySet = wwnLunByGroup.entrySet();
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String asmDgName = entry.getKey();
            Set<String> lunWwn = entry.getValue();
            lunIdByGroup.put(asmDgName, lunWwn.stream().map(wwnToPair::get).collect(Collectors.toSet()));
        }
        return JSONObject.fromObject(lunIdByGroup);
    }

    public static void updateStandbyWwnInfo(Map<String, String> extendParams, Set<AppStorageInfo> appStandbyInfoSet) {
        HashMap<String, Set<String>> archGroupMap = new HashMap<String, Set<String>>();
        HashSet<String> archiveWwns = new HashSet<String>();
        for (AppStorageInfo appStorageInfo : appStandbyInfoSet) {
            if (!OracleAppUtil.isArchive(appStorageInfo)) continue;
            archiveWwns.add(appStorageInfo.getWwn());
            OracleAllFlashFilter.groupWwnByDiskGroup(appStorageInfo, archGroupMap);
        }
        String archiveWwnStr = "";
        archiveWwnStr = archGroupMap.isEmpty() ? "--" : OracleAllFlashFilter.toStringWwnByGroup(archGroupMap);
        extendParams.put(ARCHIVE_LUN_WWN, archiveWwnStr);
        HashSet<String> remoteRedoWwns = new HashSet<String>();
        HashMap<String, Set<String>> redoGroupMap = new HashMap<String, Set<String>>();
        for (AppStorageInfo appStorageInfo : appStandbyInfoSet) {
            if (!OracleConst.DiskGroupType.LOG.getVal().equals(appStorageInfo.getAsmDgType()) && !OracleConst.DiskGroupType.CONTROL.getVal().equals(appStorageInfo.getAsmDgType())) continue;
            remoteRedoWwns.add(appStorageInfo.getWwn());
            OracleAllFlashFilter.groupWwnByDiskGroup(appStorageInfo, redoGroupMap);
        }
        extendParams.put(REDO_LUN_WWN, OracleAllFlashFilter.toStringWwnByGroup(redoGroupMap));
        Set dataWwns = appStandbyInfoSet.stream().filter(OracleAppUtil::isData).map(AppStorageInfo::getWwn).collect(Collectors.toSet());
        extendParams.put(DATA_LUN_WWN, String.join((CharSequence)",", dataWwns));
        LOGGER.info((Object)"Standby wwn size: data=%s, redo=%s, archive=%s", new Object[]{dataWwns.size(), remoteRedoWwns.size(), archiveWwns.size()});
    }

    private static String toStringWwnByGroup(Map<String, Set<String>> wwnGroupMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Set<String>> entry : wwnGroupMap.entrySet()) {
            String groupName = entry.getKey();
            Set<String> wwnByGroup = entry.getValue();
            builder.append(";");
            builder.append(groupName);
            builder.append(":");
            builder.append(String.join((CharSequence)",", wwnByGroup));
        }
        builder.delete(0, 1);
        return builder.toString();
    }

    private static void groupWwnByDiskGroup(AppStorageInfo info, Map<String, Set<String>> archGroupMap) {
        String asmDg = info.getAsmDg();
        String wwn = info.getWwn();
        Set wwnSetByGroup = archGroupMap.getOrDefault(asmDg, Collections.emptySet());
        if (VerifyUtil.isEmpty(wwnSetByGroup)) {
            wwnSetByGroup = new HashSet();
        }
        wwnSetByGroup.add(wwn);
        archGroupMap.put(asmDg, wwnSetByGroup);
    }

    private void checkSites(Map<String, String> siteSns) {
        String siteBsn;
        String devAsn = siteSns.get(SITE_A_SN);
        String devBsn = siteSns.get(SITE_B_SN);
        String siteAsn = this.checkSite(devAsn);
        if (Objects.equals(siteAsn, siteBsn = this.checkSite(devBsn))) {
            throw new LegoCheckedException(1073948210L);
        }
    }

    private boolean checkArchivePairs(ProtectObject po, List<ReplicationPair> remotePairs, List<ApplicationResource> appStandbyResource) {
        String archiveFlag = (String)po.getProps().get("ARCHIVE_LOG");
        if ("0".equals(archiveFlag)) {
            LOGGER.info((Object)"Not protect archive log, no need to check more. po id: %s", new Object[]{po.getUuid()});
            return true;
        }
        Set appStorageInfos = appStandbyResource.get(0).getAppStorageInfos();
        Set archiveSrcLunIds = appStorageInfos.stream().filter(OracleAppUtil::isArchive).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        if (archiveSrcLunIds.isEmpty()) {
            LOGGER.error((Object)"Protect archive log, but no archiveSrcLunIds found. po id: %s", new Object[]{po.getUuid()});
            return true;
        }
        long countArchiveLunWithPair = remotePairs.stream().filter(pair -> archiveSrcLunIds.contains(pair.getSrcLunId())).count();
        if (countArchiveLunWithPair != (long)archiveSrcLunIds.size()) {
            LOGGER.error((Object)"Archive srcLunIds size: %d, pairs size:%d.", new Object[]{archiveSrcLunIds.size(), countArchiveLunWithPair});
            return false;
        }
        return true;
    }

    private List<ApplicationResource> getApplicationResources(ProtectObject po) {
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType());
        ProtectObject tempPo = OracleAppUtil.clone(po);
        tempPo.getProps().put("QUERY_TYPE", "0");
        OracleAppUtil.checkAllInstanceStatus(tempPo, false);
        List appStandbyResource = applicationManager.getAppStandbyResource(po);
        if (VerifyUtil.isEmpty((Collection)appStandbyResource)) {
            LOGGER.error((Object)"%s has no data in siteB.", new Object[]{po.getName()});
            throw new LegoCheckedException(1073948191L);
        }
        this.checkControlFilePath(po, appStandbyResource);
        return appStandbyResource;
    }

    private void checkControlFilePath(ProtectObject po, List<ApplicationResource> appStandbyResource) {
        String productControlFilePath = this.getProductControlFilePath(po);
        if (VerifyUtil.isEmpty((String)productControlFilePath)) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONObject proPath = JSONObject.fromObject((Object)productControlFilePath);
        if (proPath.containsKey((Object)"controlfiles")) {
            JSONArray proPaths = proPath.getJSONArray("controlfiles");
            String pathString = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)proPaths);
            this.checkDisasterControlFilePath(po, appStandbyResource, pathString);
        }
    }

    private String getProductControlFilePath(ProtectObject po) {
        String instanceNames = (String)po.getProps().get("INSTANCENAME");
        if (VerifyUtil.isEmpty((String)instanceNames)) {
            LOGGER.error((Object)"Not find any instanceNames.");
            return "";
        }
        if (DrmEnumDefine.ProviderTypeE.HOSTGROUP.getValue() != NumberUtil.convertToInteger(po.getProps().get("PROVIDER_TYPE")).intValue()) {
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("hostSn", po.getProviderSN());
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAppUtil.checkAuthorityParameters(tempPo);
            OracleAction action = this.getActionByHostSn(po.getProviderSN());
            try {
                return action.inspectAdgStatus(tempPo.getProps());
            }
            catch (LegoCheckedException exception) {
                throw OracleAllFlashFilter.handleException(exception, tempPo, action);
            }
        }
        JSONArray instanceArray = JSONArray.fromObject((Object)instanceNames);
        LegoCheckedException ex = null;
        for (Object instanceObj : instanceArray) {
            JSONObject instance = JSONObject.fromObject(instanceObj);
            String hostSn = JsonUtil.getString((JSONObject)instance, (String)"ip", (String[])new String[]{""});
            String instanceName = JsonUtil.getString((JSONObject)instance, (String)"INSTANCENAME", (String[])new String[]{""});
            if (VerifyUtil.isEmpty((String)instanceName) || VerifyUtil.isEmpty((String)hostSn)) continue;
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", instanceName);
            tempPo.getProps().put("hostSn", hostSn);
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAction action = this.getActionByHostSn(hostSn);
            OracleAppUtil.checkAuthorityParameters(tempPo);
            try {
                return action.inspectAdgStatus(tempPo.getProps());
            }
            catch (LegoCheckedException exception) {
                LOGGER.error((Object)"Can not find control file, hostSn:%s", new Object[]{hostSn});
                ex = OracleAllFlashFilter.handleException(exception, tempPo, action);
            }
        }
        if (ex != null) {
            throw ex;
        }
        return "";
    }

    private static LegoCheckedException handleException(LegoCheckedException exception, ProtectObject tempPo, OracleAction action) {
        if (exception.getErrorCode() == 1073948515L) {
            String instanceName = (String)tempPo.getProps().get("INSTANCENAME");
            return new LegoCheckedException(1073948515L, new String[]{instanceName, action.getExtend().getNetworkIpAddress()});
        }
        return exception;
    }

    private OracleAction getActionByHostSn(String hostSn) {
        INeMgrProtocolExtendService neMgr = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        NeMgrProtocolExtend ne = DrHostUtil.getNeMgrProtocolExtend((INeMgrProtocolExtendService)neMgr, (String)hostSn);
        return new OracleAction(ne, (String)ne.getExtendParams().get("mac_address"));
    }

    private void checkDisasterControlFilePath(ProtectObject po, List<ApplicationResource> appStandbyResource, String path) {
        LegoCheckedException otherException = null;
        for (ApplicationResource appResInfo : appStandbyResource) {
            String hostSn = appResInfo.getHostSn();
            String instanceName = (String)appResInfo.getExtendParams().get("INSTANCENAME");
            ProtectObject tempPo = OracleAppUtil.clone(po);
            tempPo.getProps().put("INSTANCENAME", instanceName);
            tempPo.getProps().put("hostSn", hostSn);
            tempPo.getProps().put("controlfile", path);
            tempPo.getProps().put("QUERY_TYPE", "1");
            OracleAction action = this.getActionByHostSn(hostSn);
            OracleAppUtil.checkAuthorityParameters(tempPo);
            try {
                action.inspectAdgStatus(tempPo.getProps());
                break;
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 1073948533L) {
                    LOGGER.error((Object)"Check control file failed, instanceName:%s, hostSn:%s", new Object[]{instanceName, hostSn});
                    throw e;
                }
                otherException = e;
            }
        }
        if (!VerifyUtil.isEmpty(otherException)) {
            LOGGER.error((Object)"Can not check control file in all nodes.");
            throw otherException;
        }
    }

    private void filterPairsByTgtSN(List<ReplicationPair> pairList, String tgtSN) {
        pairList.removeIf(pair -> !tgtSN.equals(pair.getTgtDevSN()));
    }

    private void fillContext(Map<String, String> siteSns, Map<String, String> extendParams, Map<String, Object> context, List<ReplicationPair> remotePairs, ProtectObject po) {
        context.put(SITE_A_SN, siteSns.get(SITE_A_SN));
        context.put(SITE_B_SN, siteSns.get(SITE_B_SN));
        context.put(OCACLE_SITE_A, this.getSiteByDeviceSN(siteSns.get(SITE_A_SN)).getSiteId());
        context.put(OCACLE_SITE_B, this.getSiteByDeviceSN(siteSns.get(SITE_B_SN)).getSiteId());
        context.put(STAND_BY_HOSTSNS, extendParams.get(STAND_BY_HOSTSNS));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("IS_ASM_LIB", String.valueOf(context.get("IS_ASM_LIB")));
        paramMap.put("STANDBY_DB_NAME", extendParams.get("STANDBY_DB_NAME"));
        paramMap.put(REDO_LUN_WWN, extendParams.get(REDO_LUN_WWN));
        paramMap.put(DATA_LUN_WWN, extendParams.get(DATA_LUN_WWN));
        paramMap.put(PRD_DATA_LUN_WWN, extendParams.get(PRD_DATA_LUN_WWN));
        paramMap.put(ARCHIVE_LUN_WWN, extendParams.get(ARCHIVE_LUN_WWN));
        paramMap.put(REDO_BACK_UP_LUN_IDS, extendParams.get(REDO_BACK_UP_LUN_IDS));
        ArrayList srcLunIds = new ArrayList();
        ArrayList trgLunIds = new ArrayList();
        remotePairs.forEach(pair -> {
            srcLunIds.add(pair.getSrcLunId());
            trgLunIds.add(pair.getTgtLunId());
        });
        paramMap.put(REMOTE_PAIR_SRCLUNIDS, String.join((CharSequence)",", srcLunIds));
        paramMap.put(REMOTE_PAIR_TRGLUNIDS, String.join((CharSequence)",", trgLunIds));
        context.put(po.getUuid(), paramMap);
    }

    private List<ReplicationPair> getpairsByApplicationResource(List<ApplicationResource> appStandbyResource) {
        if (VerifyUtil.isEmpty(appStandbyResource)) {
            LOGGER.warn((Object)"The parameter appStandbyResource is empty!");
            LOGGER.info((Object)"End %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName()});
            throw new LegoCheckedException(1073948191L);
        }
        String siteBSn = appStandbyResource.get(0).getDevSn();
        Set appLunInfos = appStandbyResource.get(0).getAppStorageInfos();
        List lunIdList = appLunInfos.stream().map(AppStorageInfo::getResourceId).collect(Collectors.toList());
        Site site = this.getSiteByDeviceSN(siteBSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            LOGGER.warn((Object)"Can't get site by deviceSN: %s", new Object[]{siteBSn});
            throw new LegoCheckedException(1073948449L);
        }
        return this.getPairsByResourceIds(siteBSn, lunIdList, site, DrmEnumDefine.ResourceTypeE.LUN.getValue());
    }

    private boolean checkPairEqualNum(List<ReplicationPair> pairs, List<ReplicationPair> remotePairs) {
        boolean isPairEqual = pairs.size() == remotePairs.size();
        LOGGER.info((Object)"Compare pair size: A->B=%s, B->A=%s", new Object[]{pairs.size(), remotePairs.size()});
        return isPairEqual;
    }

    private boolean checkReplicationPairs(Map<String, String> siteSns, ApplicationResource applicationResource, List<ReplicationPair> replicationPairs, List<ReplicationPair> remotePairs) {
        Set controlPair;
        if (!siteSns.containsKey(SITE_A_SN) || !siteSns.containsKey(SITE_B_SN)) {
            LOGGER.error((Object)"SiteSn doesnt have enough site: %s", new Object[]{siteSns});
            return false;
        }
        LOGGER.debug((Object)"Begin Check Pairs");
        Set controlLunIdSet = applicationResource.getAppStorageInfos().stream().filter(info -> OracleConst.DiskGroupType.CONTROL.getVal().equals(info.getAsmDgType())).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        if (!controlLunIdSet.isEmpty() && (controlPair = remotePairs.stream().filter(pair -> controlLunIdSet.contains(pair.getSrcLunId())).collect(Collectors.toSet())).isEmpty()) {
            LOGGER.error((Object)"Control file dont have pair: %s", new Object[]{controlLunIdSet});
            throw new LegoCheckedException(1073948518L);
        }
        Set<String> remoteRedoLunId = applicationResource.getAppStorageInfos().stream().filter(appStorageInfo -> OracleConst.DiskGroupType.LOG.getVal().equals(appStorageInfo.getAsmDgType())).map(AppStorageInfo::getResourceId).collect(Collectors.toSet());
        this.checkRedoPairNum(remoteRedoLunId, remotePairs);
        boolean isPairsOfSitesOk = this.checkSiteAPairs(siteSns, replicationPairs) && this.checkSiteBPairs(siteSns, remotePairs);
        Object isSiteAInCG = this.getFilterContext().get("siteASn_IS_CG");
        Object isSiteBInCG = this.getFilterContext().get("siteBSn_IS_CG");
        return isPairsOfSitesOk && Objects.equals(isSiteAInCG, isSiteBInCG);
    }

    private void checkRedoPairNum(Set<String> redoLunIdSet, List<ReplicationPair> pairs) {
        HashMap<String, ReplicationPair> lunIdToPairMap = new HashMap<String, ReplicationPair>();
        String devSn = "";
        for (ReplicationPair repPair : pairs) {
            lunIdToPairMap.put(repPair.getSrcLunId(), repPair);
            devSn = repPair.getSrcDevSN();
        }
        for (String lunId : redoLunIdSet) {
            if (lunIdToPairMap.containsKey(lunId)) continue;
            LOGGER.error((Object)"Redo lun must have pair: lunId=%s, devSn=%s", new Object[]{lunId, devSn});
            throw new LegoCheckedException(1073948175L);
        }
    }

    private boolean checkSiteAPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        LOGGER.debug((Object)"Begin check siteA pairs.");
        return this.checkSitePairs(siteSns, replicationPairs, true);
    }

    private boolean checkSitePairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs, boolean isSiteA) {
        String checkSite;
        String string = checkSite = isSiteA ? "A" : "B";
        if (VerifyUtil.isEmpty(replicationPairs)) {
            LOGGER.error((Object)"There are no pairs on site%s.", new Object[]{checkSite});
            return false;
        }
        String siteASn = siteSns.get(SITE_A_SN);
        String siteBSn = siteSns.get(SITE_B_SN);
        boolean isConsistentGroup = false;
        HashSet<String> cgIdSet = new HashSet<String>();
        ArrayList<ReplicationPair> cgIdNullList = new ArrayList<ReplicationPair>();
        for (ReplicationPair pair : replicationPairs) {
            String cgId = pair.getConsistentGroupId();
            if (!VerifyUtil.isEmpty((String)cgId) && !"--".equals(cgId)) {
                isConsistentGroup = true;
                cgIdSet.add(cgId);
            } else {
                cgIdNullList.add(pair);
            }
            boolean isSiteAAndSiteB = isSiteA ? siteASn.equals(pair.getSrcDevSN()) && siteBSn.equals(pair.getTgtDevSN()) : siteBSn.equals(pair.getSrcDevSN()) && siteASn.equals(pair.getTgtDevSN());
            boolean isSync = pair.getReplicationMode() == 1;
            boolean isPairNormalOrSynchronizing = this.checkPairNormalOrSynchronizing(isSiteA, pair);
            if (isSync && isPairNormalOrSynchronizing && isSiteAAndSiteB) continue;
            LOGGER.warn((Object)"Failed check site%s pairs, isSync: %s; isPairNormalOrSynchronizing: %s; isSiteAAndSiteB: %s.", new Object[]{checkSite, isSync, isPairNormalOrSynchronizing, isSiteAAndSiteB});
            return false;
        }
        this.getFilterContext().put((isSiteA ? SITE_A_SN : SITE_B_SN) + "_IS_CG", isConsistentGroup);
        this.checkConsistentGroup(isConsistentGroup, replicationPairs, cgIdSet, cgIdNullList, checkSite);
        LOGGER.debug((Object)"Finish check site%s pairs.", new Object[]{checkSite});
        return true;
    }

    private boolean checkPairNormalOrSynchronizing(boolean isSiteA, ReplicationPair pair) {
        boolean isPairNormalOrSynchronizing;
        boolean bl = isPairNormalOrSynchronizing = String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue()).equals(pair.getRunningState()) || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(pair.getRunningState());
        if (!isSiteA) {
            isPairNormalOrSynchronizing = isPairNormalOrSynchronizing || String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue()).equals(pair.getRunningState());
        }
        return isPairNormalOrSynchronizing;
    }

    private void checkConsistentGroup(boolean isConsistentGroup, List<ReplicationPair> replicationPairs, Set<String> cgIdSet, List<ReplicationPair> cgIdNullList, String checkSite) {
        if (!isConsistentGroup && replicationPairs.size() > 1) {
            LOGGER.error((Object)"Pairs of site%s doesnt in the same cg: %s", new Object[]{checkSite, String.valueOf(replicationPairs.size())});
            throw new LegoCheckedException(1073948176L);
        }
        if (isConsistentGroup && cgIdSet.size() != 1) {
            LOGGER.error((Object)"Some pair of site%s doesnt in the same cg: %s", new Object[]{checkSite, String.join((CharSequence)",", cgIdSet)});
            throw new LegoCheckedException(1073948176L);
        }
        if (isConsistentGroup && !cgIdNullList.isEmpty()) {
            List lunNames = cgIdNullList.stream().map(ReplicationPair::getSrcLunName).collect(Collectors.toList());
            LOGGER.error((Object)"Some pair of site%s doesnt in the cg: %s", new Object[]{checkSite, String.join((CharSequence)",", lunNames)});
            throw new LegoCheckedException(1073948176L);
        }
    }

    private boolean checkSiteBPairs(Map<String, String> siteSns, List<ReplicationPair> replicationPairs) {
        LOGGER.debug((Object)"Begin check siteB pairs");
        return this.checkSitePairs(siteSns, replicationPairs, false);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        String siteA = null;
        String siteB = null;
        if (this.getFilterContext().get(OCACLE_SITE_A) instanceof String) {
            siteA = (String)this.getFilterContext().get(OCACLE_SITE_A);
        }
        if (this.getFilterContext().get(OCACLE_SITE_B) instanceof String) {
            siteB = (String)this.getFilterContext().get(OCACLE_SITE_B);
        }
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteA, siteB));
        return path;
    }
}

