/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateProtectionGroupSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationGroupSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdgCreatePoReplicationGroupProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgCreatePoReplicationGroupProcessor.class);

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Create po replication group failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> processors = this.createConsistentGroupProcessors(context);
            this.setChildProc(processors);
        } else {
            for (RecoveryProcessor recoveryProcessor : this.getChildProc()) {
                if (!(recoveryProcessor instanceof CreateReplicationGroupSubProcessor)) continue;
                CreateReplicationGroupSubProcessor processor = (CreateReplicationGroupSubProcessor)recoveryProcessor;
                String localpgId = processor.getProperty("localpgId");
                String rmtpgId = processor.getProperty("rmtpgId");
                ReplicationGroup group = processor.getProperty("aToB") != null ? this.getReplicationGroup(context, true) : this.getReplicationGroup(context, false);
                group.setLocalPgId(localpgId);
                group.setRemotePgId(rmtpgId);
                processor.setGroup(group);
            }
        }
        return this.executeSubProcessor(context);
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        ReplicationGroup aToBGroup = this.getReplicationGroup(context, true);
        ReplicationGroup bToAGroup = this.getReplicationGroup(context, false);
        if (this.isLunGroup(context)) {
            aToBGroup.setLocalPgId(this.getProtectionGroupId(context, OracleAppUtil.generateGroupKey(this.getPoId(), true, true, "DELETED_PG_OBJECTS")));
            aToBGroup.setRemotePgId(this.getProtectionGroupId(context, OracleAppUtil.generateGroupKey(this.getPoId(), true, false, "DELETED_PG_OBJECTS")));
            bToAGroup.setLocalPgId(this.getProtectionGroupId(context, OracleAppUtil.generateGroupKey(this.getPoId(), false, true, "DELETED_PG_OBJECTS")));
            bToAGroup.setRemotePgId(this.getProtectionGroupId(context, OracleAppUtil.generateGroupKey(this.getPoId(), false, false, "DELETED_PG_OBJECTS")));
        } else {
            aToBGroup.setLocalPgId(this.getProtectionGroupIdByRp(context, "-aToBSrcGroup"));
            aToBGroup.setRemotePgId(this.getProtectionGroupIdByRp(context, "-aToBTgtGroup"));
            bToAGroup.setLocalPgId(this.getProtectionGroupIdByRp(context, "-bToASrcGroup"));
            bToAGroup.setRemotePgId(this.getProtectionGroupIdByRp(context, "-bToATgtGroup"));
        }
        RecoveryProcessor aToBSubProcessor = this.createReplicationGroupSubProcessor(aToBGroup);
        aToBSubProcessor.setProperty("aToB", (Object)"aToB");
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        subProcessors.add(aToBSubProcessor);
        RecoveryProcessor bToASubProcessor = this.createReplicationGroupSubProcessor(bToAGroup);
        bToASubProcessor.setProperty("bToA", (Object)"bToA");
        subProcessors.add(bToASubProcessor);
        context.setAttribute(this.getPoId() + "_cgProcessors", subProcessors);
        return subProcessors;
    }

    private ReplicationGroup getReplicationGroup(RecoveryProcessorContext context, boolean isAToB) {
        List replicationGroupList = (List)CastUtil.castTo((Object)context.getAttribute("DELETED_REP_CG_OBJECTS_" + this.getPoId()), List.class);
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        String sn = isAToB ? replica.getProductArray() : replica.getRecoveryArray();
        String tgtSn = isAToB ? replica.getRecoveryArray() : replica.getProductArray();
        ReplicationGroup group = replicationGroupList.stream().filter(rg -> rg.getSrcDevSN().equals(sn)).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
        group.setTgtDevSN(tgtSn);
        return group;
    }

    private String getProtectionGroupId(RecoveryProcessorContext context, String processorKey) {
        Set processors = (Set)CastUtil.castTo((Object)context.getAttribute(this.getPoId() + "_pgProcessors"), Set.class);
        for (CreateProtectionGroupSubProcessor processor : processors) {
            if (!processor.getProperty(processor.getRecoveryTasksKey()).equals(processorKey)) continue;
            return processor.getCreatedGroupId();
        }
        LOGGER.error((Object)"Can not find create protection group sub processor.");
        throw new LegoCheckedException(1073947393L);
    }

    private String getProtectionGroupIdByRp(RecoveryProcessorContext context, String pgKey) {
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        return (String)recoveryPlan.getGlobalSettings().get(this.getPoId() + pgKey);
    }

    private boolean isLunGroup(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        return Boolean.parseBoolean((String)recoveryPlan.getGlobalSettings().get(this.getPoId() + "isLunGroup"));
    }

    private RecoveryProcessor createReplicationGroupSubProcessor(ReplicationGroup group) {
        CreateReplicationGroupSubProcessor processor = new CreateReplicationGroupSubProcessor();
        processor.setProperty("localpgId", (Object)group.getLocalPgId());
        processor.setProperty("rmtpgId", (Object)group.getRemotePgId());
        processor.setGroup(group);
        processor.setProcName(processor.getName());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcessId(this.getProcessId());
        processor.setProcType(this.getProcType());
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }
}

