/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AdgCreatePoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgCreatePoReplicationProcessor.class);

    @Override
    protected Set<RecoveryProcessor> createReplicationPairProcessors(RecoveryProcessorContext context) {
        return this.createConsistentGroupProcessors(context);
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        Map globalSettings = recoveryPlan.getGlobalSettings();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        String aToBSrcJson = (String)globalSettings.get(this.getPoId() + "_aToBSrcMapping");
        String bToASrcJson = (String)globalSettings.get(this.getPoId() + "_bToASrcMapping");
        Set<RecoveryProcessor> subProcessors = this.createSubProcessor(replica.getProductArray(), replica.getRecoveryArray(), aToBSrcJson, bToASrcJson);
        String aToBTgtJson = (String)globalSettings.get(this.getPoId() + "_aToBTgtMapping");
        String bToATgtJson = (String)globalSettings.get(this.getPoId() + "_bToATgtMapping");
        subProcessors.addAll(this.createSubProcessor(replica.getRecoveryArray(), replica.getProductArray(), aToBTgtJson, bToATgtJson));
        context.setAttribute(this.getPoId() + "_pairProcessor", subProcessors);
        LOGGER.info((Object)"Create create po replication sub processors success.");
        return subProcessors;
    }

    private Set<RecoveryProcessor> createSubProcessor(String srcDevSn, String tgtDevSn, String srcJson, String tgtJson) {
        JSONArray srcDgArray = JSONArray.fromObject((Object)srcJson);
        List srcLunIdList = JSONArray.toCollection((JSONArray)srcDgArray, String.class);
        JSONArray tgtDgArray = JSONArray.fromObject((Object)tgtJson);
        List tgtLunIdList = JSONArray.toCollection((JSONArray)tgtDgArray, String.class);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        HashSet<String> noMappingLunIds = new HashSet<String>();
        for (String srcLunId : srcLunIdList) {
            String srcResourceId = srcLunId.split(":")[2];
            String remoteResourceId = this.getRemoteResourceId(srcLunId, tgtLunIdList);
            if (VerifyUtil.isEmpty((String)remoteResourceId)) {
                noMappingLunIds.add(srcResourceId);
                continue;
            }
            if (this.checkResourceId(srcResourceId, remoteResourceId, subProcessors)) continue;
            CreateReplicationSubProcessor subProcessor = new CreateReplicationSubProcessor();
            subProcessor.setSrcDevSn(srcDevSn);
            subProcessor.setTargetDevSn(tgtDevSn);
            subProcessor.setSrcResourceId(srcResourceId);
            subProcessor.setRemoteResourceId(remoteResourceId);
            subProcessor.setSrcResourceType(11);
            subProcessor.setReplicationMode(1);
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessors.add((RecoveryProcessor)subProcessor);
        }
        this.checkNoMappingLunIds(noMappingLunIds, subProcessors);
        return subProcessors;
    }

    private void checkNoMappingLunIds(Set<String> noMappingLunIds, Set<RecoveryProcessor> subProcessors) {
        for (String noMappingLunId : noMappingLunIds) {
            if (this.checkResourceId(noMappingLunId, "", subProcessors)) continue;
            LOGGER.error((Object)"Cant find lunId:%s mapping.", new Object[]{noMappingLunId});
            throw new LegoCheckedException(1073947792L);
        }
    }

    private String getRemoteResourceId(String srcLunId, List<String> tgtLunIdList) {
        String[] array = srcLunId.split(":");
        String suffix = array[0] + ":" + array[1];
        String lunId = "";
        for (String tgtLunId : tgtLunIdList) {
            String[] tgtLunArray = tgtLunId.split(":");
            String tgt = tgtLunArray[0] + ":" + tgtLunArray[1];
            if (!tgt.equals(suffix)) continue;
            lunId = tgtLunArray[2];
            break;
        }
        return lunId;
    }

    private boolean checkResourceId(String srcResourceId, String remoteResourceId, Set<RecoveryProcessor> subProcessors) {
        boolean checkResult = false;
        for (RecoveryProcessor subProcessor : subProcessors) {
            if (!(subProcessor instanceof CreateReplicationSubProcessor) || !((CreateReplicationSubProcessor)subProcessor).getSrcResourceId().equals(srcResourceId) || !VerifyUtil.isEmpty((String)remoteResourceId) && !((CreateReplicationSubProcessor)subProcessor).getRemoteResourceId().equals(remoteResourceId)) continue;
            checkResult = true;
            break;
        }
        return checkResult;
    }
}

