/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.oracle.recovery.process.AdgCreatePoReplicationProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class AdgCreateReplicationProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgCreateReplicationProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Create replication failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            ProtectGroup protectGroup = context.getProtectGroup();
            Set pos = protectGroup.getPolist();
            HashSet<AdgCreatePoReplicationProcessor> subProcessors = new HashSet<AdgCreatePoReplicationProcessor>();
            for (ProtectObject po : pos) {
                AdgCreatePoReplicationProcessor processor = new AdgCreatePoReplicationProcessor();
                processor.setPoId(po.getUuid());
                processor.setPoName(po.getName());
                processor.setProcName(processor.getName());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcessId(this.getProcessId());
                processor.setProcType(this.getProcType());
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                subProcessors.add(processor);
            }
            this.saveSubProcessors(subProcessors);
        } else {
            this.initChildProc(context);
        }
        return this.executeSubProcessor(context);
    }

    private void initChildProc(RecoveryProcessorContext context) {
        Set childProc = this.getChildProc();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            if (!(recoveryProcessor instanceof AdgCreatePoReplicationProcessor)) continue;
            context.setAttribute(((AdgCreatePoReplicationProcessor)recoveryProcessor).getPoId() + "_pairProcessor", (Object)recoveryProcessor.getChildProc());
        }
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryLog log = planService.getLatestSuccessHistoryRecoveryLog(this.getPlanId(), Long.valueOf(new Date().getTime()));
        this.setIsEnabled(VerifyUtil.isEmpty((Object)log) || log.getLogType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue());
        this.setIsEditable(false);
    }
}

