/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorStorageRelationPSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.OracleAdgConfigProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorStorageRelationProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class AdgRefactorStorageRelationProcessor
extends RefactorStorageRelationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OracleAdgConfigProcessor.class);

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        boolean isPlanSwitch;
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryLog log = recoveryPlanService.getLatestSuccessHistoryRecoveryLog(this.getPlanId(), Long.valueOf(new Date().getTime()));
        boolean bl = isPlanSwitch = VerifyUtil.isEmpty((Object)log) || log.getLogType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue();
        if (isPlanSwitch) {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        }
    }

    public boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create OracleAdgConfigProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (recoveryTemplate == null) {
            LOGGER.error((Object)"OracleAdgConfigProcessor recoveryTemplate is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        pg.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)pg);
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<AdgRefactorStorageRelationPSubProcessor> recoveryProcessors = new HashSet<AdgRefactorStorageRelationPSubProcessor>();
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        if (CollectionUtils.isEmpty((Collection)allPos)) {
            LOGGER.error((Object)"Not find po list.");
            return false;
        }
        for (ProtectObject po : allPos) {
            AdgRefactorStorageRelationPSubProcessor processor = new AdgRefactorStorageRelationPSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setPoId(po.getUuid());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            recoveryProcessors.add(processor);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(recoveryProcessors);
        } else {
            this.setChildProc(recoveryProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

