/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.oracle.recovery.process.AdgRemovePoLunProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageProtectGroupManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdgRemoveLunProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgRemoveLunProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Remove lun from group failed because the context is null.");
            return this.failure();
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessors = this.generateSubProcessor(context, protectGroup);
            if (subProcessors.isEmpty()) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            this.saveSubProcessors(subProcessors);
        }
        return this.executeSubProcessor(context);
    }

    private Set<RecoveryProcessor> generateSubProcessor(RecoveryProcessorContext context, ProtectGroup protectGroup) {
        Set pos = protectGroup.getPolist();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : pos) {
            if (!this.isUsingProtectionGroupInAdg(protectGroup, po)) {
                LOGGER.info((Object)"Po:%s is not consistent group, skip remove lun step.", new Object[]{po.getName()});
                continue;
            }
            AdgRemovePoLunProcessor processor = new AdgRemovePoLunProcessor();
            processor.setPoId(po.getUuid());
            processor.setPoName(po.getName());
            processor.setProcName(processor.getName());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcessId(this.getProcessId());
            processor.setProcType(this.getProcType());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            this.initRemoveLunSubProcessor(context, processor);
            subProcessors.add((RecoveryProcessor)processor);
        }
        return subProcessors;
    }

    private void initRemoveLunSubProcessor(RecoveryProcessorContext context, AdgRemovePoLunProcessor processor) {
        Set<RecoveryProcessor> removeLunSubProcessors = processor.createConsistentGroupProcessors(context);
        processor.setChildProc(removeLunSubProcessors);
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryLog log = planService.getLatestSuccessHistoryRecoveryLog(this.getPlanId(), Long.valueOf(new Date().getTime()));
        this.setIsEnabled(VerifyUtil.isEmpty((Object)log) || log.getLogType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue());
        this.setIsEditable(false);
    }

    private boolean isUsingProtectionGroupInAdg(ProtectGroup protectGroup, ProtectObject protectObject) {
        List<ReplicationPair> pairList = OracleAppUtil.getPairList(protectGroup, protectObject.getUuid(), true);
        ReplicationPair replicationPair = (ReplicationPair)CommonUtil.getFirstElement(pairList);
        String devSn = replicationPair.getSrcDevSN();
        String lunId = replicationPair.getSrcLunId();
        StorageProtectGroupManagerProxy groupManager = StorageProtectGroupManagerProxy.getInstance();
        HvsProtectionGroup hvsPg = groupManager.associatedQueryProtectionGroup(devSn, 11, lunId);
        return !VerifyUtil.isEmpty((Object)hvsPg) && !VerifyUtil.isEmpty((String)hvsPg.getProtectGroupId());
    }
}

