/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationOperateSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AdgSplitPoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgSplitPoReplicationProcessor.class);
    private static final String PAIR_NAME = "com.huawei.ism.drm.oracle.recovery.process.AdgSplitPoReplicationProcessor.pair";
    private static final String GROUP_NAME = "com.huawei.ism.drm.oracle.recovery.process.AdgSplitPoReplicationProcessor.consistent";

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Create split po replication processor failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)protectGroup.getPolist(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessors = OracleAppUtil.isConsistentGroup(po) ? this.createConsistentGroupProcessors(context) : this.createReplicationPairProcessors(context);
            this.setChildProc(subProcessors);
        }
        return this.executeSubProcessor(context);
    }

    @Override
    protected Set<RecoveryProcessor> createReplicationPairProcessors(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ReplicationPair> aToBPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), true);
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Set<RecoveryProcessor> processors = aToBPairList.stream().map(pair -> {
            ReplicationOperateSubProcessor subProcessor = ReplicationOperateSubProcessor.createReplicationPairSplitProcessor((String)replica.getProductArray(), (String)replica.getRecoveryArray(), (String)pair.getReplicationId());
            subProcessor.setSplit(true);
            subProcessor.getProps().put("recovery-phase", "after-synchronize");
            this.initSubProcessor((RecoveryProcessor)subProcessor);
            return subProcessor;
        }).collect(Collectors.toSet());
        LOGGER.debug((Object)"Create a to b processor success, size:%s", (long)processors.size());
        List<ReplicationPair> bToAPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), false);
        Set processors2 = bToAPairList.stream().map(pair -> {
            ReplicationOperateSubProcessor subProcessor = ReplicationOperateSubProcessor.createReplicationPairSplitProcessor((String)replica.getRecoveryArray(), (String)replica.getProductArray(), (String)pair.getReplicationId());
            subProcessor.setSplit(true);
            subProcessor.getProps().put("recovery-phase", "after-synchronize");
            this.initSubProcessor((RecoveryProcessor)subProcessor);
            return subProcessor;
        }).collect(Collectors.toSet());
        processors.addAll(processors2);
        this.savePairIdsToRecoveryPlan(context, aToBPairList, bToAPairList);
        LOGGER.info((Object)"Create split replication pair sub processor success.");
        return processors;
    }

    private void savePairIdsToRecoveryPlan(RecoveryProcessorContext context, List<ReplicationPair> aToBPairList, List<ReplicationPair> bToAPairList) {
        List aToBPairIdList = aToBPairList.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toList());
        List bToAPairIdList = bToAPairList.stream().map(ReplicationRelation::getReplicationId).collect(Collectors.toList());
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        recoveryPlan.getGlobalSettings().put(this.getPoId() + "_aToBPairIds", String.join((CharSequence)",", aToBPairIdList));
        recoveryPlan.getGlobalSettings().put(this.getPoId() + "_bToAPairIds", String.join((CharSequence)",", bToAPairIdList));
        HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        hibernateTemplate.saveOrUpdate((Object)recoveryPlan);
        LOGGER.info((Object)"Save pair ids to plan success.");
    }

    private void initSubProcessor(RecoveryProcessor subProcessor) {
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setProcType(this.getProcType());
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        List<ReplicationPair> aToBPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), true);
        List cgIdList = aToBPairList.stream().map(ReplicationPair::getConsistentGroupId).distinct().collect(Collectors.toList());
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        Set<RecoveryProcessor> processors = cgIdList.stream().map(id -> {
            ReplicationOperateSubProcessor subProcessor = ReplicationOperateSubProcessor.createReplicationGroupSplitProcessor((String)replica.getProductArray(), (String)replica.getRecoveryArray(), (String)id);
            subProcessor.setSplit(true);
            subProcessor.getProps().put("recovery-phase", "consistent");
            this.initSubProcessor((RecoveryProcessor)subProcessor);
            return subProcessor;
        }).collect(Collectors.toSet());
        LOGGER.debug((Object)"Create a to b processor success, size:%s", (long)processors.size());
        List<ReplicationPair> bToAPairList = OracleAppUtil.getPairList(protectGroup, this.getPoId(), false);
        List cgIdList2 = bToAPairList.stream().map(ReplicationPair::getConsistentGroupId).distinct().collect(Collectors.toList());
        Set processors2 = cgIdList2.stream().map(id -> {
            ReplicationOperateSubProcessor subProcessor = ReplicationOperateSubProcessor.createReplicationGroupSplitProcessor((String)replica.getRecoveryArray(), (String)replica.getProductArray(), (String)id);
            subProcessor.setSplit(true);
            subProcessor.getProps().put("recovery-phase", "consistent");
            this.initSubProcessor((RecoveryProcessor)subProcessor);
            return subProcessor;
        }).collect(Collectors.toSet());
        processors.addAll(processors2);
        this.savePairIdsToRecoveryPlan(context, aToBPairList, bToAPairList);
        LOGGER.info((Object)"Create split consistent group sub processor success.");
        return processors;
    }

    @Override
    protected void updateProcessNameParam(RecoveryProcessorContext context) {
        boolean isConsistentGroup;
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)protectGroup.getPolist(), (String)this.getPoId());
        boolean bl = isConsistentGroup = this.getProperty("isConsistentGroup") != null ? Boolean.parseBoolean(this.getProperty("isConsistentGroup")) : OracleAppUtil.isConsistentGroup(po);
        if (isConsistentGroup) {
            this.updateProcessName(PAIR_NAME);
        } else {
            this.updateProcessName(GROUP_NAME);
        }
        this.setProperty("isConsistentGroup", isConsistentGroup);
        super.updateProcessNameParam(context);
    }
}

