/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.AdgRefactorPoReplicationProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AdgSyncPoReplicationProcessor
extends AdgRefactorPoReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(AdgSyncPoReplicationProcessor.class);
    private static final String PAIR_NAME = "com.huawei.ism.drm.oracle.recovery.process.AdgSyncPoReplicationProcessor.pair";
    private static final String GROUP_NAME = "com.huawei.ism.drm.oracle.recovery.process.AdgSyncPoReplicationProcessor.consistent";

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParam(context);
        if (VerifyUtil.isEmpty((Object)context)) {
            LOGGER.error((Object)"Create sync po replication processor failed because the context is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)protectGroup.getPolist(), (String)this.getPoId());
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            Set<RecoveryProcessor> subProcessors = this.isConsistentGroup(context, po) ? this.createConsistentGroupProcessors(context) : this.createReplicationPairProcessors(context);
            this.setChildProc(subProcessors);
        }
        return this.executeSubProcessor(context);
    }

    private boolean isConsistentGroup(RecoveryProcessorContext context, ProtectObject po) {
        Object attribute = context.getAttribute("DELETED_REP_CG_OBJECTS_" + po.getUuid());
        return attribute != null;
    }

    @Override
    protected Set<RecoveryProcessor> createReplicationPairProcessors(RecoveryProcessorContext context) {
        Set processors = (Set)CastUtil.castTo((Object)context.getAttribute(this.getPoId() + "_pairProcessor"), Set.class);
        Map<String, List<CreateReplicationSubProcessor>> devSnAndProcessorMap = processors.stream().collect(Collectors.groupingBy(CreateReplicationSubProcessor::getSrcDevSn));
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        List bToAPairIds = devSnAndProcessorMap.get(replica.getRecoveryArray()).stream().map(CreateReplicationSubProcessor::getReplicationId).collect(Collectors.toList());
        Set<RecoveryProcessor> processorSet = bToAPairIds.stream().map(id -> {
            SyncReplicationSubProcessor processor = new SyncReplicationSubProcessor();
            processor.setReplicationId(id);
            processor.setCurrentSrcDeviceSN(replica.getRecoveryArray());
            processor.setCurrentTgtDeviceSN(replica.getProductArray());
            processor.setSrcDeviceId(replica.getRecoveryArray());
            processor.setTgtDeviceId(replica.getProductArray());
            processor.setRelationType(Integer.valueOf(0));
            this.initProcessor(processor);
            return processor;
        }).collect(Collectors.toSet());
        LOGGER.info((Object)"Create sync po replication processors success.");
        return processorSet;
    }

    private void initProcessor(SyncReplicationSubProcessor processor) {
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    @Override
    protected Set<RecoveryProcessor> createConsistentGroupProcessors(RecoveryProcessorContext context) {
        String bToACgId = this.getReplicationGroupId(context, "bToA");
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        SyncReplicationSubProcessor processor = new SyncReplicationSubProcessor();
        processor.setReplicationId(bToACgId);
        processor.setCurrentSrcDeviceSN(replica.getRecoveryArray());
        processor.setCurrentTgtDeviceSN(replica.getProductArray());
        processor.setSrcDeviceId(replica.getRecoveryArray());
        processor.setTgtDeviceId(replica.getProductArray());
        processor.setRelationType(Integer.valueOf(1));
        this.initProcessor(processor);
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        processors.add((RecoveryProcessor)processor);
        LOGGER.info((Object)"Create sync consistent group processors success.");
        return processors;
    }

    private String getReplicationGroupId(RecoveryProcessorContext context, String processKey) {
        Set processors = (Set)CastUtil.castTo((Object)context.getAttribute(this.getPoId() + "_cgProcessors"), Set.class);
        return processors.stream().filter(processor -> processor.getProperty(processKey) != null).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L)).getCreatedGroupId();
    }

    @Override
    protected void updateProcessNameParam(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectObject po = DBRecoveryTools.getProtectObjectByPoId((Set)protectGroup.getPolist(), (String)this.getPoId());
        if (!this.isConsistentGroup(context, po)) {
            this.updateProcessName(PAIR_NAME);
        } else {
            this.updateProcessName(GROUP_NAME);
        }
        super.updateProcessNameParam(context);
    }
}

