/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.oracle.recovery.process.DeleteLunMappingFromLunGroupSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteLunMappingFromLunGroupProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteLunMappingFromLunGroupProcessor.class);

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean isSuccess;
        if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && !(isSuccess = this.createSubProcessors(context))) {
            LOGGER.error((Object)"Create OracleAdgConfigProcessor sub processor failed");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        ProtectGroup pg = context.getProtectGroup();
        Set polist = pg.getPolist();
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        RecoveryPlan recoveryPlan = OracleAppUtil.getCurrentRecoveryPlan(context.getRecoveryPlan());
        for (ProtectObject po : polist) {
            List<String> bToASrcLunIdList = OracleAppUtil.getRemoteLunIdList(po);
            String bToASrcLunGroupId = (String)recoveryPlan.getGlobalSettings().get(po.getUuid() + "-bToASrcLunGroupId");
            this.createDeleteMappingSubProcessors(bToASrcLunIdList, bToASrcLunGroupId, processors, context);
            String aToBTgtLunGroupId = (String)recoveryPlan.getGlobalSettings().get(po.getUuid() + "-aToBTgtLunGroupId");
            if (VerifyUtil.isEmpty((String)aToBTgtLunGroupId)) continue;
            List<String> aToBTgtLunIdList = OracleAppUtil.getAdgBackupLunIdList(po);
            this.createDeleteMappingSubProcessors(aToBTgtLunIdList, aToBTgtLunGroupId, processors, context);
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(processors);
        } else {
            this.setChildProc(processors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void createDeleteMappingSubProcessors(List<String> lunIdList, String lunGroupId, Set<RecoveryProcessor> delMappingLunSubProcessors, RecoveryProcessorContext context) {
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        for (String lunId : lunIdList) {
            DeleteLunMappingFromLunGroupSubProcessor processor = new DeleteLunMappingFromLunGroupSubProcessor();
            processor.setLunId(lunId);
            processor.setLunGroupId(lunGroupId);
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setDeviceId(replica.getRecoveryArray());
            delMappingLunSubProcessors.add((RecoveryProcessor)processor);
        }
    }
}

