/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.host.util.DBRecoveryTools;
import com.huawei.ism.drm.oracle.recovery.process.OracleAdgConfigCleanDrillingSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.OracleAdgConfigSubProcessor;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CastUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class OracleAdgConfigProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(OracleAdgConfigProcessor.class);
    private static final long serialVersionUID = 2801500054424344420L;

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue()) {
            this.setIsEnabled(false);
            this.setIsEditable(false);
        } else {
            this.setIsEnabled(true);
            this.setIsEditable(false);
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            boolean isSuccess = this.createSubProcessors(context);
            if (VerifyUtil.isEmpty((Collection)this.getChildProc()) && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()) {
                return this.success();
            }
            if (!isSuccess) {
                LOGGER.error((Object)"Create OracleAdgConfigProcessor sub processor failed");
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        recoveryTemplate.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private boolean createSubProcessors(RecoveryProcessorContext context) {
        Set<RecoveryProcessor> configUdevSubProcessors = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() ? this.getConfigUdevProcessorsForDrilling(context) : (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() ? this.getConfigUdevProcessorsForCleanDrilling(context) : this.getConfigUdevProcessors(context));
        if (CollectionUtils.isEmpty(configUdevSubProcessors)) {
            LOGGER.info((Object)"Create config sub processors, result is empty: %s", new Object[]{String.valueOf(this.getProcType())});
            return false;
        }
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors(configUdevSubProcessors);
        } else {
            this.setChildProc(configUdevSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private Set<RecoveryProcessor> getConfigUdevProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> configUdevSubProcessors = new HashSet<RecoveryProcessor>();
        for (ProtectObject po : context.getRecoveryProtectObjects()) {
            ProtectGroup protectGroup = po.getProtectGroup();
            String hostSnS = protectGroup.getProps().getOrDefault("STAND_BY_HOSTSNS", "");
            if (VerifyUtil.isEmpty((String)hostSnS)) {
                LOGGER.error((Object)"OracleAdgConfigProcessor host sn is empty.");
                return configUdevSubProcessors;
            }
            String redoLunWwn = po.getProps().getOrDefault("REDO_LUN_WWN", "");
            String archLunWwn = po.getProps().getOrDefault("ARCHIVE_LUN_WWN", "");
            String jsonStr = po.getProps().getOrDefault("REDO_BACK_UP_LUN_IDS", "");
            JSONObject jsonObject = JSONObject.fromObject((Object)jsonStr);
            JSONObject redoBackupIds = (JSONObject)CastUtil.castTo((Object)jsonObject.get("REDO"), JSONObject.class);
            JSONObject archBackupIds = (JSONObject)CastUtil.castTo((Object)jsonObject.get("ARCHIVE"), JSONObject.class);
            Set replicaSet = ProtectGroupExtendUtil.getAllRemoteStorageReplica((ProtectGroup)protectGroup);
            String storageProviderSN = ((RemoteStorageReplica)replicaSet.stream().findFirst().get()).getStorageProviderSN();
            ArrayList<String> lunMappingList = new ArrayList<String>();
            this.configMappingBetweenRedoAndBackup(redoLunWwn, storageProviderSN, redoBackupIds, lunMappingList);
            if (!"--".equals(archLunWwn)) {
                this.configMappingBetweenRedoAndBackup(archLunWwn, storageProviderSN, archBackupIds, lunMappingList);
            }
            String dbName = (String)po.getProps().get("STANDBY_DB_NAME");
            for (String hostSn : hostSnS.split(",")) {
                OracleAdgConfigSubProcessor processor = new OracleAdgConfigSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setDbName(dbName);
                processor.setPoId(po.getUuid());
                processor.setLunMapping(String.join((CharSequence)",", lunMappingList));
                processor.setDrHostSn(hostSn);
                configUdevSubProcessors.add((RecoveryProcessor)processor);
            }
        }
        return configUdevSubProcessors;
    }

    private void configMappingBetweenRedoAndBackup(String redoLunWwn, String sn, JSONObject redoBackupIds, List<String> lunMappingList) {
        Map<String, String> wwnByGroup = OracleAppUtil.parseToWwnGroup(redoLunWwn);
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        for (Object o : redoBackupIds.keySet()) {
            String asmDgName = (String)CastUtil.castTo(o, String.class);
            JSONArray lunIdArr = (JSONArray)CastUtil.castTo((Object)redoBackupIds.get(asmDgName), JSONArray.class);
            if (!wwnByGroup.containsKey(asmDgName)) {
                LOGGER.error((Object)"Cant find backup asm group in log wwn: %s", new Object[]{asmDgName});
                throw new LegoCheckedException(1073947393L);
            }
            String wwnStr = wwnByGroup.get(asmDgName);
            if (VerifyUtil.isEmpty((String)wwnStr)) {
                LOGGER.warn((Object)"Wwn of remote asm group is empty: %s", new Object[]{asmDgName});
                continue;
            }
            String[] splitWwn = wwnStr.split(",");
            if (splitWwn.length != lunIdArr.size()) {
                LOGGER.error((Object)"Wwn size is not same to backup id: %s, %s=%s", new Object[]{asmDgName, splitWwn.length, lunIdArr.size()});
                throw new LegoCheckedException(1073947393L);
            }
            ArrayList<String> idList = new ArrayList<String>();
            for (Object object : lunIdArr) {
                idList.add(object.toString());
            }
            List lunList = storageService.getLunsByDeviceSnAndLunIds(sn, idList);
            for (int i = 0; i < splitWwn.length; ++i) {
                String wwn = splitWwn[i];
                Lun lunById = (Lun)lunList.get(i);
                lunMappingList.add(wwn + "=" + lunById.getWwn());
            }
        }
    }

    private Map<String, Lun> getBackupLunList(String sn, String backupLunIds) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List lunList = storageService.getLunsByDeviceSnAndLunIds(sn, Arrays.asList(backupLunIds.split(",")));
        HashMap<String, Lun> backupLunMap = new HashMap<String, Lun>();
        lunList.forEach(e -> backupLunMap.put(e.getLunId(), (Lun)e));
        return backupLunMap;
    }

    private Set<RecoveryProcessor> getConfigUdevProcessorsForDrilling(RecoveryProcessorContext context) {
        List allPos = DBRecoveryTools.appProtectObjectsFilter((RecoveryProcessorContext)context);
        HashSet<RecoveryProcessor> configUdevSubProcessors = new HashSet<RecoveryProcessor>();
        List<String> ips = OracleAppUtil.getIpsByRecoveryContext(context);
        if (VerifyUtil.isEmpty(ips)) {
            LOGGER.error((Object)"Not find ips by recoveryPlan.");
            return configUdevSubProcessors;
        }
        Map snapshotMap = (Map)context.getObject("TYPE_OF_CREATE_SNAPSHOT_BACKUP_COPY_PRO", Map.class);
        for (ProtectObject po : allPos) {
            this.setConfigSubProcessorByTargetHost(po, snapshotMap, ips, configUdevSubProcessors);
        }
        return configUdevSubProcessors;
    }

    private Set<RecoveryProcessor> getConfigUdevProcessorsForCleanDrilling(RecoveryProcessorContext context) {
        List configProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, OracleAdgConfigSubProcessor.class);
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor configProcessor : configProcessors) {
            if (!(configProcessor instanceof OracleAdgConfigSubProcessor)) continue;
            OracleAdgConfigSubProcessor configuredProcessor = (OracleAdgConfigSubProcessor)configProcessor;
            OracleAdgConfigCleanDrillingSubProcessor cleanDrilling = new OracleAdgConfigCleanDrillingSubProcessor();
            cleanDrilling.setParentProc((RecoveryProcessor)this);
            cleanDrilling.setProcType(this.getProcType());
            cleanDrilling.setPlanId(this.getPlanId());
            cleanDrilling.setProcessId(this.getProcessId());
            cleanDrilling.setDrHostSn(configuredProcessor.getDrHostSn());
            cleanDrilling.setInstances(configuredProcessor.getInstances());
            cleanDrilling.setInstanceName(configuredProcessor.getInstanceName());
            cleanDrilling.setDataWwn(configuredProcessor.getLunMapping());
            cleanDrilling.setPoId(configuredProcessor.getPoId());
            cleanDrilling.setDbName(configuredProcessor.getDbName());
            results.add((RecoveryProcessor)cleanDrilling);
        }
        return results;
    }

    private void setProcessorMappingWwn(Map<String, String> snapshotMap, OracleAdgConfigSubProcessor processor) {
        Set<Map.Entry<String, String>> entrySet = snapshotMap.entrySet();
        HashMap<String, String> wwnMapByDg = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entrySet) {
            String value = entry.getValue();
            String[] strArray = value.split(";");
            String newSnapshotWwn = strArray[2];
            String asmDg = strArray[4];
            String wwnBelongToDg = (String)wwnMapByDg.get(asmDg);
            if (VerifyUtil.isEmpty((String)wwnBelongToDg)) {
                wwnMapByDg.put(asmDg, newSnapshotWwn);
                continue;
            }
            wwnMapByDg.put(asmDg, wwnBelongToDg + "," + newSnapshotWwn);
        }
        ArrayList<String> dgWwnList = new ArrayList<String>();
        for (Map.Entry entry : wwnMapByDg.entrySet()) {
            String dgName = (String)entry.getKey();
            String wwnBelongToDg = (String)entry.getValue();
            String dgWwnStr = dgName + ":" + wwnBelongToDg;
            dgWwnList.add(dgWwnStr);
        }
        processor.setLunMapping(String.join((CharSequence)"@", dgWwnList));
    }

    private void setConfigSubProcessorByTargetHost(ProtectObject po, Map<String, String> snapshotMap, List<String> ips, Set<RecoveryProcessor> configUdevSubProcessors) {
        ProtectObject tempPo = OracleAppUtil.clone(po);
        for (String ip : ips) {
            tempPo.setProviderSN(ip);
            OracleAdgConfigSubProcessor processor = new OracleAdgConfigSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDbName(tempPo.getName());
            processor.setPoId(po.getUuid());
            processor.setDrHostSn(ip);
            this.setProcessorMappingWwn(snapshotMap, processor);
            configUdevSubProcessors.add((RecoveryProcessor)processor);
        }
    }
}

