/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.app.constants.DrmAppEnumDefine;
import com.huawei.ism.drm.app.sdk.model.HostDeviceStorageInfo;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.host.recovery.process.MountHostDeviceProcessor;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OracleConfigureStorageProcessor
extends MountHostDeviceProcessor {
    private static final long serialVersionUID = -5468067790586101301L;
    private static final Log LOGGER = LogFactory.getInstance(OracleConfigureStorageProcessor.class);

    protected Set<HostDeviceStorageInfo> buildHostDeviceStorageInfos(RecoveryProcessorContext context, List<ProtectObject> pos) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(pos.get(0).getProviderSN());
        if (null == drResource || !(drResource instanceof DrHostGroup) || ((DrHostGroup)drResource).getClusterType() != DrmAppEnumDefine.CLUSTER_TYPE_E.ORACLE_RAC.getValue()) {
            return super.buildHostDeviceStorageInfos(context, pos);
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String replicaId = "";
        if (null != context.getAttribute("REPLICA_ID")) {
            replicaId = (String)context.getAttribute("REPLICA_ID");
        }
        List replicaStorages = this.getAllRelicaStorageInfoByRecoveryPlan(context, recoveryPlan, replicaId);
        Set<HostDeviceStorageInfo> hostStorageInfos = this.getHostDeviceStorageSet(pos, context, replicaStorages);
        return hostStorageInfos;
    }

    private Set<HostDeviceStorageInfo> getHostDeviceStorageSet(List<ProtectObject> pos, RecoveryProcessorContext context, List<RelicaStorageInfo> replicaStorages) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        int recoveryPlanType = recoveryPlan.getPlanType();
        Set hosts = this.getRecoveryHostOrGroupId(recoveryPlan);
        ProtectGroup pg = context.getProtectGroup();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        HashSet<HostDeviceStorageInfo> hostStorageInfos = new HashSet<HostDeviceStorageInfo>();
        HashSet<String> hostStorageInfoKeySet = new HashSet<String>();
        for (DrResource host : hosts) {
            for (ProtectObject po : pos) {
                Map props = po.getProps();
                String dbVersion = (String)props.get("VERSION");
                String dbUserName = (String)props.get("USERNAME");
                PolicyTemplate template = context.getProtectGroup().getTemplate();
                int templateType = template.getType();
                for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                    HostDeviceStorageInfo hostStorageInfo = new HostDeviceStorageInfo();
                    if (this.needIgnorePoStorageInfo(poStorageInfo) || this.ignoreSecondHyperCdp(poStorageInfo, pg, replica)) {
                        LOGGER.warn((Object)("Ignore the archive log LUN, wwn:" + poStorageInfo.getLunWWN() + ", device name: " + poStorageInfo.getDeviceName() + ", mount point: " + poStorageInfo.getMountPoint()), 90160758786989L);
                        props.put("SHARE_LOG_LUN", "0");
                        continue;
                    }
                    this.setHostStorageInfoHostSN(recoveryPlanType, host, poStorageInfo, hostStorageInfo);
                    this.setHostStorageDeviceIdAndLunIdInfo(replicaStorages, recoveryPlanType, templateType, poStorageInfo, hostStorageInfo, context);
                    this.convertPoStorageInfoToHostDeviceStorageInfo(poStorageInfo, hostStorageInfo);
                    hostStorageInfo.setAppVersion(dbVersion);
                    hostStorageInfo.setAppType(Integer.valueOf(po.getPoType()));
                    hostStorageInfo.setAppUserName(dbUserName);
                    hostStorageInfo.setPoUuid(po.getUuid());
                    this.setHostStorageInfoSnapInfo(hostStorageInfo);
                    if (hostStorageInfoKeySet.contains(hostStorageInfo.generateKey())) continue;
                    hostStorageInfos.add(hostStorageInfo);
                    hostStorageInfoKeySet.add(hostStorageInfo.generateKey());
                }
            }
        }
        return hostStorageInfos;
    }

    private void convertPoStorageInfoToHostDeviceStorageInfo(ProtectObjectStorageInfo poStorageInfo, HostDeviceStorageInfo hostStorageInfo) {
        hostStorageInfo.setStorageSubType(poStorageInfo.getStorageSubType());
        hostStorageInfo.setUdevRules(poStorageInfo.getUdevFlag());
        hostStorageInfo.setMountPoint(poStorageInfo.getMountPoint());
        hostStorageInfo.setDeviceName(poStorageInfo.getDeviceName());
        hostStorageInfo.setLbaAddress(poStorageInfo.getLabAddress());
        hostStorageInfo.setStorageType(poStorageInfo.getStorageType());
        hostStorageInfo.setVgName(poStorageInfo.getVolumeGroupName());
        hostStorageInfo.setVgMapInfo(poStorageInfo.getVgMapInfo());
        hostStorageInfo.setPvName(poStorageInfo.getPvName());
        hostStorageInfo.setProDeviceName(poStorageInfo.getDeviceName());
        hostStorageInfo.setProMountPoint(poStorageInfo.getMountPoint());
        hostStorageInfo.setSrcLunWWN(poStorageInfo.getLunWWN());
    }

    private boolean needIgnorePoStorageInfo(ProtectObjectStorageInfo poStorageInfo) {
        return Integer.valueOf(1).equals(poStorageInfo.getArchiveLog()) && VerifyUtil.isEmpty((String)poStorageInfo.getAsmDiskGroupName()) && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue();
    }

    private boolean ignoreSecondHyperCdp(ProtectObjectStorageInfo poStorageInfo, ProtectGroup pg, ProtectGroupReplica replica) {
        if (VerifyUtil.isEmpty((Object)poStorageInfo)) {
            LOGGER.error((Object)"param error. poStorageInfo is null");
            return false;
        }
        if (VerifyUtil.isEmpty((Object)pg)) {
            LOGGER.error((Object)"param error. pg is null");
            return false;
        }
        if (VerifyUtil.isEmpty((Object)replica)) {
            LOGGER.error((Object)"param error. replica is null");
            return false;
        }
        String parentType = replica.getProperty("ParentType");
        Schedule currentSchedule = pg.getTemplate().getSchedules().stream().filter(schedule -> replica.getProtectLocation() == schedule.getProtectLocation() && (ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType()) || !VerifyUtil.isEmpty((String)parentType) && ScheduleProtectedType.isSameType((int)Integer.parseInt(parentType), (int)schedule.getProtectedType()))).findFirst().orElse(null);
        boolean isHyperCdp = replica.isHyperCDPReplica() || !VerifyUtil.isEmpty((String)parentType) && Integer.parseInt(parentType) == 4;
        boolean isSecondSchedule = !VerifyUtil.isEmpty((Object)currentSchedule) && currentSchedule.getScheduleMode() == 0 && currentSchedule.getPeriodType() == 5;
        return Integer.valueOf(1).equals(poStorageInfo.getArchiveLog()) && isSecondSchedule && isHyperCdp;
    }

    private void setHostStorageInfoHostSN(int recoveryPlanType, DrResource host, ProtectObjectStorageInfo poStorageInfo, HostDeviceStorageInfo hostStorageInfo) {
        if (Integer.valueOf("1").equals(poStorageInfo.getArchiveLog()) && this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            LOGGER.warn((Object)("Ignore the archive log LUN, wwn:" + poStorageInfo.getLunWWN() + ", device name: " + poStorageInfo.getDeviceName() + ", mount point: " + poStorageInfo.getMountPoint() + ", appName: " + poStorageInfo.getAppName() + " recoveryPlanType:" + recoveryPlanType), 90160758786989L);
            hostStorageInfo.setHostSN(VerifyUtil.isEmpty((String)poStorageInfo.getAppName()) ? host.getDeviceSn() : poStorageInfo.getAppName());
        } else {
            hostStorageInfo.setHostSN(host.getDeviceSn());
        }
    }
}

