/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.oracle.recovery.process.StopASMProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StopASMSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log LOGGER = LogFactory.getInstance(StopASMProcessor.class);
    private static final long serialVersionUID = 8754359743764178161L;
    private String asmInstanceName;
    private String asmUserName;
    private String asmPwd;
    private String hostSN;
    private String dbVersion;
    private Boolean isDbStoped = true;
    private Boolean isCluster = false;

    public String getAsmInstanceName() {
        return this.asmInstanceName;
    }

    public void setAsmInstanceName(String asmInstanceName) {
        this.asmInstanceName = asmInstanceName;
    }

    public String getAsmUserName() {
        return this.asmUserName;
    }

    public void setAsmUserName(String asmUserName) {
        this.asmUserName = asmUserName;
    }

    public String getAsmPwd() {
        return this.asmPwd;
    }

    public void setAsmPwd(String asmPwd) {
        this.asmPwd = asmPwd;
    }

    public String getHostSN() {
        return this.hostSN;
    }

    public void setHostSN(String hostSN) {
        this.hostSN = hostSN;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public Boolean getIsDbStoped() {
        return this.isDbStoped;
    }

    public void setIsDbStoped(Boolean isDbStoped) {
        this.isDbStoped = isDbStoped;
    }

    public Boolean getIsCluster() {
        return this.isCluster;
    }

    public void setIsCluster(Boolean isCluster) {
        this.isCluster = isCluster;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getHostNameBySN(), this.getAsmInstanceName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            LOGGER.info((Object)"asm had been stoped.", 90160758786988L);
            return true;
        }
        if (!this.getIsDbStoped().booleanValue()) {
            this.updateProcessDetail("ism.drm.recovery.stopasm.skip.error", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        if (VerifyUtil.isEmpty((String)this.hostSN) || VerifyUtil.isEmpty((String)this.asmInstanceName) || VerifyUtil.isEmpty((String)this.dbVersion)) {
            LOGGER.error((Object)("params error,hostSN:" + this.hostSN + ",asmInstanceName:" + this.asmInstanceName + ",dbVersion:" + this.dbVersion), 90160758786989L);
            this.updateProcessDetail("lego.err.1073947393", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        ProtectObject po = new ProtectObject();
        po.setProviderSN(this.hostSN);
        po.setPoType(1);
        Map props = po.getProps();
        props.put("PROVIDER_TYPE", String.valueOf(DrmEnumDefine.ProviderTypeE.HOST.getValue()));
        props.put("VERSION", this.dbVersion);
        props.put("INSTANCENAME", this.asmInstanceName);
        props.put("ASM_USERNAME", this.asmUserName);
        props.put("ASM_PASSWD", this.asmPwd);
        props.put("SERVICENAME", "SERVICENAME");
        props.put("IS_CLOSE_ASM", "1");
        props.put("AUTH_TYPE", this.isAsmAuthByOS(this.asmInstanceName, this.dbVersion, context) ? "1" : "0");
        props.put("IS_ASM", "1");
        props.put("IS_CLUSTER", this.isCluster != null && this.isCluster != false ? "1" : "0");
        Iterator pgIter = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!pgIter.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)pgIter.next();
        po.setProtectGroup(protectGroup);
        return this.executeShutdownAsm(po);
    }

    private boolean executeShutdownAsm(ProtectObject po) {
        try {
            this.shutdownAsm(po);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("stop asm(" + this.hostSN + ":" + this.asmInstanceName + ") instance error."), (Throwable)e, 90160758786989L);
            this.updateException(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("stop asm(" + this.hostSN + ":" + this.asmInstanceName + ") instance error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("lego.err.1073948169", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void updateException(LegoCheckedException e) {
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        Long errcode = e.getErrorCode();
        if (0L == e.getErrorCode() || 1073948169L == e.getErrorCode()) {
            errcode = 1073948731L;
        }
        String[] params = e.getParameters();
        if (0L == e.getErrorCode() || 1073948169L == e.getErrorCode()) {
            params = new String[]{};
        }
        this.updateProcessDetail("lego.err." + errcode, params);
    }

    protected void shutdownAsm(ProtectObject po) {
        LOGGER.debug((Object)("begin stop asm(" + this.hostSN + ":" + this.asmInstanceName + ") instance."), 90160758786988L);
        ApplicationAdapterProxy.getInstance().getAppManager(po.getPoType()).suspend(po);
        LOGGER.debug((Object)("end stop asm(" + this.hostSN + ":" + this.asmInstanceName + ") instance success."), 90160758786988L);
    }

    private String getHostNameBySN() {
        if (VerifyUtil.isEmpty((String)this.hostSN)) {
            return "UNKNOWN HOST";
        }
        DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.hostSN);
        if (null == resource) {
            return "UNKNOWN HOST";
        }
        return resource.getName();
    }

    protected String generateResultKey() {
        return RecoveryProcessResult.getStopASMProcResultKey((String)this.hostSN, (String)this.asmInstanceName);
    }

    private boolean isAsmAuthByOS(String asmInstance, String version, RecoveryProcessorContext context) {
        if (null == context) {
            return false;
        }
        ArrayList<ProtectObject> dbs = new ArrayList<ProtectObject>();
        Set protectGroups = context.getRecoveryPlan().getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            Set pos = pg.getPolist();
            if (VerifyUtil.isEmpty((Collection)pos)) continue;
            for (ProtectObject po : pos) {
                if (!asmInstance.equals(po.getProps().get("ASM_INSTANCENAME")) || !version.equals(po.getProps().get("VERSION"))) continue;
                dbs.add(po);
            }
        }
        for (ProtectObject db : dbs) {
            if (!"1".equals(db.getProps().get("AUTH_TYPE"))) continue;
            LOGGER.info((Object)("stop Asm as OS authentication, asmInstance=" + asmInstance + ",db=" + db.getName()), 90160758786988L);
            return true;
        }
        LOGGER.info((Object)("stop Asm as DB authentication, asmInstance=" + asmInstance), 90160758786988L);
        return false;
    }
}

