/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.oracle.recovery.process.StopASMProcessor;
import com.huawei.ism.drm.oracle.recovery.process.StopASMSubProcessor;
import com.huawei.ism.drm.oracle.recovery.process.StopProASMSubProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.HashSet;
import java.util.Set;

public class StopProASMProcessor
extends StopASMProcessor {
    private static final long serialVersionUID = -536126617773394536L;

    public StopProASMProcessor() {
        this.setIsNeedSave(false);
    }

    public StopProASMProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    @Override
    protected boolean createSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> stopASMSubProcessors = new HashSet<RecoveryProcessor>();
        Set allPOs = context.getProtectGroup().getPolist();
        for (ProtectObject po : allPOs) {
            String isAsm = (String)po.getProps().get("IS_ASM");
            if (!"1".equals(isAsm)) {
                LOGGER.info((Object)(po.getUuid() + ":" + po.getName() + " is not asm."), 90160758786988L);
                continue;
            }
            this.createSubProcessorByProtectObject(po, stopASMSubProcessors, context.getRecoveryPlan());
        }
        this.setChildProc(stopASMSubProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    @Override
    protected String getResourceSnForStopAsm(ProtectObject po, RecoveryPlan recoveryPlan) {
        return po.getProviderSN();
    }

    @Override
    protected StopASMSubProcessor getSubProcessor() {
        return new StopProASMSubProcessor();
    }
}

