/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.recovery.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.application.adapter.sdk.service.IApplicationManager;
import com.huawei.ism.drm.application.manager.proxy.ApplicationAdapterProxy;
import com.huawei.ism.drm.application.model.AppStorageInfo;
import com.huawei.ism.drm.application.model.ApplicationResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.oracle.recovery.util.OracleAppUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class AdgRecoveryProcessChecker
implements IRecoveryProcessChecker {
    private static final Log LOGGER = LogFactory.getInstance(AdgRecoveryProcessChecker.class);

    public void check(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        ProtectGroup pg = context.getProtectGroup();
        if (pg.getTemplate().getType() != 47 || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() != procType.getValue()) {
            return;
        }
        Set polist = pg.getPolist();
        RecoveryPlan recoveryPlan = this.getCurrentRecoveryPlan(context.getRecoveryPlan());
        try {
            for (ProtectObject po : polist) {
                int bToALunMappingSize;
                int aToBLunMappingSize;
                if (recoveryPlan.getGlobalSettings().containsKey(po.getUuid() + "_bToASrcMapping") || (aToBLunMappingSize = this.createAToBLunMapping(pg, po, recoveryPlan)) == (bToALunMappingSize = this.createBToALunMapping(pg, po, recoveryPlan))) continue;
                LOGGER.warn((Object)"Po:%s src lun mapping size:%s not match target lun mapping size:%s.", new Object[]{po.getName(), aToBLunMappingSize, bToALunMappingSize});
            }
            HibernateTemplate hibernateTemplate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            hibernateTemplate.saveOrUpdate((Object)recoveryPlan);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create lun mapping failed.");
            throw e;
        }
    }

    private RecoveryPlan getCurrentRecoveryPlan(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        return planService.getRecoveryPlan(recoveryPlan.getPlanId(), false, false);
    }

    private int createAToBLunMapping(ProtectGroup pg, ProtectObject po, RecoveryPlan recoveryPlan) {
        List<ReplicationPair> aToBPairs = OracleAppUtil.getPairList(pg, po.getUuid(), true);
        Set resourceSet = po.getUsedStorageResourceSet();
        Map<String, String> aToBSrcLunAndTgTLunMap = aToBPairs.stream().collect(Collectors.toMap(ReplicationPair::getSrcLunId, ReplicationPair::getTgtLunId));
        HashSet<String> aSrcIdSet = new HashSet<String>();
        HashSet<String> aTgtIdSet = new HashSet<String>();
        LOGGER.info((Object)"Pair list size:%s, resource set size", new Object[]{aToBPairs.size(), resourceSet.size()});
        for (ProtectObjectStorageInfo info : resourceSet) {
            if (!aToBSrcLunAndTgTLunMap.containsKey(info.getResourceId())) continue;
            String aDiskNumberLunId = info.getAsmDiskGroupName() + ":" + info.getAsmDiskNumber() + ":" + info.getResourceId();
            aSrcIdSet.add(aDiskNumberLunId);
            String bDiskNumberLunId = info.getAsmDiskGroupName() + ":" + info.getAsmDiskNumber() + ":" + aToBSrcLunAndTgTLunMap.get(info.getResourceId());
            aTgtIdSet.add(bDiskNumberLunId);
        }
        JSONArray array = new JSONArray(aSrcIdSet);
        JSONArray array2 = new JSONArray(aTgtIdSet);
        recoveryPlan.getGlobalSettings().put(po.getUuid() + "_aToBSrcMapping", array.toString());
        recoveryPlan.getGlobalSettings().put(po.getUuid() + "_aToBTgtMapping", array2.toString());
        LOGGER.info((Object)"Po:%s aToBSrcMapping:%s", new Object[]{po.getName(), array.toString()});
        LOGGER.info((Object)"Po:%s aToBTgtMapping:%s", new Object[]{po.getName(), array2.toString()});
        return aSrcIdSet.size();
    }

    private int createBToALunMapping(ProtectGroup pg, ProtectObject po, RecoveryPlan recoveryPlan) {
        IApplicationManager applicationManager = ApplicationAdapterProxy.getInstance().getAppManager(pg.getPoType());
        List appStandbyResources = applicationManager.getAppStandbyResource(po);
        if (VerifyUtil.isEmpty((Collection)appStandbyResources)) {
            LOGGER.error((Object)"Can not get standby resources.");
            throw new LegoCheckedException(1073947794L, new String[]{po.getName()});
        }
        ApplicationResource resource = (ApplicationResource)appStandbyResources.get(0);
        Set appStorageInfos = resource.getAppStorageInfos();
        HashSet<String> bSrcIdSet = new HashSet<String>();
        HashSet<String> bTgtIdSet = new HashSet<String>();
        List<ReplicationPair> bToAPairs = OracleAppUtil.getPairList(pg, po.getUuid(), false);
        Map<String, String> bToASrcLunAndTgTLunMap = bToAPairs.stream().collect(Collectors.toMap(ReplicationPair::getSrcLunId, ReplicationPair::getTgtLunId));
        LOGGER.info((Object)"Pair list size:%s, app info set size", new Object[]{bToAPairs.size(), appStorageInfos.size()});
        for (AppStorageInfo info : appStorageInfos) {
            if (!bToASrcLunAndTgTLunMap.containsKey(info.getResourceId())) continue;
            String aDiskNumberLunId = info.getAsmDg() + ":" + info.getAsmDiskNumber() + ":" + info.getResourceId();
            bSrcIdSet.add(aDiskNumberLunId);
            String bDiskNumberLunId = info.getAsmDg() + ":" + info.getAsmDiskNumber() + ":" + bToASrcLunAndTgTLunMap.get(info.getResourceId());
            bTgtIdSet.add(bDiskNumberLunId);
        }
        JSONArray array = new JSONArray(bSrcIdSet);
        JSONArray array2 = new JSONArray(bTgtIdSet);
        recoveryPlan.getGlobalSettings().put(po.getUuid() + "_bToASrcMapping", array.toString());
        recoveryPlan.getGlobalSettings().put(po.getUuid() + "_bToATgtMapping", array2.toString());
        LOGGER.info((Object)"Po:%s bToASrcMapping:%s", new Object[]{po.getName(), array.toString()});
        LOGGER.info((Object)"Po:%s bToATgtMapping:%s", new Object[]{po.getName(), array2.toString()});
        return bSrcIdSet.size();
    }

    public String getName() {
        return this.getClass().getName();
    }
}

