/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.oracle.topology;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.host.sdk.model.DrHost;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.host.sdk.service.IHostService;
import com.huawei.ism.drm.host.topology.element.HostElement;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractGlobalTopoBuilder;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.Group;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:Global-Topology-47")
public class OracleAllFlashGlobalTOPOBuilder
extends AbstractGlobalTopoBuilder {
    private static final Log LOGGER = LogFactory.getInstance(OracleAllFlashGlobalTOPOBuilder.class);
    private static final int LOCAL_GROUP_OUTLINE_WIDTH = 1;
    private static final String DRM_PROTECTOBJ_ORACLE_TYPE = "/theme/recoverydirector/images/topo/host_oracle_icon.png";
    private IHostService hostService = null;

    public IHostService getHostService() {
        return this.hostService;
    }

    public void setHostService(IHostService hostService) {
        this.hostService = hostService;
    }

    public void buildTopo(TopoBaseContext context) {
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(context.getProtectGroup().getUuid(), false);
        int poType = protectGroup.getPoType();
        if (poType != 1 || protectGroup.getTemplate().getType() != 47) {
            return;
        }
        String hostSN = protectGroup.getPoProviderSN();
        DrResource drResource = this.getDrResourceInContext(context, hostSN);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            return;
        }
        ElementBox layout = (ElementBox)context.find((Object)"layout");
        ElementBox box = context.getElementBox();
        String srcSN = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getProductArray();
        this.buildHostAndStorageTopo(context, layout, box, drResource, srcSN);
        String siteBHostSnsString = (String)protectGroup.getProps().get("STAND_BY_HOSTSNS");
        List<String> siteBHostSns = Arrays.asList(siteBHostSnsString.split(","));
        String trgSN = ((ProtectGroupReplica)protectGroup.getReplicaList().iterator().next()).getRecoveryArray();
        siteBHostSns.forEach(siteBHostSN -> {
            DrResource drSiteBResource = this.getDrResourceInContext(context, (String)siteBHostSN);
            if (VerifyUtil.isEmpty((Object)drResource)) {
                return;
            }
            this.buildHostAndStorageTopo(context, layout, box, drSiteBResource, trgSN);
        });
        Node poStorageNode = null;
        Node reStorageNode = null;
        if (box.getElementByID((Object)(srcSN + ":storage")) instanceof Node) {
            poStorageNode = (Node)box.getElementByID((Object)(srcSN + ":storage"));
        }
        if (box.getElementByID((Object)(trgSN + ":storage")) instanceof Node) {
            reStorageNode = (Node)box.getElementByID((Object)(trgSN + ":storage"));
        }
        if (VerifyUtil.isEmpty((Object)poStorageNode) || VerifyUtil.isEmpty(reStorageNode)) {
            LOGGER.error((Object)"Failed to build storage link.");
            throw new LegoCheckedException(1073947394L);
        }
        this.linkStorage(context, poStorageNode, reStorageNode, srcSN, trgSN);
        this.linkStorage(context, reStorageNode, poStorageNode, trgSN, srcSN);
    }

    private void buildHostAndStorageTopo(TopoBaseContext context, ElementBox layout, ElementBox box, DrResource drResource, String sn) {
        DrStorage drStorage = this.changeToDrstorage(this.getDrResource(sn));
        if (drResource instanceof DrHostGroup) {
            Set drHosts = drResource.getChildResources();
            for (DrResource eachHost : drHosts) {
                this.buildDRHostTOPO(context, layout, box, eachHost, drStorage);
            }
        }
        if (drResource instanceof DrHost) {
            this.buildDRHostTOPO(context, layout, box, drResource, drStorage);
        }
    }

    private void buildDRHostTOPO(TopoBaseContext context, ElementBox layout, ElementBox box, DrResource drResource, DrStorage drStorage) {
        String id = drResource.getSiteId();
        Site site = this.getSiteInContext(context, id);
        Group group = this.getOrCreateGroup(box, site, layout);
        Node hostNode = this.createHostTopo(context, drResource, site, group, layout);
        context.getVmEsxNode().add(hostNode);
        String storageNodeId = drStorage.getDeviceSn() + ":storage";
        if (box.getElementByID((Object)storageNodeId) == null) {
            box.getDatas();
            Node storageNode = this.createStorageNode(drStorage, site, false);
            this.initNodeLocation(storageNode, (Node)group, layout);
            group.addChild((IData)storageNode);
            this.addIdtoList(context.getStorageNodeIds(), storageNodeId);
            TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)storageNode);
            this.createHostStorageLink(context, hostNode, storageNode, true);
        } else {
            Node storageNode = null;
            if (box.getElementByID((Object)storageNodeId) instanceof Node) {
                storageNode = (Node)box.getElementByID((Object)storageNodeId);
            }
            this.createHostStorageLink(context, hostNode, storageNode, true);
        }
    }

    protected Node createStorageNode(DrStorage storage, Site site, boolean isVis) {
        Node storageNode = new Node((Object)(storage.getDeviceSn() + ":storage"));
        storageNode.setStyle("label.color", 35020);
        if (isVis) {
            this.setVisImageByStatus(storageNode, NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        } else {
            StorageElement.setImageByStatus((Node)storageNode, (Integer)NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        }
        storageNode.setStyle("label.bold", false);
        storageNode.setClient("moID", (Object)storage.getDeviceSn());
        if (isVis) {
            storageNode.setClient("isHostOrStorage", (Object)"isvis");
        } else {
            storageNode.setClient("isHostOrStorage", (Object)"isstorage");
        }
        storageNode.setClient("imageWidth", 48.0);
        storageNode.setClient("imageHeight", 60.0);
        storageNode.setName(TopoServiceUtil.getNodeShowName((String)storage.getName()));
        storageNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)storage));
        storageNode.setStyle("select.alpha", 1.0);
        storageNode.setStyle("select.style", (Object)"none");
        return storageNode;
    }

    private DrStorage changeToDrstorage(DrResource drResource) {
        DrStorage drStorage = null;
        if (drResource instanceof DrStorage) {
            drStorage = (DrStorage)drResource;
        }
        return drStorage;
    }

    private Node createHostTopo(TopoBaseContext context, DrResource drHost, Site site, Group group, ElementBox layout) {
        Node hostNode = null;
        if (drHost instanceof DrHost) {
            hostNode = this.createHostNode(context, (DrHost)drHost, site, group, layout);
            this.addProtectGroupIDToElement((Element)hostNode, context.getProtectGroup().getUuid());
        }
        if (drHost instanceof DrHostGroup) {
            hostNode = this.createGroupTopoForGlobalTopo(context, (DrHostGroup)drHost, site, group, layout);
            Set drHosts = drHost.getChildResources();
            for (DrResource eachHost : drHosts) {
                if (!(hostNode instanceof Group)) continue;
                this.createHostTopo(context, eachHost, site, (Group)hostNode, layout);
            }
        }
        return hostNode;
    }

    private Node createHostNode(TopoBaseContext context, DrHost hostInfo, Site site, Group group, ElementBox layout) {
        String nodeId = hostInfo.getDeviceSn() + "---" + site.getSiteId();
        Node hostNode = null;
        if (context.getElementBox().getElementByID((Object)nodeId) instanceof Node) {
            hostNode = (Node)context.getElementBox().getElementByID((Object)nodeId);
        }
        if (hostNode != null) {
            return hostNode;
        }
        hostNode = this.drawNode(hostInfo, site, nodeId);
        this.setHostNodeAppInfo(hostInfo, site, hostNode);
        if (group != null) {
            this.initNodeLocation(hostNode, (Node)group, layout);
            group.addChild((IData)hostNode);
        }
        this.addIdtoList(context.getHostNodeIds(), nodeId);
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)hostNode);
        return hostNode;
    }

    private void setHostNodeAppInfo(DrHost hostInfo, Site site, Node hostNode) {
        List<Integer> appTypes = this.getHostAppTypes(hostInfo.getDeviceSn(), site);
        int len = appTypes.size();
        if (len > 0) {
            ArrayList<String> nameList = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                String appPic = DRM_PROTECTOBJ_ORACLE_TYPE;
                if (VerifyUtil.isEmpty((String)appPic) || nameList.contains(appPic)) continue;
                nameList.add(appPic);
            }
            if (!VerifyUtil.isEmpty(nameList)) {
                int nameLen = nameList.size();
                String[] nameArray = new String[nameList.size()];
                for (int j = 0; j < nameLen; ++j) {
                    nameArray[j] = (String)nameList.get(j);
                }
                hostNode.setStyle("icons.names", (Object)nameArray);
                hostNode.setStyle("icons.position", (Object)"top.top");
                hostNode.setStyle("icons.xgap", 5.0);
                hostNode.setStyle("icons.ygap", -20.0);
            }
        }
    }

    private Node drawNode(DrStorage drStorage, Site site) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        StorageElement drStorageNode = new StorageElement(drStorage);
        drStorageNode.setStyle("label.bold", false);
        drStorageNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        drStorageNode.setStyle("label.color", 35020);
        HostElement.setImageByStatus((Node)drStorageNode, (String)drStorage.getStatus());
        if (site.getSiteType() == 0) {
            drStorageNode.setClient("isHostOrStorage", (Object)"ishost");
            drStorageNode.setClient("topoHostName", (Object)("<![CDATA[" + drStorage.getName() + "]]>"));
        }
        drStorageNode.setClient("imageWidth", 48.0);
        drStorageNode.setClient("imageHeight", 60.0);
        drStorageNode.setName(TopoServiceUtil.getNodeShowName((String)drStorage.getName()));
        drStorageNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)drStorage));
        drStorageNode.setStyle("select.alpha", 1.0);
        drStorageNode.setStyle("select.style", (Object)"none");
        drStorageNode.setStyle("icons.position", (Object)"top.top");
        drStorageNode.setStyle("icons.xgap", 5.0);
        drStorageNode.setStyle("icons.ygap", -20.0);
        return drStorageNode;
    }

    private Node drawNode(DrHost hostInfo, Site site, String nodeId) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node hostNode = new Node((Object)nodeId);
        hostNode.setStyle("label.bold", false);
        hostNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostNode.setStyle("label.color", 35020);
        HostElement.setImageByStatus((Node)hostNode, (String)hostInfo.getStatus());
        if (site.getSiteType() == 0) {
            hostNode.setClient("isHostOrStorage", (Object)"ishost");
            hostNode.setClient("topoHostName", (Object)("<![CDATA[" + hostInfo.getName() + "]]>"));
        }
        hostNode.setClient("imageWidth", 48.0);
        hostNode.setClient("imageHeight", 60.0);
        hostNode.setName(TopoServiceUtil.getNodeShowName((String)hostInfo.getName()));
        hostNode.setToolTip(HostElement.createHostToolTip((DrHost)hostInfo));
        DrResource parent = hostInfo.getParentDrResource();
        if (parent instanceof DrHostGroup) {
            hostNode.setClient("clusterSn", (Object)parent.getDeviceSn());
            this.setNodeExtName(hostNode, hostInfo.getName(), parent.getName(), "ism.drm.topo.hypermetro.hostgroup");
        }
        hostNode.setStyle("select.alpha", 1.0);
        hostNode.setStyle("select.style", (Object)"none");
        return hostNode;
    }

    private List<Integer> getHostAppTypes(String hostSn, Site site) {
        return this.hostService.getHostAppTypes(hostSn);
    }

    private Group createGroupTopoForGlobalTopo(TopoBaseContext context, DrHostGroup hostGroupInfo, Site site, Group group, ElementBox layout) {
        String groupId = hostGroupInfo.getDeviceSn() + "---" + site.getSiteId();
        Group hostGroup = null;
        if (context.getElementBox().getElementByID((Object)groupId) instanceof Group) {
            hostGroup = (Group)context.getElementBox().getElementByID((Object)groupId);
        }
        if (hostGroup != null) {
            return hostGroup;
        }
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        hostGroup = new Group((Object)groupId);
        hostGroup.setStyle("label.bold", false);
        hostGroup.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        hostGroup.setClient("imageWidth", 48.0);
        hostGroup.setClient("imageHeight", 60.0);
        hostGroup.setName(TopoServiceUtil.getNodeShowName((String)hostGroupInfo.getName()));
        hostGroup.setToolTip(this.createHostGroupToolTip(hostGroupInfo));
        hostGroup.setImage("/theme/recoverydirector/images/topo/hostgroup.png");
        hostGroup.setStyle("group.outline.color", (Object)"0xDCDCDC");
        hostGroup.setStyle("group.outline.width", 1);
        hostGroup.setStyle("group.fill.color", (Object)"0xFCFCFC");
        hostGroup.setStyle("group.shape", (Object)"roundrect");
        hostGroup.setStyle("vector.roundrect.radius", 7);
        hostGroup.setExpanded(true);
        hostGroup.setStyle("select.alpha", 1.0);
        hostGroup.setStyle("select.style", (Object)"none");
        hostGroup.setStyle("label.color", (Object)"0x222222");
        if (group != null && hostGroup instanceof Group) {
            this.initGroupLocation(hostGroup, (Node)group, layout);
            group.addChild((IData)hostGroup);
        }
        TopoServiceUtil.addElementToBox((ElementBox)context.getElementBox(), (IData)hostGroup);
        return hostGroup;
    }

    private String createHostGroupToolTip(DrHostGroup hostGroupInfo) {
        return HostElement.createHostTooltip((String)hostGroupInfo.getIpAddress(), (String)hostGroupInfo.getName(), (String)hostGroupInfo.getOsType(), (String)"0");
    }

    private void linkStorage(TopoBaseContext context, Node poStorageNode, Node reStorageNode, String productArraySn, String recoverArraySn) {
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)poStorageNode, (Node)reStorageNode);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (link == null) {
            this.createStorageLink(context, productArraySn, poStorageNode, recoverArraySn, reStorageNode);
        } else {
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
        }
    }

    private void createStorageLink(TopoBaseContext context, String productArraySn, Node poStorageNode, String recoverArraySn, Node reStorageNode) {
        if (!productArraySn.equals(recoverArraySn)) {
            ProtectGroup protectGroup = context.getProtectGroup();
            String sLinkId = "storagelink-" + protectGroup.getUuid() + ":" + productArraySn + "->" + recoverArraySn;
            Link link = new Link((Object)sLinkId, poStorageNode, reStorageNode);
            link.setClient("linkToXOffset", 10.0);
            link.setClient("devSN", (Object)productArraySn);
            link.setClient("trgSN", (Object)recoverArraySn);
            this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", true);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            StringBuilder storageLinkTips = new StringBuilder();
            ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
            storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.status"));
            storageLinkTips.append(" ");
            int linkStatus = this.getStorageLinkStatus(context, productArraySn, recoverArraySn);
            if (linkStatus == 3 || linkStatus == 4) {
                link.setStyle("link.color", (Object)"0x1dcfef");
                link.setStyle("arrow.to.color", (Object)"0x1dcfef");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
            } else if (linkStatus == 2 || linkStatus == 1) {
                link.setStyle("link.color", (Object)"0xfc4133");
                link.setStyle("arrow.to.color", (Object)"0xfc4133");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.allbreak"));
            } else {
                link.setStyle("link.color", (Object)"0x31bd16");
                link.setStyle("arrow.to.color", (Object)"0x31bd16");
                storageLinkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.normal"));
            }
            link.setToolTip(storageLinkTips.toString());
            link.setStyle("select.alpha", 1.0);
            link.setStyle("select.style", (Object)"none");
            ElementBox topoBox = context.getElementBox();
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
    }
}

