/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.ResourcePoolAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.discovery.util.VsphereEnumParse;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereResourcePool;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedEntityStatus;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ComputeResourceAction {
    private final Log logger = LogFactory.getInstance(ComputeResourceAction.class);

    public List<VsphereComputeResource> queryAllComputeResourceAndResourcePool(VmwareConnection conn) {
        if (null == conn) {
            throw new LegoCheckedException(1073947393L);
        }
        List<VsphereComputeResource> result = this.queryDataCenterAndComputeResource(conn.getServiceContent().getRootFolder(), conn);
        return result;
    }

    public List<VsphereComputeResource> queryComputeResourceByContainer(ManagedObjectReference containerMor, VmwareConnection conn, String dataCenterName, boolean withResourcePool) {
        ArrayList<String> crList = new ArrayList<String>();
        crList.add("ClusterComputeResource");
        crList.add("ComputeResource");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, crList, true);
        ObjectSpec oSpec = PropertyCollectorUtil.creatObjectSpec(containerView, true, null);
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("summary.overallStatus");
        PropertySpec ccrSpec = PropertyCollectorUtil.createPropertySpec("ClusterComputeResource", pathSet);
        PropertySpec crSpec = PropertyCollectorUtil.createPropertySpec("ComputeResource", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(ccrSpec);
        propSet.add(crSpec);
        List<PropertyFilterSpec> fSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, fSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsphereComputeResource> result = new ArrayList<VsphereComputeResource>();
        if (VerifyUtil.isEmpty(queryResult)) {
            this.logger.info((Object)"Query ComputeResource from dataCenter(%s) is empty.", new Object[]{dataCenterName});
            return result;
        }
        for (ObjectContent oc : queryResult) {
            VsphereComputeResource cr = new VsphereComputeResource();
            this.parseComputeResource(cr, oc, conn.getVcenterUuid());
            cr.setDataCenterName(dataCenterName);
            result.add(cr);
            List<VsphereResourcePool> rps = null;
            if (withResourcePool) {
                ResourcePoolAction rpAction = new ResourcePoolAction();
                rps = rpAction.queryAllResourcePoolByContainer(oc.getObj(), conn);
            }
            if (null == rps) continue;
            for (VsphereResourcePool rp : rps) {
                rp.setParentMo((ManagedObject)cr);
            }
            HashSet<VsphereResourcePool> rpSet = new HashSet<VsphereResourcePool>();
            rpSet.addAll(rps);
            cr.setChildMos(rpSet);
        }
        return result;
    }

    public List<VsphereComputeResource> queryDataCenterAndComputeResource(ManagedObjectReference containerMor, VmwareConnection conn) {
        ArrayList<String> crList = new ArrayList<String>();
        crList.add("Datacenter");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, crList, true);
        ObjectSpec oSpec = PropertyCollectorUtil.creatObjectSpec(containerView, true, null);
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        PropertySpec ccrSpec = PropertyCollectorUtil.createPropertySpec("Datacenter", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(ccrSpec);
        List<PropertyFilterSpec> filterSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, filterSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsphereComputeResource> result = new ArrayList<VsphereComputeResource>();
        for (ObjectContent oc : queryResult) {
            String dataCenterName = PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class);
            result.addAll(this.queryComputeResourceByContainer(oc.getObj(), conn, dataCenterName, true));
        }
        return result;
    }

    private void parseComputeResource(VsphereComputeResource cr, ObjectContent oc, String vCenterUuid) {
        cr.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
        if ("ClusterComputeResource".equals(oc.getObj().getType())) {
            cr.setIsCluster(Boolean.valueOf(true));
        }
        cr.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
        ManagedEntityStatus overallStatus = PropertyCollectorUtil.getPropertyByPath(oc, "summary.overallStatus", ManagedEntityStatus.class);
        DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E status = VsphereEnumParse.parseManagedEntityStatus(overallStatus);
        cr.setHealthStatus(Integer.valueOf(status.getValue()));
    }
}

