/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.lego.cbb.network.sdk.model.IPv6Address;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.FileTransferInformation;
import com.huawei.vmware.vim25.GuestAuthentication;
import com.huawei.vmware.vim25.GuestListFileInfo;
import com.huawei.vmware.vim25.GuestProcessInfo;
import com.huawei.vmware.vim25.GuestProgramSpec;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.NamePasswordAuthentication;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VMGuestAction {
    private static final Log LOG = LogFactory.getInstance(VMGuestAction.class);
    private static final String WINDOWS_CMD = "cmd.exe";
    private static final int THOUNDS_NUM = 1000;
    private static final String REGEDIT_PARAM = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces\\";
    private static final String REGEDIT_IPV6DNS_PARAM = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\services\\Tcpip6\\Parameters\\Interfaces\\";
    private static final String[] REGEDIT_IPV6INFO_PARAM = new String[]{"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Nsi\\{eb004a00-9b1a-11d4-9123-0050047759bc}\\", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Nsi\\{eb004a01-9b1a-11d4-9123-0050047759bc}\\", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Nsi\\{eb004a03-9b1a-11d4-9123-0050047759bc}\\", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Nsi\\{eb004a11-9b1a-11d4-9123-0050047759bc}\\", "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Nsi\\{eb004a1c-9b1a-11d4-9123-0050047759bc}\\"};
    private static final String IPPATH = "10";
    private static final String GWPATH = "16";
    private static final String UTF16LE = "UTF-16LE";
    private static final String ASCII = "ASCII";
    private static final String UNICODE = "Unicode";
    private static final String REG_QUERY = "REG QUERY ";
    private static final String NICCONFIG_CMD = "wmic nicconfig get MACAddress,SettingID";
    private static final String GET_NETCONNECTION_CMD = "wmic nic get NetConnectionID, MACAddress /value";

    public boolean configWindowsVMIp(String vcenterUuid, String vmMoId, String username, String password, Map<String, VCenterNicIpInfo> nicIpInfo) {
        LOG.debug((Object)"Config ip of windows vm: vCenterUuid[%s], vmMoId[%s], userName[%s].", new Object[]{vcenterUuid, vmMoId, username});
        if (VerifyUtil.isEmpty(nicIpInfo) || VerifyUtil.isEmpty((String)vmMoId) || VerifyUtil.isEmpty((String)username) || VerifyUtil.isEmpty((String)password)) {
            LOG.error((Object)"Config ip of windows vm, but parameter is emtpy: vCenterUuid[%s], vmMoId[%s], userName[%s].", new Object[]{vcenterUuid, vmMoId, username});
            return false;
        }
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
        NamePasswordAuthentication auth = new NamePasswordAuthentication();
        auth.setUsername(username);
        auth.setPassword(password);
        auth.setInteractiveSession(false);
        return this.configWindowsIp(vmMoId, nicIpInfo, conn, auth, vmMor);
    }

    /*
     * Exception decompiling
     */
    private boolean configWindowsIp(String vmMoId, Map<String, VCenterNicIpInfo> nicIpInfo, VmwareConnection conn, NamePasswordAuthentication auth, ManagedObjectReference vmMor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkNicIp(Map<String, VCenterNicIpInfo> nicIpInfo, boolean ret, Map<String, VCenterNicIpInfo> curIpInfo) {
        for (Map.Entry<String, VCenterNicIpInfo> entry : curIpInfo.entrySet()) {
            String key = entry.getKey();
            VCenterNicIpInfo cfgIp = nicIpInfo.get(key);
            if (cfgIp == null) {
                ret = false;
                break;
            }
            VCenterNicIpInfo curIp = entry.getValue();
            if (!cfgIp.isEquals(curIp)) {
                ret = false;
                break;
            }
            ret = true;
        }
        return ret;
    }

    private void getIpv6Info(VCenterNicIpInfo networkInfo, VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, ASCII);
        try {
            for (String line : fileInfo.split(";")) {
                String trimLine = line.trim();
                if (trimLine.isEmpty()) continue;
                String[] datas = trimLine.split(" ");
                IPv6Address ipv6 = new IPv6Address();
                for (String data : datas) {
                    if (VerifyUtil.isEmpty((String)data)) continue;
                    if (data.length() == 48) {
                        String ip = data.substring(16, 48);
                        ipv6.setAddress(this.convertIpv6(ip));
                        continue;
                    }
                    if (data.length() != 112 && data.length() != 96) continue;
                    String prefix = Integer.parseInt(data.substring(32, 34), 16) + "";
                    ipv6.setPrefix(prefix);
                }
                if (!Ipv6AddressUtil.isIPv6Address((String)ipv6.getAddress())) continue;
                String reg = "^([1-9]?\\d|1[01]\\d|12[0-8])$";
                String prefix = ipv6.getPrefix();
                prefix = Normalizer.normalize(prefix, Normalizer.Form.NFKC);
                Matcher matcher = Pattern.compile(reg).matcher(prefix);
                if (!matcher.matches()) continue;
                networkInfo.getIpv6List().add(ipv6);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetNetworkInfoFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
    }

    private String convertIpv6(String stringForIpv6) {
        if ((stringForIpv6 = stringForIpv6.trim()).contains(":")) {
            return stringForIpv6;
        }
        StringBuilder ipv6 = new StringBuilder();
        if (stringForIpv6.length() != 32) {
            throw new LegoCheckedException(-1L);
        }
        ipv6.append(stringForIpv6, 0, 4);
        for (int i = 1; i < 8; ++i) {
            ipv6.append(":").append(stringForIpv6, i * 4, i * 4 + 4);
        }
        return ipv6.toString();
    }

    private void getIpv6GW(VCenterNicIpInfo networkInfo, VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, ASCII);
        try {
            for (String line : fileInfo.split(";")) {
                String[] datas;
                String trimLine = line.trim();
                if (trimLine.isEmpty()) continue;
                for (String data : datas = trimLine.split(" ")) {
                    if (VerifyUtil.isEmpty((String)data) || data.length() != 144) continue;
                    if (VerifyUtil.isEmpty((String)networkInfo.getGateway6())) {
                        networkInfo.setGateway6(this.convertIpv6(data.substring(data.length() - 32)));
                        continue;
                    }
                    networkInfo.setGateway6(networkInfo.getGateway6() + "," + this.convertIpv6(data.substring(data.length() - 32)));
                }
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetNetworkInfoFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
    }

    private void getIpv6DNS(VCenterNicIpInfo networkInfo, VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, ASCII);
        try {
            for (String line : fileInfo.split(";")) {
                int dataIndex;
                String ipv6Info;
                String trimLine = line.trim();
                if (trimLine.isEmpty() || !trimLine.contains("NameServer") || (ipv6Info = trimLine.substring(dataIndex = trimLine.lastIndexOf(" "))).contains("REG_SZ")) continue;
                String[] dnses = ipv6Info.split(",");
                if (dnses.length >= 1) {
                    networkInfo.setPreferredDns6(this.convertIpv6(dnses[0]));
                }
                if (dnses.length >= 2) {
                    networkInfo.setAlternateDns6(this.convertIpv6(dnses[1]));
                }
                return;
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetNetworkInfoFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
    }

    private String createTmpFileOnVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, NamePasswordAuthentication auth) {
        String filePath = "";
        try {
            List files;
            filePath = conn.getVimPort().createTemporaryFileInGuest(fileManagerRef, vmMor, (GuestAuthentication)auth, "", "", "");
            long startMili = System.currentTimeMillis();
            long count = 0L;
            do {
                GuestListFileInfo info = conn.getVimPort().listFilesInGuest(fileManagerRef, vmMor, (GuestAuthentication)auth, filePath, Integer.valueOf(0), Integer.valueOf(1), null);
                files = info.getFiles();
                Thread.sleep(10000L * count);
            } while (files.size() != 1 && ++count < 5L);
            long endMili = System.currentTimeMillis();
            LOG.debug((Object)"Check file create complete. count:[%s], fileSize:[%s], executeTime:[%s]", new Object[]{String.valueOf(count), files.size(), endMili - startMili});
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("CreateTmpFileOnVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
        return filePath;
    }

    private void executeCmdOnVm(VmwareConnection conn, ManagedObjectReference processManagerRef, ManagedObjectReference vmMor, String cmd, NamePasswordAuthentication auth) {
        this.executeCmdOnVm(conn, processManagerRef, vmMor, cmd, auth, null);
    }

    private void executeCmdOnVm(VmwareConnection conn, ManagedObjectReference processManagerRef, ManagedObjectReference vmMor, String cmd, NamePasswordAuthentication auth, String targetFile) {
        if (VerifyUtil.isEmpty((Object)vmMor)) {
            LOG.error((Object)"Vm obj is null");
            throw new LegoCheckedException(1073947393L);
        }
        GuestProgramSpec spec = new GuestProgramSpec();
        spec.setProgramPath(WINDOWS_CMD);
        StringBuilder command = new StringBuilder();
        command.append("/c ");
        command.append(cmd);
        if (!VerifyUtil.isEmpty((String)targetFile)) {
            command.append(" >");
            command.append(targetFile);
        }
        spec.setArguments(command.toString());
        try {
            Integer exitCode;
            long count = 0L;
            do {
                Thread.sleep(10000L * count);
                LOG.debug((Object)"Start execute cmd on vm. cmd:[%s], vmId:[%s], targetFile:[%s], count:[%s]", new Object[]{command.toString(), vmMor.getValue(), targetFile, count});
                long pid = conn.getVimPort().startProgramInGuest(processManagerRef, vmMor, (GuestAuthentication)auth, spec);
                exitCode = this.waitProcFinished(pid, processManagerRef, conn, vmMor, auth);
                LOG.debug((Object)"End execute cmd on vm. cmd:[%s], vmId:[%s], exitCode:[%s], pid:[%s], count:[%s]", new Object[]{command.toString(), vmMor.getValue(), exitCode, pid, count});
            } while (exitCode != 0 && exitCode != 1 && ++count < 8L);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("ExecuteNetshCmdOnVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
    }

    private String getNetshCmd(Map<String, VCenterNicIpInfo> macMap, Map<String, VCenterNicIpInfo> adaptersMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, VCenterNicIpInfo> entry : adaptersMap.entrySet()) {
            String macAddress = entry.getKey().replaceAll("-", ":").toUpperCase(Locale.ENGLISH);
            VCenterNicIpInfo curInfo = macMap.get(macAddress);
            if (curInfo == null) continue;
            VCenterNicIpInfo ipInfo = entry.getValue();
            if (ipInfo.isOpenIp4()) {
                sb.append(this.getIpv4NetshCmd(ipInfo, curInfo.getNicName()));
            }
            if (!ipInfo.isOpenIp6()) continue;
            sb.append(this.getIpv6NetshCmd(ipInfo, curInfo.getNicName()));
        }
        String netshCmd = sb.toString();
        if (!VerifyUtil.isEmpty((String)netshCmd)) {
            netshCmd = netshCmd.substring(0, netshCmd.length() - 3);
        }
        return netshCmd;
    }

    private String getIpv6NetshCmd(VCenterNicIpInfo ipInfo, String networkName) {
        StringBuilder sb = new StringBuilder();
        if (!ipInfo.isDhcpEnabled6()) {
            for (IPv6Address ipv6 : ipInfo.getIpv6List()) {
                sb.append("netsh interface ipv6 set address \"").append(networkName).append("\" ").append(ipv6.getAddress()).append("/").append(ipv6.getPrefix()).append(" store=persistent & ");
            }
            sb.append(" netsh interface ipv6 add route ::/0 \"").append(networkName).append("\" ").append(ipInfo.getGateway6()).append(" store=persistent & ");
        } else {
            sb.append("netsh interface ipv6 set address \"").append(networkName).append("\" dhcp &");
        }
        if (ipInfo.isAutoDns6()) {
            sb.append("netsh interface ipv6 set dns \"").append(networkName).append("\" dhcp & ");
        } else {
            if (!VerifyUtil.isEmpty((String)ipInfo.getPreferredDns6())) {
                sb.append("netsh interface ipv6 set dns \"").append(networkName).append("\" static ").append(" ").append(ipInfo.getPreferredDns6()).append(" &   ");
            }
            if (!VerifyUtil.isEmpty((String)ipInfo.getAlternateDns6())) {
                sb.append("netsh interface ipv6 add dns \"").append(networkName).append("\" ").append(ipInfo.getAlternateDns6()).append(" 2 & ");
            }
        }
        return sb.toString();
    }

    private String getIpv4NetshCmd(VCenterNicIpInfo ipInfo, String networkName) {
        StringBuilder sb = new StringBuilder();
        if (!ipInfo.isDhcpEnabled4()) {
            sb.append("netsh interface ip set address \"").append(networkName).append("\" static ").append(ipInfo.getIp()).append(" ").append(ipInfo.getNetmask()).append(" ").append(ipInfo.getGateway()).append(" & ");
        } else {
            sb.append("netsh interface ip set address \"").append(networkName).append("\" dhcp &");
        }
        if (ipInfo.isAutoDns4()) {
            sb.append("netsh interface ip set dns \"").append(networkName).append("\" dhcp & ");
        } else {
            if (!VerifyUtil.isEmpty((String)ipInfo.getPreferredDns())) {
                sb.append("netsh interface ip set dns \"").append(networkName).append("\" static ").append(" ").append(ipInfo.getPreferredDns()).append(" &   ");
            }
            if (!VerifyUtil.isEmpty((String)ipInfo.getAlternateDns())) {
                sb.append("netsh interface ip add dns \"").append(networkName).append("\" ").append(ipInfo.getAlternateDns()).append(" 2 & ");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileInfoFromVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth, String charset) {
        StringBuilder fileInfoSb;
        block8: {
            InputStreamReader inReader = null;
            SafeBufferedReader reader = null;
            InputStream in = null;
            HttpURLConnection urlConnection = null;
            fileInfoSb = new StringBuilder();
            try {
                String line;
                FileTransferInformation fileTransferInformation = conn.getVimPort().initiateFileTransferFromGuest(fileManagerRef, vmMor, (GuestAuthentication)auth, filePath);
                String fileDownloadUrl = fileTransferInformation.getUrl();
                URL urlSt = new URL(fileDownloadUrl);
                urlConnection = (HttpURLConnection)urlSt.openConnection();
                urlConnection.setDoInput(true);
                urlConnection.setDoOutput(true);
                urlConnection.setRequestProperty("Content-Type", "application/octet-stream");
                urlConnection.setRequestMethod("GET");
                in = urlConnection.getInputStream();
                inReader = new InputStreamReader(in, charset);
                reader = new SafeBufferedReader((Reader)inReader);
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    fileInfoSb.append(line.trim()).append(";");
                }
                CommonUtil.close((Closeable)reader);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("GetFileInfoFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
                break block8;
            }
            finally {
                CommonUtil.close(reader);
                CommonUtil.close(inReader);
                CommonUtil.close(in);
                if (null != urlConnection) {
                    urlConnection.disconnect();
                }
            }
            CommonUtil.close((Closeable)inReader);
            CommonUtil.close((Closeable)in);
            if (null != urlConnection) {
                urlConnection.disconnect();
            }
        }
        return fileInfoSb.toString();
    }

    private Map<String, VCenterNicIpInfo> getMacNetworkNameMapFromVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        HashMap<String, VCenterNicIpInfo> networkNames = new HashMap<String, VCenterNicIpInfo>();
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, UNICODE);
        try {
            String[] macInfos = fileInfo.split(";");
            for (int i = 0; i < macInfos.length; ++i) {
                if (VerifyUtil.isEmpty((String)macInfos[i]) || macInfos[i].split("=").length <= 1 || i + 1 >= macInfos.length || macInfos[i + 1].split("=").length <= 1) continue;
                String mac = macInfos[i].substring(macInfos[i].indexOf("=") + 1);
                String name = macInfos[i + 1].substring(macInfos[i + 1].indexOf("=") + 1);
                ++i;
                VCenterNicIpInfo nicIpInfo = new VCenterNicIpInfo();
                nicIpInfo.setNicName(name);
                nicIpInfo.setNicMac(mac);
                networkNames.put(mac, nicIpInfo);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetMacNetworkNameMapFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
        return networkNames;
    }

    private Map<String, VCenterNicIpInfo> getMacNetworkMac(String fileInfo, List<String> networkNames) {
        HashMap<String, VCenterNicIpInfo> macNetworkMap = new HashMap<String, VCenterNicIpInfo>();
        for (String line : fileInfo.split(";")) {
            String value;
            String[] mac;
            String networkName = null;
            for (String name : networkNames) {
                if (!line.endsWith(name + ":")) continue;
                networkName = name;
            }
            if (!VerifyUtil.isEmpty(networkName)) {
                networkNames.remove(networkName);
                VCenterNicIpInfo nicIpInfo = new VCenterNicIpInfo();
                nicIpInfo.setNicName(networkName);
                macNetworkMap.put("ipInfo", nicIpInfo);
            }
            if (line.split(":").length != 2 || line.split(":")[1].trim().length() != 17 || (mac = (value = line.split(":")[1]).split("-")).length != 6) continue;
            boolean isContinue = false;
            for (String ii : mac) {
                if (!ii.matches("^[A-Fa-f0-9]{2}")) continue;
                isContinue = true;
                break;
            }
            if (!isContinue) continue;
            VCenterNicIpInfo nicIpInfo = (VCenterNicIpInfo)macNetworkMap.get("ipInfo");
            macNetworkMap.remove("ipInfo");
            macNetworkMap.put(value, nicIpInfo);
        }
        return macNetworkMap;
    }

    private VCenterNicIpInfo getNetworkInfoFromVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        VCenterNicIpInfo networkInfo = new VCenterNicIpInfo();
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, ASCII);
        try {
            this.findNetworkInfo(networkInfo, fileInfo);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetNetworkInfoFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
        return networkInfo;
    }

    private void findNetworkInfo(VCenterNicIpInfo networkInfo, String fileInfo) {
        for (String line : fileInfo.split(";")) {
            String data;
            String trimLine = line.trim();
            if (trimLine.isEmpty()) continue;
            int dataIndex = trimLine.lastIndexOf(" ");
            char dataFirstChar = trimLine.charAt(dataIndex + 1);
            String string = data = Character.isDigit(dataFirstChar) ? trimLine.substring(dataIndex + 1) : "";
            if (trimLine.contains("IPAddress ")) {
                networkInfo.setIp(data);
            }
            if (trimLine.contains("SubnetMask ")) {
                networkInfo.setNetmask(data);
            }
            if (trimLine.contains("EnableDHCP ")) {
                boolean enable = data.equals("0x1");
                networkInfo.setDhcpEnabled4(enable);
            }
            if (trimLine.contains("DefaultGateway ") && data.split(",").length > 0) {
                networkInfo.setGateway(data.split(",")[0]);
            }
            if (!trimLine.contains("NameServer ")) continue;
            if (data.split(",").length > 0) {
                networkInfo.setPreferredDns(data.split(",")[0]);
            }
            if (data.split(",").length <= 1) continue;
            networkInfo.setAlternateDns(data.split(",")[1]);
        }
    }

    private Map<String, String> getSettingIdAndMacMapFromVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        HashMap<String, String> settingIdAndMacMap = new HashMap<String, String>();
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, UTF16LE);
        try {
            this.findSettingIdAndMacMap(settingIdAndMacMap, fileInfo);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetSettingIdAndMacMapFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
        return settingIdAndMacMap;
    }

    private void findSettingIdAndMacMap(Map<String, String> settingIdAndMacMap, String fileInfo) {
        for (String line : fileInfo.split(";")) {
            String trimLine = line.trim();
            if (trimLine.isEmpty() || trimLine.contains("MACAddress") || trimLine.contains("SettingID") || !trimLine.contains(":") || !trimLine.contains("{") || !trimLine.contains("}")) continue;
            int beginIndex = trimLine.indexOf("{");
            int endIndex = trimLine.indexOf("}");
            String macAddress = trimLine.substring(0, beginIndex).trim();
            String settingId = trimLine.substring(beginIndex, endIndex + 1).trim();
            settingIdAndMacMap.put(REGEDIT_PARAM.toLowerCase(Locale.US) + settingId.toLowerCase(Locale.getDefault()), macAddress);
        }
    }

    private List<String> getNetworkSettingIdsFromVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        ArrayList<String> networkSettingIds = new ArrayList<String>();
        String fileInfo = this.getFileInfoFromVm(conn, fileManagerRef, vmMor, filePath, auth, ASCII);
        try {
            this.findNetworkSettingIds(networkSettingIds, fileInfo);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("GetNetworkSettingIdsFromVm failed, vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
        return networkSettingIds;
    }

    private void findNetworkSettingIds(List<String> networkSettingIds, String fileInfo) throws IOException {
        for (String line : fileInfo.split(";")) {
            if (line.trim().isEmpty()) continue;
            networkSettingIds.add(line.trim());
        }
    }

    private void deleteFileOnVm(VmwareConnection conn, ManagedObjectReference fileManagerRef, ManagedObjectReference vmMor, String filePath, NamePasswordAuthentication auth) {
        try {
            conn.getVimPort().deleteFileInGuest(fileManagerRef, vmMor, (GuestAuthentication)auth, filePath);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("DeleteFileOnVm failed, please manually delete, filePath:" + filePath + ", vmMoId:" + vmMor.getValue()), (long)-1L, null, (Log)LOG);
        }
    }

    private Integer waitProcFinished(long pid, ManagedObjectReference processRef, VmwareConnection conn, ManagedObjectReference vmMor, NamePasswordAuthentication auth) {
        boolean isFinished = false;
        Integer exitCode = -1;
        ArrayList<Long> pidsList = new ArrayList<Long>();
        pidsList.add(pid);
        try {
            for (int i = 0; i < 20; ++i) {
                List procInfo = conn.getVimPort().listProcessesInGuest(processRef, vmMor, (GuestAuthentication)auth, pidsList);
                if (!VerifyUtil.isEmpty((Collection)procInfo) && null != ((GuestProcessInfo)procInfo.get(0)).getEndTime()) {
                    LOG.debug((Object)"Process is finished, pid: %s, existCode: %s", new Object[]{String.valueOf(pid), ((GuestProcessInfo)procInfo.get(0)).getExitCode()});
                    isFinished = true;
                    exitCode = ((GuestProcessInfo)procInfo.get(0)).getExitCode();
                    break;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"WaitProcFinished failed ", (long)-1L, null, (Log)LOG);
        }
        if (!isFinished) {
            LOG.error((Object)"WaitProcFinished timeout, pid: %s, vmMoId: %s", new Object[]{String.valueOf(pid), vmMor.getValue()});
            throw new LegoCheckedException(-1L);
        }
        return exitCode;
    }
}

