/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action.util;

import com.google.common.collect.Sets;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsVirtualEthernetCard;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.VirtualDiskSharing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;

public class VsphereReplicaChecker {
    private static final Log logger = LogFactory.getInstance(VsphereReplicaChecker.class);

    public static void checkSelectedVmInReplica(ProtectGroup pg, Map<String, String> contextMap) {
        String replicaId = contextMap.get("REPLICA_ID");
        ProtectGroupReplica pgReplica = pg.getReplicaList().stream().filter(replica -> Objects.equals(replica.getId(), replicaId)).findFirst().orElse(null);
        VsphereReplicaChecker.checkSecondSchedule(pg, pgReplica, contextMap);
        List<ProtectObject> poListInReplica = pgReplica.getReplicas().stream().map(ProtectObjectReplica::getProtectObject).collect(Collectors.toList());
        String selectedVmUuidsStr = contextMap.get("selectedVmMoIdList");
        String[] split = selectedVmUuidsStr.split(",", -1);
        List<String> selectedVmUuidList = Arrays.asList(split);
        logger.info((Object)"Selected vm uuid in replica(%s): %s, len=%s", new Object[]{replicaId, selectedVmUuidsStr, split.length});
        boolean isMatched = VsphereReplicaChecker.checkPoWithRdm(poListInReplica, selectedVmUuidList);
        if (isMatched) {
            logger.info((Object)"Selected vm in replica has rdm: %s", new Object[]{selectedVmUuidList});
            throw new LegoCheckedException(1073948974L);
        }
        VsphereReplicaChecker.checkSharingDiskCompletedSelected(poListInReplica, selectedVmUuidList);
    }

    private static void checkSecondSchedule(ProtectGroup pg, ProtectGroupReplica pgReplica, Map<String, String> contextMap) {
        if (pgReplica != null) {
            return;
        }
        String productSiteId = contextMap.get("DISASTER_SITE_ID");
        PolicyTemplate template = pg.getTemplate();
        VerifyUtil.checkObject((Object)template);
        Set schedules = template.getSchedules();
        for (Schedule schedule : schedules) {
            if (!Objects.equals(schedule.getSourceSiteId(), productSiteId) || !SnapshotScheduleUtil.isExistsSecondSchedule((Schedule)schedule)) continue;
            logger.error((Object)"VM Restoration doesnt support second snapshot.");
            throw new LegoCheckedException(1073948976L);
        }
        logger.error((Object)"PgReplica is empty: %s", new Object[]{contextMap.get("REPLICA_ID")});
        throw new LegoCheckedException(2117645L);
    }

    private static void checkSharingDiskCompletedSelected(List<ProtectObject> poListInReplica, List<String> selectedVmUuidList) {
        List<VsphereVirtualMachine> vmInReplica = poListInReplica.stream().map(VsphereReplicaChecker::convertFromToVm).collect(Collectors.toList());
        HashMap poIdAndVmMap = new HashMap();
        vmInReplica.forEach(vm -> poIdAndVmMap.put(vm.getUuid(), vm));
        HashMap diskUuidAndVmUuidMap = new HashMap();
        vmInReplica.forEach(vm -> VsphereReplicaChecker.groupDiskAndVm(vm, diskUuidAndVmUuidMap));
        List sharingDiskUuidList = vmInReplica.stream().flatMap(vm -> vm.getVirtualDisk().stream()).filter(disk -> VirtualDiskSharing.SHARING_MULTI_WRITER.value().equals(disk.getSharing())).map(VmVirtualDisk::getUuid).collect(Collectors.toList());
        logger.info((Object)"sharing disk uuids: %s", new Object[]{sharingDiskUuidList});
        for (String vmUuid : selectedVmUuidList) {
            VsphereVirtualMachine vm2 = (VsphereVirtualMachine)poIdAndVmMap.get(vmUuid);
            Optional.ofNullable(vm2).orElseThrow(() -> new LegoCheckedException(2117645L, vmUuid + " not found in replica"));
            vm2.getVirtualDisk().stream().filter(disk -> sharingDiskUuidList.contains(disk.getUuid())).forEach(disk -> VsphereReplicaChecker.checkAllVmSelected(vm2, disk.getUuid(), diskUuidAndVmUuidMap, poIdAndVmMap, selectedVmUuidList));
        }
    }

    private static VsphereVirtualMachine convertFromToVm(ProtectObject protectObject) {
        VsphereVirtualMachine vm = VsphereVirtualMachineUtils.convertFrom(protectObject);
        Set virtualDisk = vm.getVirtualDisk();
        virtualDisk.clear();
        Collection disks = protectObject.getProperties("VirtualDisk", VmVirtualDisk.class);
        vm.setVirtualDisk(new HashSet(disks));
        logger.debug((Object)"Disks of vm: %s", new Object[]{protectObject.getProperty("VirtualDisk")});
        String key = "VirtualEthernetCard";
        vm.setVirtualEthernetCardList(protectObject.getProperties(key, VsVirtualEthernetCard.class));
        return vm;
    }

    private static void checkAllVmSelected(VsphereVirtualMachine vm, String shareDiskUuid, Map<String, List<String>> shareDiskUuidAndVmUuidMap, Map<String, VsphereVirtualMachine> poAndVmMap, List<String> selectedVmUuidList) {
        List<String> allSharedVmUuidList = shareDiskUuidAndVmUuidMap.get(shareDiskUuid);
        if (VerifyUtil.isEmpty(allSharedVmUuidList)) {
            return;
        }
        ArrayList<String> notSelectedVmList = new ArrayList<String>();
        ArrayList<String> selectedVmName = new ArrayList<String>();
        for (String sharedVmUuid : allSharedVmUuidList) {
            if (!selectedVmUuidList.contains(sharedVmUuid)) {
                notSelectedVmList.add(poAndVmMap.get(sharedVmUuid).getName());
            }
            VsphereVirtualMachine selectedShareVm = poAndVmMap.get(sharedVmUuid);
            selectedVmName.add(selectedShareVm.getName());
        }
        if (!selectedVmName.isEmpty() && !notSelectedVmList.isEmpty()) {
            logger.error((Object)"shared vm not selected completely: ");
            char coma = ',';
            throw new LegoCheckedException(1073948963L, Arrays.asList(vm.getName(), Strings.join(notSelectedVmList, (char)coma)).toArray(new String[0]));
        }
    }

    private static void groupDiskAndVm(VsphereVirtualMachine vm, Map<String, List<String>> shareDiskUuidAndVmUuidMap) {
        vm.getVirtualDisk().forEach(disk -> VsphereReplicaChecker.addToShareDiskMap(shareDiskUuidAndVmUuidMap, disk.getUuid(), vm));
    }

    private static void addToShareDiskMap(Map<String, List<String>> shareDiskUuidAndVmUuidMap, String diskUuid, VsphereVirtualMachine vm) {
        List sharedVmUuid = shareDiskUuidAndVmUuidMap.get(diskUuid);
        sharedVmUuid = Optional.ofNullable(sharedVmUuid).orElse(new ArrayList());
        sharedVmUuid.add(vm.getUuid());
        shareDiskUuidAndVmUuidMap.put(diskUuid, sharedVmUuid);
    }

    public static boolean checkPoWithRdm(List<ProtectObject> poListInReplica, List<String> selectedVmUuidList) {
        List vmInReplica = poListInReplica.stream().map(VsphereReplicaChecker::convertFromToVm).collect(Collectors.toList());
        return vmInReplica.stream().filter(vm -> selectedVmUuidList.contains(vm.getUuid())).anyMatch(VsphereReplicaChecker::hasRdmDisk);
    }

    public static boolean hasRdmDisk(VsphereVirtualMachine vm) {
        HashSet rdmDiskType = Sets.newHashSet((Object[])new String[]{"physicalMode", "virtualMode"});
        return vm.getVirtualDisk().stream().anyMatch(disk -> rdmDiskType.contains(disk.getStorageType()));
    }
}

