/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.sdk.service.IVirtualizationApplicationOperator;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMSnapshotAction;
import com.huawei.ism.drm.vsphere.protect.action.ProtectVsphereVMSnapshotUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.vmware.vim25.VirtualMachineConnectionState;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;

public class VsphereOperatorImpl
implements IVirtualizationApplicationOperator {
    private static final Log logger = LogFactory.getInstance(VsphereOperatorImpl.class);

    public void freeze(ProtectObject po) {
        VsphereVirtualMachine mo = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)po.getMoUuid());
        if (mo == null) {
            logger.error((Object)("find mo null,vm name :" + po.getName()), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        VMSnapshotAction vmAction = new VMSnapshotAction();
        String snapShotName = ProtectVsphereVMSnapshotUtils.gengerateSnapShotName(po.getUuid());
        try {
            if (vmAction.findVMSnapshot(mo, snapShotName)) {
                if (!vmAction.deleteVMSnapshot(mo, snapShotName)) {
                    logger.error((Object)("find leave over vm snap shot,vm name :" + mo.getName() + " snap shot name:RD_" + po.getUuid()), 90160758786989L);
                    throw new LegoCheckedException(1073948099L, new String[]{snapShotName});
                }
                AlarmReporter.restoreAlarm((long)52625432L, (String[])new String[]{mo.getUuid(), mo.getName(), snapShotName});
            } else {
                AlarmReporter.restoreAlarm((long)52625432L, (String[])new String[]{mo.getName(), snapShotName});
            }
            boolean flag = vmAction.createVMSnapshot(mo, snapShotName);
            if (!flag) {
                throw new LegoCheckedException(1073948096L);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create snapshot error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"connect vcenter error.", (long)-1L, null, (Log)logger);
        }
    }

    public void launch(ProtectObject po) {
    }

    public void suspend(ProtectObject po) {
    }

    public void thaw(ProtectObject po) {
        boolean deleteFlag;
        VsphereVirtualMachine mo = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)po.getMoUuid());
        if (mo == null) {
            logger.error((Object)("find mo null,vm name :" + po.getUuid()), 90160758786989L);
            return;
        }
        String snapShotName = ProtectVsphereVMSnapshotUtils.gengerateSnapShotName(po.getUuid());
        try {
            deleteFlag = new VMSnapshotAction().deleteVMSnapshot(mo, snapShotName);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"connect vcenter error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            deleteFlag = false;
        }
        catch (Exception e) {
            logger.error((Object)("connect vcenter error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            deleteFlag = false;
        }
        if (!deleteFlag) {
            logger.debug((Object)("can not delete rd vm snap shot,vm name :" + mo.getName() + " snap shot name:RD_" + po.getUuid()), 90160758786989L);
            AlarmReporter.sendAlarm((long)52625432L, (String)po.getProtectGroup().getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{mo.getUuid(), mo.getName(), snapShotName});
        }
    }

    public void checkEnvForFreeze(ProtectObject po) {
        VsphereVirtualMachine mo = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)po.getMoUuid());
        if (mo == null) {
            logger.error((Object)("find mo null,vm name :" + po.getUuid()), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        VMAction vmAction = new VMAction();
        try {
            VirtualMachinePowerState powerState = vmAction.getVMPowerState(mo);
            if (powerState == null) {
                logger.error((Object)("vm power state is null ,vm name :" + mo.getName()), 90160758786989L);
                throw new LegoCheckedException(1073948154L, "vm power state is null");
            }
            if (VirtualMachinePowerState.POWERED_OFF == powerState) {
                logger.info((Object)"vm is power off, no need check vm tools, vm name:%s", new Object[]{mo.getName()});
                return;
            }
            VirtualMachineToolsRunningStatus toolsStatus = vmAction.getVMToolsStatus(mo);
            if (null == toolsStatus || VirtualMachineToolsRunningStatus.GUEST_TOOLS_NOT_RUNNING == toolsStatus) {
                logger.error((Object)("vm Tools status not ok ,vm name :" + mo.getName() + " vm Tools status :" + toolsStatus), 90160758786989L);
                throw new LegoCheckedException(1073948868L, "vm Tools status not ok");
            }
            logger.info((Object)"vm is vm tools is %s, vm name:%s", new Object[]{toolsStatus.value(), mo.getName()});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"connect vcenter error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"connect vcenter error.", (long)-1L, null, (Log)logger);
        }
    }

    public void checkVmState(ProtectObject po) {
        VirtualMachineConnectionState connectionState;
        VsphereVirtualMachine mo = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)po.getMoUuid());
        if (mo == null) {
            logger.error((Object)("find mo null,vm name :" + po.getUuid()), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        VMSnapshotAction vmAction = new VMSnapshotAction();
        try {
            connectionState = vmAction.getVMConnectionState(mo);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"connect vcenter error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"connect vcenter error.", (long)1073948154L, null, (Log)logger);
            connectionState = null;
        }
        if (null == connectionState) {
            logger.error((Object)("vm power state is null ,vm name :" + mo.getName()), 90160758786989L);
            throw new LegoCheckedException(1073948154L, "vm connection State is null");
        }
        if (VirtualMachineConnectionState.CONNECTED != connectionState) {
            logger.error((Object)("vm connection status is not connected ,vm name :" + mo.getName() + " connectionState:" + connectionState), 90160758786989L);
            throw new LegoCheckedException(1073948405L);
        }
        logger.info((Object)"checkVmState success, connect is:%s, vm name :%s", new Object[]{connectionState.value(), mo.getName()});
    }

    public int getAppType() {
        return 10;
    }
}

