/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.processer;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.vsphere.adapter.action.VsphereCenterAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;

public class PingProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(PingProcessor.class);

    public boolean process(AbstractContext context) {
        NetworkEntity ne = (NetworkEntity)context.getAttribute("StorageDevice");
        if (null == ne) {
            logger.error((Object)"networkEntity is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> ips = new ArrayList<String>();
        int nowStatus = 0;
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(ne.getUuid());
            VsphereCenterAction vsAction = new VsphereCenterAction();
            VsphereCenter vc = vsAction.queryVsphereCenter(conn);
            if (null == vc) {
                throw new LegoCheckedException(1073947689L);
            }
            if (!vc.getUuid().equals(ne.getUuid())) {
                logger.error((Object)"vcenter's uuid has changed.", 90160758786989L);
                throw new LegoCheckedException(1073947432L);
            }
            ips.add(conn.getIp());
        }
        catch (Exception e) {
            logger.error((Object)("connect vcenter is error:" + ne.getName() + ExceptionUtil.getErrorMessage((Throwable)e)));
            nowStatus = -1;
        }
        context.setAttribute("AvailableIps", ips);
        this.dealStatus(ne, nowStatus);
        return true;
    }

    private void dealStatus(NetworkEntity ne, int nowStatus) {
        Integer oldStatus = ne.getStatus();
        logger.debug((Object)("process status, ne=" + ne.getName() + ", oldStaus=" + oldStatus + ", newStatus=" + nowStatus));
        if (null != oldStatus && oldStatus == nowStatus) {
            return;
        }
        Istatus devStatus = GlobalDeviceStatus.getStatus((String)ne.getUuid(), DefaultOnlineToOfflineStatus.class);
        devStatus.doAction((ManagedObject)ne, nowStatus);
        DiscoverUtil.updateNetworkEntityStatus((NetworkEntity)ne, (int)nowStatus);
    }

    public void postProcess(AbstractContext context) {
    }

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return PingProcessor.class.getName();
    }
}

