/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.processer;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class SiteResourceProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(SiteResourceProcessor.class);

    public boolean process(AbstractContext context) {
        VsphereCenter vc = (VsphereCenter)context.getAttribute("vCenterObj");
        String action = (String)context.getAttribute("DiscoveryType");
        String siteId = (String)context.getAttribute("siteId");
        if (null == vc) {
            return false;
        }
        if ("register".equals(action)) {
            this.addDrResource(vc, siteId);
        } else {
            List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{vc.getSn()});
            if (!VerifyUtil.isEmpty((Collection)resources) && !resources.isEmpty()) {
                DrVsphereCenter drVcenter = (DrVsphereCenter)resources.get(0);
                this.updateDrResource(vc, drVcenter);
            }
        }
        return true;
    }

    private void addDrResource(VsphereCenter vc, String siteId) {
        if (null == siteId || siteId.isEmpty()) {
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            logger.error((Object)"Query site by id %s is null.", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
        SiteResourceServiceProxy.getInstance().getSiteResourceService("ism.drm.deviceType.drvsphere.mainType").registerResource(site, new String[]{vc.getSn()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDrResource(VsphereCenter vc, DrVsphereCenter drVcenter) {
        ArrayList<DrResource> esxiHosts = new ArrayList<DrResource>();
        ArrayList<DrResource> removeHosts = new ArrayList<DrResource>();
        HashMap<String, String> esxSiteMap = new HashMap<String, String>();
        this.getUpdateInfo(vc, drVcenter, esxiHosts, removeHosts);
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            for (DrResource resource : removeHosts) {
                esxSiteMap.put(resource.getDeviceSn(), resource.getSiteId());
                session.delete((Object)resource);
            }
            session.saveOrUpdate((Object)drVcenter);
            for (DrResource resource : esxiHosts) {
                String esxSiteId = null == esxSiteMap.get(resource.getDeviceSn()) ? drVcenter.getSiteId() : (String)esxSiteMap.get(resource.getDeviceSn());
                resource.setSiteId(esxSiteId);
                session.save((Object)resource);
            }
            t.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("Batch quering luns by device sn failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    private void getUpdateInfo(VsphereCenter vc, DrVsphereCenter drVcenter, List<DrResource> esxiHosts, List<DrResource> removeHosts) {
        drVcenter.setStatus(vc.getStatus() + "");
        drVcenter.setVersion(vc.getVersion());
        drVcenter.setName(vc.getName());
        DrVsphereCenter newDrVcenter = (DrVsphereCenter)SiteResourceServiceProxy.getInstance().getSiteResourceService("ism.drm.deviceType.drvsphere.mainType").getDrResourceByMo((ManagedObject)vc);
        removeHosts.addAll(drVcenter.getChildResources());
        drVcenter.getChildResources().clear();
        for (DrResource resource : newDrVcenter.getChildResources()) {
            resource.setParentDrResource((DrResource)drVcenter);
            drVcenter.addChildResource(resource);
            esxiHosts.add(resource);
        }
        newDrVcenter.getChildResources().clear();
    }

    public void postProcess(AbstractContext context) {
    }

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return SiteResourceProcessor.class.getName();
    }
}

