/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.service.IVsphereDiscoveryService;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

@Service(name="com.huawei.ism.drm.vsphere.sdk.service.IVsphereDiscoveryService", desc="", interfaceClass=IVsphereDiscoveryService.class)
public class VsphereDiscoveryServiceImpl
extends BaseService
implements IVsphereDiscoveryService {
    private static final Log logger = LogFactory.getInstance(VsphereDiscoveryServiceImpl.class);
    private IMoDao moDao;
    private INeMgrProtocolExtendService neMgr;

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public void refreshVsphere(String uuid, String userName) {
        if (null == uuid || uuid.isEmpty()) {
            logger.error((Object)"uuid is empty, and refreshing Host failed", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        VsphereCenter vCenter = (VsphereCenter)this.moDao.getMo(VsphereCenter.class, "uuid", (Object)uuid);
        if (null == vCenter) {
            logger.error((Object)("vCenter(" + uuid + ") dosen't exist.Failed to refresh."), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        long moId = vCenter.getMoId();
        NeMgrProtocolExtend extend = this.neMgr.findByMoId(Long.valueOf(moId));
        if (null == extend) {
            logger.error((Object)("vCenter(" + uuid + ")'NeMgrProtocolExtend dosen't exist.Failed to refresh."), 90160777660713L);
            throw new LegoCheckedException(1073947393L);
        }
        BackTask bt = BackTaskUtil.buildBackTask((String)vCenter.getName(), (String)"ism.srm.server.vsphere.refresh.operationName", (String)userName, (String)"", null);
        AbstractBackTask task = new AbstractBackTask(vCenter.getUuid(), bt, true){

            protected void doWork() {
                VsphereCenter vc = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.getTaskId());
                RefreshContext context = new RefreshContext((ManagedObject)vc);
                context.setAttribute("refreshTask", (Object)this);
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Vsphere");
                if (refreshTemplate == null) {
                    throw new LegoCheckedException(127402L);
                }
                refreshTemplate.process((AbstractContext)context);
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
            }
        };
        BackTaskHandler.getInstance().submitTask(task);
    }
}

