/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.validator;

import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;

public class VsphereDisParamValidator
implements IDisParamValidator {
    private static final int USERNAME_MAX_LENGTH = 255;
    private static final int PWD_MAX_LENGTH = 64;
    private static final Log logger = LogFactory.getInstance(VsphereDisParamValidator.class);

    public String getValidatorKey() {
        return "ism.drm.deviceType.drvsphere.mainType";
    }

    public DiscParamVilidateResult validate(DiscoveryPolicy policy) {
        DiscParamVilidateResult result = new DiscParamVilidateResult();
        String uName = (String)policy.getParamMap().get("username");
        String uPWD = (String)policy.getParamMap().get("password");
        String port = (String)policy.getParamMap().get("port");
        String siteId = policy.getLocation();
        if (this.varifyDiscParams(uName, uPWD, port) || null == siteId) {
            result.setResult(true);
        } else {
            result.setResult(false);
            result.setErrorCode(2099466L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (null == site) {
            result.setResult(false);
            result.setErrorCode(2099466L);
        }
        return result;
    }

    private boolean varifyDiscParams(String userName, String pwd, String port) {
        if (DiscParamValidator.stringisNull((String)userName) || DiscParamValidator.stringisNull((String)pwd) || VerifyUtil.isEmpty((String)port)) {
            logger.error((Object)"userName, pwd or port is empty.", 90160758786989L);
            return false;
        }
        if (userName.length() > 255 || pwd.length() > 64) {
            logger.error((Object)"userName or pwd is more than max length.", 90160758786989L);
            return false;
        }
        try {
            return CommUtil.checkDrmPortParam((String)port);
        }
        catch (Exception e) {
            logger.error((Object)("check port is error . parm:" + port + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return false;
        }
    }
}

