/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.protect.action;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.vsphere.protect.action.DeleteVsphereVMSnapshotTask;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ProtectVsphereVMSnapshotUtils {
    public static final String VSPHERE_SNAPSHOT_SUCCESS = "VsphereSnapshotSuccess";
    private static final Log logger = LogFactory.getInstance(ProtectVsphereVMSnapshotUtils.class);
    private static final List<Integer> SYNC_METRO_TEMPLATE_TYPE = Arrays.asList(6, 19, 17, 28, 30, 31, 32);
    private static final ExecutorService fixedThreadPool = Executors.newFixedThreadPool(20);

    private ProtectVsphereVMSnapshotUtils() {
    }

    public static boolean isNeedHandleVMSnapshot(ProtectGroupReplica replica, PolicyTemplate policyTemplate) {
        if (null == replica || null == policyTemplate) {
            return false;
        }
        for (Schedule schedule : policyTemplate.getSchedules()) {
            if (replica.getProtectLocation() != schedule.getProtectLocation() || !ScheduleProtectedType.isSameType((int)replica.getType(), (int)schedule.getProtectedType())) continue;
            Boolean isAppConsistent = schedule.isAppConsistent();
            logger.debug((Object)("App Consistent is " + isAppConsistent));
            return null != isAppConsistent && isAppConsistent != false;
        }
        return false;
    }

    public static boolean isNeedHandleVMSnapshot(ActionContext context) {
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY", ProtectionTask.class);
        if (null == task) {
            return false;
        }
        Schedule schedule = task.getSchedule();
        if (null == schedule) {
            return false;
        }
        Boolean isAppConsistent = schedule.isAppConsistent();
        logger.debug((Object)("App Consistent is " + isAppConsistent));
        return null != isAppConsistent && isAppConsistent != false;
    }

    public static boolean isContinueConsistentFail(ActionContext context) {
        ProtectionTask task = (ProtectionTask)context.getObject("TASK_ENTITY", ProtectionTask.class);
        if (null == task) {
            return false;
        }
        Schedule schedule = task.getSchedule();
        return ProtectVsphereVMSnapshotUtils.isNeedHandleVMSnapshot(context) && ProtectVsphereVMSnapshotUtils.isContinueConsistentFail(schedule);
    }

    private static boolean isContinueConsistentFail(Schedule schedule) {
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return false;
        }
        Map extParams = schedule.getExtParameters();
        return Boolean.valueOf((String)extParams.get("continueAppConsistentFailure"));
    }

    public static void callback(ActionContext context) {
        boolean flag = ProtectVsphereVMSnapshotUtils.isNeedHandleVMSnapshot(context);
        if (!flag) {
            return;
        }
        ArrayList<DeleteVsphereVMSnapshotTask> removeSnapShotTasks = new ArrayList<DeleteVsphereVMSnapshotTask>();
        Set successSet = (Set)context.getContext().get(VSPHERE_SNAPSHOT_SUCCESS);
        if (VerifyUtil.isEmpty((Collection)successSet)) {
            return;
        }
        for (ProtectObject po : successSet) {
            removeSnapShotTasks.add(new DeleteVsphereVMSnapshotTask(po));
        }
        for (DeleteVsphereVMSnapshotTask task : removeSnapShotTasks) {
            fixedThreadPool.execute(task);
        }
    }

    public static String gengerateSnapShotName(String poUuid) {
        return "RD_" + poUuid;
    }

    public static boolean isContainRDMVirtualDisk(VsphereVirtualMachine vm) {
        boolean flag = false;
        Set allVirtualDisks = vm.getVirtualDiskFromConfig();
        if (allVirtualDisks == null || allVirtualDisks.isEmpty()) {
            return flag;
        }
        for (VmVirtualDisk vmVirtualDisk : allVirtualDisks) {
            if (!vmVirtualDisk.getStorageType().equals("physicalMode") && !vmVirtualDisk.getStorageType().equals("virtualMode")) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

