/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateLunSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteLunProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteLunSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VmRollbackDeleteLunProcessor
extends DeleteLunProcessor {
    public void resetEnableStatus(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        this.setIsEnabled(VsphereRecoveryUtils.isRemoteVmRollbackScenario(plan, execType));
    }

    public void endRecoveryProcessor() {
        RecoveryProcessorContext context = this.getContextRef();
        Object cleanModeObj = context.getAttribute("cleanModeForVm");
        if (!VerifyUtil.isEmpty((Object)cleanModeObj)) {
            this.deleteCreateLunSubProcessor(context);
        }
        super.endRecoveryProcessor();
    }

    private void deleteCreateLunSubProcessor(RecoveryProcessorContext context) {
        Set deleteLunIdSet = this.getChildProc().stream().filter(processor -> processor instanceof DeleteLunSubProcessor).map(processor -> (DeleteLunSubProcessor)processor).filter(processor -> processor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(processor -> processor.getDeviceId() + processor.getLunId()).collect(Collectors.toSet());
        if (VerifyUtil.isEmpty(deleteLunIdSet)) {
            return;
        }
        List createLunSubProcessorList = VmRollbackDeleteLunProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)context.getRecoveryPlan(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), CreateLunSubProcessor.class);
        Set<CreateLunSubProcessor> deletedSubProcessor = createLunSubProcessorList.stream().filter(processor -> processor instanceof CreateLunSubProcessor).map(processor -> (CreateLunSubProcessor)processor).filter(processor -> deleteLunIdSet.contains(processor.getDeviceId() + processor.getLunId())).collect(Collectors.toSet());
        IRecoveryProcessService processService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        deletedSubProcessor.forEach(arg_0 -> ((IRecoveryProcessService)processService).deleteRecoveryProcessor(arg_0));
    }
}

