/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class VmRollbackMappingLunSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(VmRollbackMappingLunSubProcessor.class);
    private String deviceSn;
    private String lunId;
    private String lunName;
    private String lunGroupId;
    private String hostOrGroupId;
    private String hostOrGroupName;
    private ResourceVO resourceVo;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.lunName, this.hostOrGroupId});
        LOGGER.info((Object)"Start to map LUN(%s) the host(%s)", new Object[]{this.lunName, this.hostOrGroupId});
        this.resourceVo = RecoveryToolsUtil.getInstance().getResourceVO(this.hostOrGroupId);
        if (this.resourceVo == null) {
            LOGGER.error((Object)"The host entity is not found, host id:%s", new Object[]{this.hostOrGroupId});
            this.updateProcessDetail("lego.err.1073948686", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.hostOrGroupName = this.resourceVo.getName();
        this.updateProcessNameParams(new String[]{this.lunName, this.hostOrGroupName});
        try {
            IStorageMappingHandler mappingHandler = (IStorageMappingHandler)ServiceLocator.getInstance().getService(IStorageMappingHandler.class);
            mappingHandler.addObjectToLunGroup(this.deviceSn, this.lunGroupId, XveMOType.LUN, this.lunId);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to map LUN(%s) the host(%s), error msg:%s", new Object[]{this.lunName, this.hostOrGroupId, e.getMessage()});
            this.updateProcessDetail("lego.err.1073948676", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        LOGGER.info((Object)"The LUN(%s) has been mapped to the host(%s) successfully.", new Object[]{this.lunName, this.hostOrGroupId});
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    public void setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public void setLunGroupId(String lunGroupId) {
        this.lunGroupId = lunGroupId;
    }

    public void setHostOrGroupId(String hostOrGroupId) {
        this.hostOrGroupId = hostOrGroupId;
    }

    public void setHostOrGroupName(String hostOrGroupName) {
        this.hostOrGroupName = hostOrGroupName;
    }

    public void setResourceVo(ResourceVO resourceVo) {
        this.resourceVo = resourceVo;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getLunId() {
        return this.lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public String getLunGroupId() {
        return this.lunGroupId;
    }

    public String getHostOrGroupId() {
        return this.hostOrGroupId;
    }

    public String getHostOrGroupName() {
        return this.hostOrGroupName;
    }

    public ResourceVO getResourceVo() {
        return this.resourceVo;
    }
}

