/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.host.recovery.process.DeleteLunMappingSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.process.VmRollbackMappingLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class VmRollbackUnMappingLunProcessor
extends BaseRecoveryProcessor {
    public static final String MAPPING_KEY = "mappingForVmRecovery";
    private static final Log LOGGER = LogFactory.getInstance(VmRollbackUnMappingLunProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        List subProcessorList = context.getObjects(MAPPING_KEY, VmRollbackMappingLunSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)subProcessorList)) {
            LOGGER.warn((Object)"No LUN needs to be unmapped.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.generateSubProcessor(subProcessorList);
        return this.executeSubProcessor(context);
    }

    private void generateSubProcessor(List<VmRollbackMappingLunSubProcessor> mappingLunSubProssorList) {
        HashSet<DeleteLunMappingSubProcessor> unMappingSubProcessorSet = new HashSet<DeleteLunMappingSubProcessor>();
        for (VmRollbackMappingLunSubProcessor mappingLunSubProcessor : mappingLunSubProssorList) {
            DeleteLunMappingSubProcessor processor = new DeleteLunMappingSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setDeviceId(mappingLunSubProcessor.getDeviceSn());
            processor.setLunId(mappingLunSubProcessor.getLunId());
            processor.setLunName(mappingLunSubProcessor.getLunName());
            processor.setResourceVO(mappingLunSubProcessor.getResourceVo());
            processor.setHostOrGroupId(mappingLunSubProcessor.getHostOrGroupId());
            processor.setHostOrGroupName(VerifyUtil.isEmpty((String)mappingLunSubProcessor.getHostOrGroupName()) ? mappingLunSubProcessor.getHostOrGroupId() : mappingLunSubProcessor.getHostOrGroupName());
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setIsNeedSave(this.getIsNeedSave());
            processor.setIsNeedCreateDetail(this.getIsNeedCreateDetail());
            unMappingSubProcessorSet.add(processor);
        }
        this.setChildProc(unMappingSubProcessorSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

