/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsInitVmsProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsStartVmsProcessor;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VsCfgStartVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 44990937689533101L;
    private static final Log logger = LogFactory.getInstance(VsCfgStartVmProcessor.class);
    private static final long QUERY_INTERVAL = 15000L;
    private static final long QUERY_TIMES = 60L;
    private boolean isComplete = false;
    private String vcenterUuid;

    protected void setRefreshComplete(boolean arg) {
        this.isComplete = arg;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.initVcenterUuid();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.updateSubProcessors();
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)type);
        if (null == recoveryTemplate) {
            throw new LegoCheckedException(1073947394L);
        }
        recoveryTemplate.process(context);
        this.calcStatusBySubProc();
        this.refreshVcenter(context);
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != this.getProcStatus() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != this.getProcStatus();
    }

    private void calcStatusBySubProc() {
        HashSet<RecoveryProcessor> childSet = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor proc : this.getChildProc()) {
            if (proc instanceof VsCfgVmsProcessor) continue;
            childSet.add(proc);
        }
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(childSet);
        this.setProcStatus(procStatus.getValue());
    }

    private void refreshVcenter(RecoveryProcessorContext context) {
        VsphereCenter vCenter;
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() != this.getProcType()) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return;
        }
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsInitVmsProcessor.class);
        if (VerifyUtil.isEmpty((Collection)processors)) {
            return;
        }
        RecoveryProcessor processor = (RecoveryProcessor)CommonUtil.getFirstElement((Collection)processors);
        if (processor == null) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() == processor.getProcStatus()) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == processor.getProcStatus()) {
            this.unlockProtectGroup(context.getProtectGroup().getUuid());
        }
        if (null == (vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.vcenterUuid))) {
            logger.error((Object)("vCenter(" + this.vcenterUuid + ") dosen't exist.Failed to refresh."), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947394", null);
            return;
        }
        try {
            int counter = 0;
            AbstractBackTask task = this.constructAbBackTask(vCenter, context);
            BackTaskHandler.getInstance().submitTask(task);
            while (!this.isComplete && (long)counter < 60L) {
                ++counter;
                Thread.sleep(15000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("submit task and wait failed " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        if (this.isComplete) {
            RecoveryToolsUtil.getInstance().setPoRecoveryStatusAfterRefresh(this.getContextRef(), this.getProcType(), DrmEnumDefine.AppType.VM.getValue());
        }
    }

    private void unlockProtectGroup(String pgUuid) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgUuid, false);
        if (null != pg && pg.getStatus() == DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus()) {
            IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            recoveryProcessHandler.unlockProtectGroups(this.getContextRef().getRecoveryPlan().getProtectGroups());
            this.getContextRef().removeAttribute("LockProtectGroup");
            logger.info((Object)("unlock protectgroup:name=" + pg.getName()));
        }
    }

    private void updateSubProcessors() {
        HashSet<BaseRecoveryProcessor> subProcSet = new HashSet<BaseRecoveryProcessor>();
        VsInitVmsProcessor initVmsProc = new VsInitVmsProcessor();
        this.initProc((RecoveryProcessor)initVmsProc);
        initVmsProc.setVcenterUuid(this.vcenterUuid);
        initVmsProc.setPreviousProcessor(null);
        subProcSet.add(initVmsProc);
        VsCfgResForVmsProcessor resProc = new VsCfgResForVmsProcessor();
        this.initProc((RecoveryProcessor)resProc);
        resProc.setVcenterUuid(this.vcenterUuid);
        initVmsProc.setNextProcessor((RecoveryProcessor)resProc);
        resProc.setPreviousProcessor((RecoveryProcessor)initVmsProc);
        subProcSet.add(resProc);
        VsCfgVmsProcessor cfgVmsProc = new VsCfgVmsProcessor();
        this.initProc((RecoveryProcessor)cfgVmsProc);
        cfgVmsProc.setVcenterUuid(this.vcenterUuid);
        cfgVmsProc.setPreviousProcessor((RecoveryProcessor)resProc);
        resProc.setNextProcessor((RecoveryProcessor)cfgVmsProc);
        subProcSet.add(cfgVmsProc);
        VsStartVmsProcessor startVmsProc = new VsStartVmsProcessor();
        this.initProc((RecoveryProcessor)startVmsProc);
        startVmsProc.setVcenterUuid(this.vcenterUuid);
        startVmsProc.setPreviousProcessor((RecoveryProcessor)cfgVmsProc);
        startVmsProc.setNextProcessor(null);
        cfgVmsProc.setNextProcessor((RecoveryProcessor)startVmsProc);
        subProcSet.add(startVmsProc);
        this.setChildProc(subProcSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private AbstractBackTask constructAbBackTask(VsphereCenter vCenter, final RecoveryProcessorContext recoveryContext) {
        BackTask bt = BackTaskUtil.buildBackTask((String)vCenter.getName(), (String)"ism.srm.server.vsphere.refresh.operationName", (String)"System", (String)"", null);
        AbstractBackTask task = new AbstractBackTask(vCenter.getUuid(), bt, true){

            protected void doWork() {
                CommonTemplate refreshTemplate;
                VsphereCenter vc = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.getTaskId());
                RefreshContext context = new RefreshContext((ManagedObject)vc);
                context.setAttribute("refreshTask", (Object)this);
                if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == VsCfgStartVmProcessor.this.getProcType()) {
                    HashSet<String> pgUuidSet = new HashSet<String>();
                    pgUuidSet.add(recoveryContext.getProtectGroup().getUuid());
                    context.setAttribute("PG_FORCE_REFRESH_SET", pgUuidSet);
                }
                if ((refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Vsphere")) == null) {
                    VsCfgStartVmProcessor.this.setRefreshComplete(true);
                    throw new LegoCheckedException(127402L);
                }
                try {
                    refreshTemplate.process((AbstractContext)context);
                }
                catch (Exception e) {
                    logger.error((Object)("refresh vcenter task excute exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    throw new LegoCheckedException(errorCode.longValue());
                }
                VsCfgStartVmProcessor.this.setRefreshComplete(true);
            }
        };
        return task;
    }

    private void initVcenterUuid() {
        if (VerifyUtil.isEmpty((String)this.vcenterUuid)) {
            RecoveryProcessorContext context = this.getContextRef();
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            ProtectGroup pg = context.getProtectGroup();
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
                this.vcenterUuid = pg.getPoProviderSN();
            } else {
                RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)pg.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
                this.vcenterUuid = setting.getValue();
            }
        }
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsCfgStartVmProcessor.des");
    }
}

