/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMGuestAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.vmware.vim25.ArrayOfVirtualDevice;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualDevice;
import com.huawei.vmware.vim25.VirtualEthernetCard;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class VsCfgVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 6738681950856099734L;
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.";
    private static final String CONFIGNETWORK_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.configVmNetwork.failed";
    private static final String UNKNOW_OSTYPE = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.unknow.ostype";
    private static final String LINUX_GUEST_FAMILY_KEY = "linuxGuest";
    private static final String WINDOWS_GUEST_FAMILY_KEY = "windowsGuest";
    private static final String HAVE_CFGED = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.haveconfiged";
    private static final String CONFIGIP_CONFIG_ERROR = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.configiperror";
    private static final Log logger = LogFactory.getInstance(VsCfgVmSubProcessor.class);
    private String vcenterUuid = "";
    private String hostName = "";
    private String poId = "";
    private String vmName = "";
    private String vmMoId = "";
    private String guestOsType = "";
    private String vmNetCardsInfo;
    private String vmxPath;
    private int preResult;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.preResult) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor.failed", new String[]{this.vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(HAVE_CFGED, new String[0]);
            logger.debug((Object)("vm network has config yet " + this.vmName), 90160758786988L);
            return true;
        }
        boolean ret = this.configVmNetworks();
        if (!ret) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        return true;
    }

    private boolean configVmNetworks() {
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        if (VerifyUtil.isEmpty((String)this.vmNetCardsInfo)) {
            logger.error((Object)"vm ethernet card info is empty", 90160758786989L);
            return false;
        }
        logger.info((Object)("vm " + this.vmName + " ethernet card info=" + this.vmNetCardsInfo), 90160758786988L);
        String key = "";
        int planType = this.getProcType();
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
            key = "testNetwork";
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryNetwork";
        }
        String networkSetting = (String)plan.getGlobalSettings().get(key);
        if (VerifyUtil.isEmpty((String)networkSetting)) {
            logger.error((Object)(this.vmName + " get net configuration failed "), 90160758786989L);
            return false;
        }
        logger.info((Object)("vm " + this.vmName + " network setting=" + networkSetting), 90160758786988L);
        JSONArray vmNetCfgJsonArr = JSONArray.fromObject((Object)this.vmNetCardsInfo);
        JSONArray hostNetMapJsonArr = JSONArray.fromObject((Object)networkSetting);
        HashMap<String, String> macMap = new HashMap<String, String>();
        HashMap<String, VsNetWork> vmNetworkMap = new HashMap<String, VsNetWork>();
        for (int i = 0; i < vmNetCfgJsonArr.size(); ++i) {
            JSONObject vmNetCfgJson = vmNetCfgJsonArr.getJSONObject(i);
            String vmMac = vmNetCfgJson.getString("macAddress");
            String vmNetName = vmNetCfgJson.getString("ethernetCardName");
            String hostNetUuid = vmNetCfgJson.getString("netWorkUuid");
            VsNetWork remoteNetwork = this.getRemoteNetwork(hostNetMapJsonArr, hostNetUuid);
            macMap.put(vmMac, vmNetName);
            vmNetworkMap.put(vmNetName, remoteNetwork);
        }
        VMAction action = new VMAction();
        boolean cfgNetRet = action.configVMNetWorks(this.vcenterUuid, this.vmMoId, vmNetworkMap, false);
        if (!cfgNetRet) {
            logger.error((Object)("config vm nic failed " + this.vmName), 90160758786989L);
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            return false;
        }
        logger.debug((Object)("config VM " + this.vmName + " network sucessfully:"), 90160758786988L);
        boolean cfgIpSucc = this.configVmIp(macMap);
        boolean cfgNetResult = action.configVMNetWorks(this.vcenterUuid, this.vmMoId, vmNetworkMap, true);
        if (!cfgNetResult) {
            logger.error((Object)"change network to auto connect failed");
        }
        return cfgIpSucc;
    }

    private VsNetWork getRemoteNetwork(JSONArray jsonArray, String hostNetUuid) {
        logger.debug((Object)"getRemoteNetwork start");
        VsNetWork network = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            String srcNetUuid = json.getString("srcNetworkId");
            if (!hostNetUuid.equals(srcNetUuid)) continue;
            String remoteNetworkId = json.getString("remoteNetworkId");
            network = (VsNetWork)CommonDAOLocator.getMoDao().getMo(VsNetWork.class, "uuid", (Object)remoteNetworkId);
            break;
        }
        return network;
    }

    private boolean configVmIp(Map<String, String> macMap) {
        boolean ret;
        if (!this.needCfgIp(macMap)) {
            logger.info((Object)("vm config is empty, no need to config ip: " + this.vmName), 90160758786988L);
            return true;
        }
        if (WINDOWS_GUEST_FAMILY_KEY.equals(this.guestOsType)) {
            ret = this.configWindowsVmIp(macMap);
        } else if (LINUX_GUEST_FAMILY_KEY.equals(this.guestOsType)) {
            ret = this.configLinuxVmIp(macMap);
        } else {
            this.updateProcessDetail(UNKNOW_OSTYPE, null);
            return true;
        }
        if (!ret) {
            logger.error((Object)("config vm ip failed " + this.vmName), 90160758786989L);
            return false;
        }
        logger.info((Object)("config VM ip success:" + this.vmName), 90160758786988L);
        return true;
    }

    private boolean needCfgIp(Map<String, String> map) {
        boolean hasCfgedIP = false;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String mac = entry.getKey();
            String ipInfo = this.getIpInfo(mac, this.getContextRef().getRecoveryPlan());
            if (VerifyUtil.isEmpty((String)ipInfo)) continue;
            hasCfgedIP = true;
            break;
        }
        return hasCfgedIP;
    }

    private boolean configWindowsVmIp(Map<String, String> macMap) {
        Boolean startedFlag = false;
        if (this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
            startedFlag = VsphereRecoveryUtils.getInstance().isPoNeedStart(this.poId, this.getContextRef().getRecoveryPlan());
        }
        if (startedFlag.booleanValue()) {
            return true;
        }
        JSONObject authJson = VsphereRecoveryUtils.getInstance().getWindowsVmAuthJson(this.poId, this.getContextRef().getRecoveryPlan());
        if (authJson.isEmpty() || !authJson.containsKey((Object)"username") || !authJson.containsKey((Object)"password")) {
            logger.info((Object)("vm auth info is empty,no need to config ip: " + this.vmName), 90160758786988L);
            return true;
        }
        if (!this.startVm()) {
            logger.error((Object)("startVm failed " + this.vmName), 90160758786989L);
            return false;
        }
        Map<String, VCenterNicIpInfo> configMap = this.getConfigParamMap(macMap, this.getContextRef().getRecoveryPlan());
        String username = authJson.getString("username");
        String password = authJson.getString("password");
        boolean ret = false;
        try {
            VMGuestAction guestAction = new VMGuestAction();
            ret = guestAction.configWindowsVMIp(this.vcenterUuid, this.vmMoId, username, WccEncryptor.decrypt((String)password), configMap);
            if (!ret) {
                this.updateProcessDetail(CONFIGIP_CONFIG_ERROR, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(CONFIGIP_CONFIG_ERROR, new String[0]);
        }
        if (!this.shutdownVm()) {
            logger.error((Object)("shutdownVm failed " + this.vmName), 90160758786989L);
            return false;
        }
        return ret;
    }

    private boolean configLinuxVmIp(Map<String, String> macMap) {
        if (!this.startVm()) {
            logger.error((Object)("startupVm failed " + this.vmName), 90160758786989L);
            return false;
        }
        Map<String, VCenterNicIpInfo> configMap = this.getConfigParamMap(macMap, this.getContextRef().getRecoveryPlan());
        if (!this.shutdownVm()) {
            logger.error((Object)("shutdownVm failed " + this.vmName), 90160758786989L);
            return false;
        }
        boolean ret = false;
        try {
            VMAction action = new VMAction();
            ret = action.configLinuxVMIp(this.vcenterUuid, this.vmMoId, configMap, this.hostName);
            if (!ret) {
                this.updateProcessDetail(CONFIGIP_CONFIG_ERROR, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
        }
        return ret;
    }

    private boolean shutdownVm() {
        boolean ret = false;
        try {
            VMAction action = new VMAction();
            action.shutdownGuest(this.vcenterUuid, this.vmMoId);
            ret = this.checkVmShutdownResultAndWait(this.vmMoId);
            if (!ret) {
                this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            logger.error((Object)(this.vmName + " rebootVm  failed: "), (Throwable)e, 90160758786989L);
        }
        catch (Exception e) {
            logger.error((Object)(this.vmName + " rebootVm  failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
        }
        logger.info((Object)(this.vmName + " rebootVm  result is " + ret), 90160758786988L);
        return ret;
    }

    private boolean startVm() {
        boolean ret = false;
        VMAction action = new VMAction();
        try {
            VirtualMachinePowerState powserState = action.getVMPowerState(this.vcenterUuid, this.vmMoId);
            if (VirtualMachinePowerState.POWERED_OFF == powserState) {
                action.powerOnVM(this.vcenterUuid, this.vmMoId);
            }
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(this.vcenterUuid, this.vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.info((Object)("start VM " + this.vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + this.vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
        }
        return ret;
    }

    private boolean checkVmShutdownResultAndWait(String moId) {
        VMAction vmAction = new VMAction();
        boolean ret = false;
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachinePowerState status = vmAction.getVMPowerState(this.vcenterUuid, moId);
                if (null != status && VirtualMachinePowerState.POWERED_OFF == status) {
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"shutdown  VM failed: thread interuptted", 90160758786989L);
            return false;
        }
        return ret;
    }

    protected Map<String, VCenterNicIpInfo> getConfigParamMap(Map<String, String> map, RecoveryPlan plan) {
        logger.debug((Object)"getConfigParamMap start");
        Map<String, String> nameAndRealMacMap = this.getNameAndMacMap();
        HashMap<String, VCenterNicIpInfo> configMap = new HashMap<String, VCenterNicIpInfo>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String mac = entry.getKey();
            String ipInfo = this.getIpInfo(mac, plan);
            if (VerifyUtil.isEmpty((String)ipInfo)) continue;
            String realMac = nameAndRealMacMap.get(entry.getValue()).replaceAll(":", "-").toUpperCase(Locale.US);
            VCenterNicIpInfo cfg = (VCenterNicIpInfo)JSONObject.toBean((String)ipInfo, VCenterNicIpInfo.class);
            configMap.put(realMac, cfg);
        }
        return configMap;
    }

    private String getIpInfo(String mac, RecoveryPlan plan) {
        logger.debug((Object)"getIpInfo start");
        String key = "IPV4:" + mac;
        Set recoverySettingSet = plan.getRecoverySettings();
        String ipInfo = "";
        for (RecoverySetting setting : recoverySettingSet) {
            if (setting == null || !setting.getOwnerId().equals(this.poId) || !key.equals(setting.getName())) continue;
            ipInfo = setting.getValue();
            break;
        }
        return ipInfo;
    }

    private Map<String, Object> constructParamsMap(String info) {
        HashMap<String, Object> cfg = new HashMap<String, Object>();
        cfg.put("hostName", this.hostName);
        if (VerifyUtil.isEmpty((String)info)) {
            cfg.put("dhcpEnabled4", true);
            cfg.put("autoDns4", true);
            cfg.put("dhcpEnabled6", true);
            cfg.put("autoDns6", true);
            return cfg;
        }
        JSONObject ipInfoJson = JSONObject.fromObject((Object)info);
        boolean dhcpEnabled4 = ipInfoJson.getBoolean("dhcpEnabled4");
        cfg.put("dhcpEnabled4", dhcpEnabled4);
        if (!dhcpEnabled4) {
            cfg.put("ip", ipInfoJson.getString("ip"));
            cfg.put("mask", ipInfoJson.getString("netmask"));
            ArrayList<String> gwList = new ArrayList<String>();
            gwList.add(ipInfoJson.getString("gateway"));
            cfg.put("gwList", gwList);
        }
        boolean autoDns4 = ipInfoJson.getBoolean("autoDns4");
        cfg.put("autoDns4", autoDns4);
        if (!autoDns4) {
            ArrayList<String> dnsList = new ArrayList<String>();
            dnsList.add(ipInfoJson.getString("setDns"));
            String addDns = ipInfoJson.getString("addDns");
            if (!VerifyUtil.isEmpty((String)addDns)) {
                dnsList.add(addDns);
            }
            cfg.put("dnsList", dnsList);
        }
        boolean dhcpEnabled6 = ipInfoJson.getBoolean("dhcpEnabled6");
        cfg.put("dhcpEnabled6", dhcpEnabled6);
        if (!dhcpEnabled6) {
            cfg.put("ip6s", ipInfoJson.getString("ip6s"));
            ArrayList<String> gwList6 = new ArrayList<String>();
            gwList6.add(ipInfoJson.getString("gateway6"));
            cfg.put("gwList6", gwList6);
        }
        boolean autoDns6 = ipInfoJson.getBoolean("autoDns6");
        cfg.put("autoDns6", autoDns6);
        if (!autoDns6) {
            ArrayList<String> dnsList = new ArrayList<String>();
            dnsList.add(ipInfoJson.getString("setDns6"));
            String addDns = ipInfoJson.getString("addDns6");
            if (!VerifyUtil.isEmpty((String)addDns)) {
                dnsList.add(addDns);
            }
            cfg.put("dnsList6", dnsList);
        }
        return cfg;
    }

    private Map<String, String> getNameAndMacMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(this.vcenterUuid);
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(this.vmMoId);
        ArrayOfVirtualDevice array = (ArrayOfVirtualDevice)GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, new String[]{"config.hardware.device"}).get("config.hardware.device");
        if (null == array) {
            return map;
        }
        for (VirtualDevice dev : array.getVirtualDevice()) {
            if (!(dev instanceof VirtualEthernetCard)) continue;
            map.put(dev.getDeviceInfo().getLabel(), ((VirtualEthernetCard)dev).getMacAddress());
        }
        return map;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.vmMoId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getVmNetCardsInfo() {
        return this.vmNetCardsInfo;
    }

    public void setVmNetCardsInfo(String vmNetCardsInfo) {
        this.vmNetCardsInfo = vmNetCardsInfo;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public String getGuestOsType() {
        return this.guestOsType;
    }

    public void setGuestOsType(String guestOsType) {
        this.guestOsType = guestOsType;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getVmxPath() {
        return this.vmxPath;
    }

    public void setVmxPath(String vmxPath) {
        this.vmxPath = vmxPath;
    }

    public int getPreResult() {
        return this.preResult;
    }

    public void setPreResult(int preResult) {
        this.preResult = preResult;
    }
}

