/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CheckRollbackSnapshotSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import java.util.LinkedHashSet;
import java.util.Set;

public class VsCheckRdmRollbackProcessor
extends BaseRecoveryProcessor {
    private Set<RecoveryProcessor> processors;
    private ReplicationConstantDefine.LocalTaskType protectType;

    public VsCheckRdmRollbackProcessor(Set<RecoveryProcessor> rollbackProcessor, RecoveryProcessor parentProcessor, ReplicationConstantDefine.LocalTaskType localTaskType) {
        this.processors = rollbackProcessor;
        this.protectType = localTaskType;
        this.setParentProc(parentProcessor);
    }

    public VsCheckRdmRollbackProcessor() {
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateRollbackProcessor();
        return this.executeSubProcessor(context);
    }

    private void updateRollbackProcessor() {
        LinkedHashSet<CheckRollbackSnapshotSubProcessor> childProcessors = new LinkedHashSet<CheckRollbackSnapshotSubProcessor>();
        for (RecoveryProcessor recoveryProcessor : this.processors) {
            if (!(recoveryProcessor instanceof CreateSnapshotCopySubProcessor)) continue;
            CreateSnapshotCopySubProcessor copySubProcessor = (CreateSnapshotCopySubProcessor)recoveryProcessor;
            CheckRollbackSnapshotSubProcessor processor = new CheckRollbackSnapshotSubProcessor();
            processor.setProcName(this.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(copySubProcessor.getDeviceId());
            processor.setLunId(copySubProcessor.getLunId());
            processor.setSnapshotId(copySubProcessor.getSnapshotId());
            processor.setSnapshotName(copySubProcessor.getSnapshotName());
            processor.setProtectType(Integer.valueOf(this.protectType.getValue()));
            childProcessors.add(processor);
        }
        this.setChildProc(childProcessors);
    }
}

