/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigRDMSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.HostUnresolvedVmfsVolume;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsConfigDataStoreProcessor
extends BaseRecoveryProcessor {
    public static final String STORAGE_ID_WWN_MAP_KEY = "storage_id_wwn_map_config_datastore";
    private static final long serialVersionUID = -1339601725871620800L;
    private static final long WAIT_INTERVAL = 10000L;
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor.";
    private static final String WAIT_DS_READY_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor.ds.timeout";
    private static final Log logger = LogFactory.getInstance(VsConfigDataStoreProcessor.class);
    private String hostMoId;
    private String vcenterUuid;
    private int hostNum;
    private transient RecoveryProcessorContext context;

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    protected boolean execute(RecoveryProcessorContext proContext) {
        boolean lastExcuteSuccess;
        this.context = proContext;
        boolean createResult = false;
        boolean bl = lastExcuteSuccess = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus();
        if (!lastExcuteSuccess) {
            if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
                ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).deleteSubRecoveryProcessor(this.getProcId());
            }
            this.getHostInfo(this.context);
            createResult = this.getCreateSubProcessorResult(this.context);
            if (!createResult) {
                logger.info((Object)"create subprocessors error.", 90160758786988L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithConcurrentSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        recoveryTemplate.process(this.context);
        boolean result = this.calcProcessResultBySubProc();
        if (result && createResult && (result = this.rescanAllHostHBA())) {
            result = this.waitConfigComplete();
        }
        return result && this.deleteFileInDatastore(lastExcuteSuccess);
    }

    private boolean deleteFileInDatastore(boolean lastExcuteSuccess) {
        if (lastExcuteSuccess) {
            logger.info((Object)"VsConfigDataStoreProcessor last status is sucess.");
            return true;
        }
        Set subProcessor = this.getChildProc();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        for (RecoveryProcessor recoveryProcessor : subProcessor) {
            if (!VsConfigDataStoreSubProcessor.class.isInstance(recoveryProcessor)) continue;
            VsConfigDataStoreSubProcessor cfgDsSubProcessor = (VsConfigDataStoreSubProcessor)((Object)VsConfigDataStoreSubProcessor.class.cast(recoveryProcessor));
            this.deleteVswpFile(cfgDsSubProcessor.getOldDataStoreName(), cfgDsSubProcessor.getNewDataStoreName());
        }
        return true;
    }

    private void deleteVswpFile(String oldDataStoreName, String newDataStoreName) {
        List<String> fullVswpfilePaths;
        DataStoreAction dsAction = new DataStoreAction();
        List<VsphereDataStore> datastores = dsAction.queryAllDsWithoutValidate(this.vcenterUuid);
        VsphereDataStore tarVsphereDataStore = null;
        for (VsphereDataStore vsphereDataStore : datastores) {
            if (!vsphereDataStore.getName().equals(newDataStoreName)) continue;
            tarVsphereDataStore = vsphereDataStore;
        }
        if (VerifyUtil.isEmpty(tarVsphereDataStore)) {
            logger.error((Object)("can't find datastore. tarVsphereDataStore name : " + newDataStoreName));
            throw new LegoCheckedException(1073947393L);
        }
        String dataStoreMoId = null;
        if (null != tarVsphereDataStore.getUuid() && tarVsphereDataStore.getUuid().split(":").length >= 2) {
            dataStoreMoId = tarVsphereDataStore.getUuid().split(":")[1];
        }
        if (VerifyUtil.isEmpty(fullVswpfilePaths = dsAction.listDatastoreFiles(this.vcenterUuid, dataStoreMoId, newDataStoreName))) {
            logger.error((Object)("vswp files is empty. datastore name : " + newDataStoreName));
            return;
        }
        Set<String> deletePaths = this.getDeletePaths(fullVswpfilePaths, oldDataStoreName, newDataStoreName);
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        String dcMoId = (String)settings.get("VSDATACENTERID");
        if (VerifyUtil.isEmpty((String)dcMoId)) {
            logger.error((Object)"can't find dcMoId. ");
            throw new LegoCheckedException(1073947393L);
        }
        dsAction.deleteDatastoreFiles(this.vcenterUuid, dataStoreMoId, deletePaths);
        logger.debug((Object)"delete file success .");
    }

    private Set<String> getDeletePaths(List<String> fullFilePaths, String oldDataStoreName, String newDataStoreName) {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        HashSet<String> vmFolders = new HashSet<String>();
        for (ProtectObject po : pg.getPolist()) {
            String vmxPath = (String)po.getProps().get("VMPATH");
            if (VerifyUtil.isEmpty((String)vmxPath)) {
                logger.error((Object)("can't find vmx path. po name :" + po.getName()));
                throw new LegoCheckedException(1073947393L);
            }
            vmxPath = vmxPath.replace(oldDataStoreName, newDataStoreName);
            vmFolders.add(vmxPath.substring(0, vmxPath.indexOf("/")));
        }
        logger.debug((Object)("vmFolders : " + vmFolders));
        HashSet<String> deletePaths = new HashSet<String>();
        for (String fullFilePath : fullFilePaths) {
            for (String vmFolder : vmFolders) {
                if (!fullFilePath.startsWith(vmFolder) || !fullFilePath.endsWith(".vswp")) continue;
                deletePaths.add(fullFilePath);
            }
        }
        logger.debug((Object)("deletePaths : " + deletePaths));
        return deletePaths;
    }

    private boolean getCreateSubProcessorResult(RecoveryProcessorContext proContext) {
        boolean createResult = false;
        try {
            ProtectGroup pg = proContext.getProtectGroup();
            if (2 == pg.getTemplate().getType() || 19 == pg.getTemplate().getType()) {
                if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
                    createResult = this.createSnapshotRollbackSubProcessors(proContext);
                } else if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
                    createResult = this.createSnapshotDrillingSubProcessors(proContext);
                }
            } else if (30 == pg.getTemplate().getType() || 31 == pg.getTemplate().getType() || 32 == pg.getTemplate().getType()) {
                if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
                    createResult = this.createSnapshotRollbackSubProcessors(proContext);
                } else if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
                    createResult = this.createSubProcessors(proContext);
                } else if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
                    createResult = this.createSnapshotDrillingSubProcessors(proContext);
                }
            } else {
                createResult = this.createSubProcessors(proContext);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create subprocessor error.", (Throwable)e, 90160758786988L);
            this.updateProcessDetail(e);
        }
        catch (Exception e) {
            logger.error((Object)("create subprocessor error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786988L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor.query.fail", null);
        }
        return createResult;
    }

    private boolean waitConfigComplete() {
        boolean ret = false;
        try {
            for (int i = 0; i < 30; ++i) {
                Thread.sleep(10000L);
                List<VsphereDataStore> dsList = this.getDsList();
                if (dsList.isEmpty()) {
                    logger.error((Object)"waiting for datastore ready error,dsList is empty");
                    continue;
                }
                if (this.isAllDsReady(dsList)) {
                    logger.info((Object)"All datastores are ready", 90160758786988L);
                    ret = true;
                    break;
                }
                logger.info((Object)"All datastores are not ready,will sleep ten seconds", 90160758786988L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("waiting for creating datastore complete failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        if (!ret) {
            logger.error((Object)"wait for datastore ready failed", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(WAIT_DS_READY_TIMEOUT, null);
        }
        return ret;
    }

    private List<VsphereDataStore> getDsList() {
        HashSet<String> urlSet = new HashSet<String>();
        for (RecoveryProcessor proc : this.getChildProc()) {
            if (!(proc instanceof VsConfigDataStoreSubProcessor)) continue;
            VsConfigDataStoreSubProcessor subProc = (VsConfigDataStoreSubProcessor)proc;
            urlSet.add(subProc.getNewDataStoreUrl());
        }
        DataStoreAction action = new DataStoreAction();
        return action.getDsByUrl(this.vcenterUuid, urlSet);
    }

    private boolean isAllDsReady(List<VsphereDataStore> dsList) {
        boolean flag = true;
        DataStoreAction action = new DataStoreAction();
        for (VsphereDataStore ds : dsList) {
            String dsMoId = ds.getUuid().split(":")[1];
            boolean isMounted = action.isMountedToAllHosts(this.vcenterUuid, dsMoId, this.hostNum);
            if (isMounted) continue;
            logger.info((Object)(" datastore is not ready:dsName=" + ds.getName()), 90160758786989L);
            flag = false;
            break;
        }
        return flag;
    }

    private boolean rescanAllHostHBA() {
        HostSystemAction action = new HostSystemAction();
        Set<String> hostMoIds = action.getAllHostMoIdsFromCluster(this.vcenterUuid, this.hostMoId);
        this.hostNum = hostMoIds.size();
        try {
            for (String hostMo : hostMoIds) {
                if (hostMo.equals(this.hostMoId)) continue;
                action.rescanVmfs(this.vcenterUuid, hostMo);
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)"After config  datastore, Scanning HBA RecoveryProcessor failed", 90160758784001L);
            return false;
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)("After config  datastore, Scanning HBA RecoveryProcessor failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return false;
        }
        return true;
    }

    private void getHostInfo(RecoveryProcessorContext proContext) {
        logger.debug((Object)"getHostInfo start");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            ProtectGroup pg = proContext.getProtectGroup();
            this.setVcenterUuid(pg.getPoProviderSN());
            String tempStr = (String)pg.getProps().get("pg_topo");
            JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonArray.get(0));
            JSONArray hostArray = JSONArray.fromObject((Object)jsonObj.get("hosts"));
            JSONObject hostObj = JSONObject.fromObject((Object)hostArray.get(0));
            this.setHostMoId(hostObj.getString("uuid").split(":")[1]);
        } else {
            Map hostLunMap = (Map)proContext.getAttribute("lunEsxMap");
            HashSet hosts = new HashSet();
            for (Map.Entry entry : hostLunMap.entrySet()) {
                hosts.add(entry.getValue());
            }
            if (!hosts.iterator().hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            HostSystem host = (HostSystem)hosts.iterator().next();
            this.setHostMoId(host.getUuid().split(":")[1]);
            this.setVcenterUuid(host.getParentMo().getUuid());
        }
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority() {
        ArrayList<IProcessor> dataStoreProcessors;
        logger.debug((Object)"getSubProcessByPriority start");
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        ArrayList<VsConfigDataStoreSubProcessor> configDataStoreProcessors = new ArrayList<VsConfigDataStoreSubProcessor>();
        ArrayList<VsConfigRDMSubProcessor> configRDMStoreProcessors = new ArrayList<VsConfigRDMSubProcessor>();
        for (RecoveryProcessor process : childProcessor) {
            if (process instanceof VsConfigDataStoreSubProcessor) {
                configDataStoreProcessors.add((VsConfigDataStoreSubProcessor)process);
                continue;
            }
            if (!(process instanceof VsConfigRDMSubProcessor)) continue;
            configRDMStoreProcessors.add((VsConfigRDMSubProcessor)process);
        }
        int priorityIndex = 1;
        if (!VerifyUtil.isEmpty(configDataStoreProcessors)) {
            for (IProcessor iProcessor : configDataStoreProcessors) {
                dataStoreProcessors = new ArrayList<IProcessor>();
                dataStoreProcessors.add(iProcessor);
                processorsWithPriority.put(priorityIndex++, dataStoreProcessors);
            }
        }
        if (!VerifyUtil.isEmpty(configRDMStoreProcessors)) {
            for (IProcessor iProcessor : configRDMStoreProcessors) {
                dataStoreProcessors = new ArrayList();
                dataStoreProcessors.add(iProcessor);
                processorsWithPriority.put(priorityIndex++, dataStoreProcessors);
            }
        }
        return processorsWithPriority;
    }

    private boolean createSnapshotRollbackSubProcessors(RecoveryProcessorContext proContext) {
        ProtectGroup pg = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(proContext);
        Set pos = pg.getPolist();
        HashMap<String, Set<String>> dataStoreLunMap = new HashMap<String, Set<String>>();
        HashMap<String, String> dataStoreUrlAndNameMap = new HashMap<String, String>();
        HashMap<String, String> lunIdAndWwn = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            for (ProtectObjectStorageInfo hostStorage : po.getUsedStorageResourceSet()) {
                if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue() != hostStorage.getStorageType().intValue()) {
                    logger.info((Object)("storage is not vmfs" + hostStorage.getId()), 90160758786988L);
                    continue;
                }
                lunIdAndWwn.put(hostStorage.getResourceId(), hostStorage.getLunWWN());
                dataStoreUrlAndNameMap.put(hostStorage.getMountPoint(), hostStorage.getDeviceName());
                if (dataStoreLunMap.containsKey(hostStorage.getMountPoint())) {
                    ((Set)dataStoreLunMap.get(hostStorage.getMountPoint())).add(hostStorage.getLunWWN());
                    continue;
                }
                HashSet<String> lunIds = new HashSet<String>();
                lunIds.add(hostStorage.getLunWWN());
                dataStoreLunMap.put(hostStorage.getMountPoint(), lunIds);
            }
        }
        this.getContextRef().setAttribute(STORAGE_ID_WWN_MAP_KEY, lunIdAndWwn);
        logger.info((Object)("datastore Lun Map=" + dataStoreLunMap), 90160758786988L);
        logger.info((Object)("dataStoreUrlAndNameMap=" + dataStoreUrlAndNameMap), 90160758786988L);
        Set<RecoveryProcessor> subProcessors = this.generateDataStoreSubProcessorForRollBack(dataStoreLunMap, dataStoreUrlAndNameMap);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Set<RecoveryProcessor> generateDataStoreSubProcessorForRollBack(Map<String, Set<String>> dataStoreLunMap, Map<String, String> dataStoreUrlAndNameMap) {
        List<HostUnresolvedVmfsVolume> vols = this.getUnresolvedVmfsVolume();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (Map.Entry<String, String> dsInfo : dataStoreUrlAndNameMap.entrySet()) {
            VsConfigDataStoreSubProcessor subProcessor = new VsConfigDataStoreSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setOldDataStoreUrl(dsInfo.getKey());
            subProcessor.setOldDataStoreName(dsInfo.getValue());
            subProcessor.setHostMoId(this.hostMoId);
            subProcessor.setVcenterUuid(this.vcenterUuid);
            subProcessor.setVmfsVolums(vols);
            subProcessors.add((RecoveryProcessor)subProcessor);
            Set<String> wwns = dataStoreLunMap.get(dsInfo.getKey());
            Map<String, String> lunWwnsMapsnapshotWwn = this.getRollBackLunWwnMap(wwns);
            subProcessor.setLunWwnsMapsnapshotWwn(lunWwnsMapsnapshotWwn);
        }
        return subProcessors;
    }

    private Map<String, String> getRollBackLunWwnMap(Set<String> wwns) {
        HashMap<String, String> lunWwnsMapsnapshotWwn = new HashMap<String, String>();
        if (null != wwns && !wwns.isEmpty()) {
            for (String wwn : wwns) {
                lunWwnsMapsnapshotWwn.put(wwn, wwn);
            }
        }
        return lunWwnsMapsnapshotWwn;
    }

    private boolean createSnapshotDrillingSubProcessors(RecoveryProcessorContext proContext) {
        RecoveryProcessResult processResult = proContext.getProcessResult();
        Map lastProcResult = processResult.getMappingProcessResults();
        Set pos = proContext.getRecoveryProtectObjects();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        HashMap<String, Set<String>> dataStoreLunMap = new HashMap<String, Set<String>>();
        HashMap<String, String> dataStoreUrlAndNameMap = new HashMap<String, String>();
        List<HostUnresolvedVmfsVolume> vols = this.getUnresolvedVmfsVolume();
        String deviceSn = this.getSnapshotDeviceSn(lastProcResult);
        logger.debug((Object)"lastProcResult=%s, devicesn=%s", new Object[]{lastProcResult, deviceSn});
        for (ProtectObject po : pos) {
            for (ProtectObjectStorageInfo hostStorage : po.getUsedStorageResourceSet()) {
                if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue() != hostStorage.getStorageType().intValue()) {
                    logger.info((Object)("storage is not vmfs" + hostStorage.getId()), 90160758786988L);
                    continue;
                }
                dataStoreUrlAndNameMap.put(hostStorage.getMountPoint(), hostStorage.getDeviceName());
                if (!dataStoreLunMap.containsKey(hostStorage.getMountPoint())) {
                    HashSet lunSet = new HashSet();
                    dataStoreLunMap.put(hostStorage.getMountPoint(), lunSet);
                }
                logger.debug((Object)"id=%s, wwn=%s", new Object[]{hostStorage.getResourceId(), hostStorage.getLunWWN()});
                String lunId = this.getSourceLunId(hostStorage, deviceSn);
                ((Set)dataStoreLunMap.get(hostStorage.getMountPoint())).add(lunId);
            }
        }
        logger.info((Object)("datastore Lun Map=" + dataStoreLunMap), 90160758786988L);
        logger.info((Object)("dataStoreUrlAndNameMap=" + dataStoreUrlAndNameMap), 90160758786988L);
        Map<String, String> lunIdAndWwnMap = this.generateLunMap(dataStoreLunMap, deviceSn);
        this.getContextRef().setAttribute(STORAGE_ID_WWN_MAP_KEY, lunIdAndWwnMap);
        logger.info((Object)("lunIdAndWwnMap=" + lunIdAndWwnMap), 90160758786988L);
        Map<String, RecoveryProcessor> subDataStoreProcessorsMap = this.generateDataStoreSubProcessor(dataStoreLunMap, dataStoreUrlAndNameMap, lunIdAndWwnMap, lastProcResult, vols);
        subProcessors.addAll(subDataStoreProcessorsMap.values());
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private String getSnapshotDeviceSn(Map<String, Boolean> lastProcResult) {
        logger.debug((Object)"getSnapshotDeviceSn start");
        String deviceId = "";
        for (Map.Entry<String, Boolean> entry : lastProcResult.entrySet()) {
            String key = entry.getKey();
            String[] preProps = key.split(":");
            if (preProps.length <= 1) continue;
            String preKey = preProps[1];
            int index = 0;
            String[] props = preKey.split(";");
            deviceId = props[index].split("=")[1];
            if (VerifyUtil.isEmpty((String)deviceId)) continue;
            break;
        }
        return deviceId;
    }

    private String getSourceLunId(ProtectObjectStorageInfo hostStorage, String tgtDevSn) {
        logger.debug((Object)"getSourceLunId start");
        String result = hostStorage.getResourceId();
        List luns = new ArrayList();
        if (!VerifyUtil.isEmpty((String)hostStorage.getLunWWN())) {
            luns = CommonDAOLocator.getMoDao().getMoList(Lun.class, "wwn", (Object)hostStorage.getLunWWN());
        }
        if (!VerifyUtil.isEmpty(luns)) {
            block0: for (Lun lun : luns) {
                if (tgtDevSn.equals(lun.getDevSn())) {
                    result = lun.getLunId();
                    break;
                }
                List pairs = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunId(lun.getDevSn(), Arrays.asList(lun.getResourceId()), false, Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
                if (VerifyUtil.isEmpty((Collection)pairs)) continue;
                for (ReplicationPair replicationPair : pairs) {
                    List tgtLuns = replicationPair.getRepTgtLuns();
                    if (!VerifyUtil.isEmpty((Collection)tgtLuns)) {
                        Iterator iterator = tgtLuns.iterator();
                        if (!iterator.hasNext()) continue;
                        ReplicationTargetLun tgtLun = (ReplicationTargetLun)iterator.next();
                        if (tgtLun.getTgtDevSN().equals(tgtDevSn)) {
                            result = replicationPair.getTgtLunId();
                            continue;
                        }
                        result = this.getSrcLunIdByTargetLun(tgtLun, tgtDevSn);
                        continue;
                    }
                    if (!replicationPair.getSrcDevSN().equals(tgtDevSn)) continue;
                    result = replicationPair.getSrcLunId();
                    continue block0;
                }
            }
        }
        return result;
    }

    private String getSrcLunIdByTargetLun(ReplicationTargetLun tgtLun, String tgtDevSn) {
        String lunId = tgtLun.getTgtLunId();
        String devSn = tgtLun.getTgtDevSN();
        IStorageResourceService storageService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        Lun lun = (Lun)storageService.getStorageResource(devSn, lunId, Lun.class);
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lun.getWwn()});
        for (StorageResource resource : resources) {
            if (!resource.getDevSn().equals(tgtDevSn)) continue;
            return resource.getResourceId();
        }
        return tgtLun.getTgtLunId();
    }

    private boolean createSubProcessors(RecoveryProcessorContext proContext) {
        RecoveryProcessResult processResult = proContext.getProcessResult();
        Map lastProcResult = processResult.getMappingProcessResults();
        RecoveryPlan recoveryPlan = proContext.getRecoveryPlan();
        Set pos = proContext.getProtectGroup().getPolist();
        List<RelicaStorageInfo> replicaStorages = this.getAllRelicaStorageInfoByRecoveryPlan(recoveryPlan);
        HashSet<Object> subProcessors = new HashSet<Object>();
        HashMap<String, RecoveryProcessor> subRDMProcessorsMap = new HashMap<String, RecoveryProcessor>();
        HashMap<String, Set<String>> dataStoreLunMap = new HashMap<String, Set<String>>();
        HashMap<String, String> dataStoreUrlAndNameMap = new HashMap<String, String>();
        List<HostUnresolvedVmfsVolume> vols = this.getUnresolvedVmfsVolume();
        String deviceId = "";
        for (ProtectObject po : pos) {
            for (ProtectObjectStorageInfo hostStorage : po.getUsedStorageResourceSet()) {
                if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue() == hostStorage.getStorageType().intValue()) {
                    dataStoreUrlAndNameMap.put(hostStorage.getMountPoint(), hostStorage.getDeviceName());
                    deviceId = this.generateDataStoreLunMap(dataStoreLunMap, hostStorage, replicaStorages);
                    continue;
                }
                if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue() == hostStorage.getStorageType().intValue() || DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue() == hostStorage.getStorageType().intValue()) {
                    this.generateRDMSubProcessor(hostStorage, replicaStorages, lastProcResult, subRDMProcessorsMap);
                    continue;
                }
                logger.info((Object)("storage is not vmfs" + hostStorage.getId()), 90160758786988L);
            }
        }
        logger.info((Object)("datastore Lun Map=" + dataStoreLunMap), 90160758786988L);
        logger.info((Object)("dataStoreUrlAndNameMap=" + dataStoreUrlAndNameMap), 90160758786988L);
        Map<String, String> lunIdAndWwnMap = this.generateLunMap(dataStoreLunMap, deviceId);
        this.getContextRef().setAttribute(STORAGE_ID_WWN_MAP_KEY, lunIdAndWwnMap);
        logger.info((Object)("lunIdAndWwnMap=" + lunIdAndWwnMap), 90160758786988L);
        Map<String, RecoveryProcessor> subDataStoreProcessorsMap = this.generateDataStoreSubProcessor(dataStoreLunMap, dataStoreUrlAndNameMap, lunIdAndWwnMap, lastProcResult, vols);
        subProcessors.addAll(subDataStoreProcessorsMap.values());
        subProcessors.addAll(subRDMProcessorsMap.values());
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Map<String, String> generateLunMap(Map<String, Set<String>> dataStoreLunMap, String deviceId) {
        List luns;
        logger.debug((Object)"generateLunMap start");
        HashMap<String, String> lunIdAndWwnMap = new HashMap<String, String>();
        ArrayList<String> lunLists = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> result : dataStoreLunMap.entrySet()) {
            Set<String> lunIds = result.getValue();
            lunLists.addAll(lunIds);
        }
        if (!VerifyUtil.isEmpty(lunLists) && !VerifyUtil.isEmpty((Collection)(luns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunsByDeviceSnAndLunIds(deviceId, lunLists)))) {
            for (Lun lun : luns) {
                lunIdAndWwnMap.put(lun.getLunId(), lun.getWwn());
            }
        }
        return lunIdAndWwnMap;
    }

    private String generateDataStoreLunMap(Map<String, Set<String>> dataStoreLunMap, ProtectObjectStorageInfo hostStorage, List<RelicaStorageInfo> replicaStorages) {
        logger.debug((Object)"generateDataStoreLunMap start");
        String dataStoreUrl = hostStorage.getMountPoint();
        String lunId = "";
        String deviceId = "";
        String hostStorSn = hostStorage.getResourceProviderSN();
        String hostStorId = hostStorage.getResourceId();
        String hostStorWwn = hostStorage.getLunWWN();
        for (RelicaStorageInfo relicaStorage : replicaStorages) {
            String repliStorSn = relicaStorage.getSrcStorageProviderSN();
            String repliStorId = relicaStorage.getSrcStorageId();
            String repliStorWwn = relicaStorage.getProtectObjectStorageWwn();
            if (hostStorSn.equals(repliStorSn) && hostStorId.equals(repliStorId) || !VerifyUtil.isEmpty((String)hostStorWwn) && hostStorWwn.equalsIgnoreCase(repliStorWwn)) {
                deviceId = relicaStorage.getStorageProviderSN();
                lunId = relicaStorage.getStorageId();
            }
            if (VerifyUtil.isEmpty((String)lunId)) continue;
            if (dataStoreLunMap.containsKey(dataStoreUrl)) {
                dataStoreLunMap.get(dataStoreUrl).add(lunId);
                continue;
            }
            HashSet<String> lunIds = new HashSet<String>();
            lunIds.add(lunId);
            dataStoreLunMap.put(dataStoreUrl, lunIds);
        }
        return deviceId;
    }

    private List<HostUnresolvedVmfsVolume> getUnresolvedVmfsVolume() {
        logger.debug((Object)"getUnresolvedVmfsVolume start");
        HostSystemAction action = new HostSystemAction();
        List<HostUnresolvedVmfsVolume> vols = new ArrayList<HostUnresolvedVmfsVolume>();
        if (!VerifyUtil.isEmpty((String)this.hostMoId)) {
            vols = action.queryUnresolvedVmfsVolume(this.vcenterUuid, this.hostMoId);
        }
        return vols;
    }

    protected String generateResultKey() {
        logger.debug((Object)"generateResultKey start");
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private List<RelicaStorageInfo> getAllRelicaStorageInfoByRecoveryPlan(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"getAllRelicaStorageInfoByRecoveryPlan start");
        ArrayList<RelicaStorageInfo> result = new ArrayList<RelicaStorageInfo>();
        Set pgs = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : pgs) {
            for (ProtectGroupReplica pgr : pg.getReplicaList()) {
                if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)pgr)) continue;
                this.dealCommon(result, pgr, recoveryPlan);
            }
        }
        return result;
    }

    private void dealCommon(List<RelicaStorageInfo> result, ProtectGroupReplica pgr, RecoveryPlan recoveryPlan) {
        logger.debug((Object)"dealCommon start");
        for (ProtectObjectReplica por : pgr.getReplicas()) {
            Set relicaStorageInfos = por.getStorageInfos();
            for (RelicaStorageInfo storageInfo : relicaStorageInfos) {
                if (!VsphereRecoveryUtils.getInstance().isDeviceInSite(storageInfo.getStorageProviderSN(), (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID"))) continue;
                result.add(storageInfo);
            }
        }
    }

    private Map<String, RecoveryProcessor> generateDataStoreSubProcessor(Map<String, Set<String>> dataStoreLunWwnMap, Map<String, String> dataStoreUrlAndNameMap, Map<String, String> lunIdAndWwn, Map<String, Boolean> lastProcResult, List<HostUnresolvedVmfsVolume> vols) {
        logger.debug((Object)"dealgenerateDataStoreSubProcessorCommon start");
        HashMap<String, RecoveryProcessor> subDataStoreProcessorsMap = new HashMap<String, RecoveryProcessor>();
        for (Map.Entry<String, Set<String>> result : dataStoreLunWwnMap.entrySet()) {
            Set<String> lunIds = result.getValue();
            VsConfigDataStoreSubProcessor subProcessor = new VsConfigDataStoreSubProcessor();
            subProcessor.setProcName(subProcessor.getName());
            subProcessor.setProcType(this.getProcType());
            subProcessor.setPlanId(this.getPlanId());
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setOldDataStoreName(dataStoreUrlAndNameMap.get(result.getKey()));
            subProcessor.setOldDataStoreUrl(result.getKey());
            subProcessor.setHostMoId(this.hostMoId);
            subProcessor.setLunWwnsMapsnapshotWwn(new HashMap<String, String>());
            subProcessor.setVmfsVolums(vols);
            subProcessor.setVcenterUuid(this.vcenterUuid);
            this.updateDataStoreSubProcessorSnapInfo(lastProcResult, subProcessor, lunIds, lunIdAndWwn);
            subDataStoreProcessorsMap.put(result.getKey(), (RecoveryProcessor)subProcessor);
        }
        return subDataStoreProcessorsMap;
    }

    private void generateRDMSubProcessor(ProtectObjectStorageInfo hostStorage, List<RelicaStorageInfo> rplicaStorages, Map<String, Boolean> lastProcResult, Map<String, RecoveryProcessor> subProcessorsMap) {
        logger.debug((Object)"generateRDMSubProcessor start");
        String deviceId = "";
        String lunId = "";
        String lunWwn = "";
        for (RelicaStorageInfo relicaStorage : rplicaStorages) {
            if (hostStorage.getResourceProviderSN().equals(relicaStorage.getSrcStorageProviderSN()) && hostStorage.getResourceId().equals(relicaStorage.getSrcStorageId()) || !VerifyUtil.isEmpty((String)hostStorage.getLunWWN()) && hostStorage.getLunWWN().equalsIgnoreCase(relicaStorage.getProtectObjectStorageWwn())) {
                deviceId = relicaStorage.getStorageProviderSN();
                lunId = relicaStorage.getStorageId();
                Lun lun = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunBySnAndLunId(deviceId, lunId);
                lunWwn = lun.getWwn();
            }
            if (VerifyUtil.isEmpty((String)lunWwn) || subProcessorsMap.containsKey(lunWwn)) continue;
            VsConfigRDMSubProcessor subProcessor = this.initVsConfigRDMSubProcessor(hostStorage);
            this.updateRDMSubProcessorSnapInfo(lastProcResult, subProcessor, deviceId, lunId);
            subProcessorsMap.put(lunWwn, (RecoveryProcessor)subProcessor);
        }
    }

    private VsConfigRDMSubProcessor initVsConfigRDMSubProcessor(ProtectObjectStorageInfo hostStorage) {
        VsConfigRDMSubProcessor subProcessor = new VsConfigRDMSubProcessor();
        subProcessor.setProcName(subProcessor.getName());
        subProcessor.setProcType(this.getProcType());
        subProcessor.setPlanId(this.getPlanId());
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        subProcessor.setOldDataStoreUrl(hostStorage.getMountPoint());
        subProcessor.setHostMoId(this.hostMoId);
        subProcessor.setDiskFileName(hostStorage.getDeviceName());
        subProcessor.setDiskType(hostStorage.getStorageType());
        subProcessor.setVcenterUuid(this.vcenterUuid);
        return subProcessor;
    }

    private void updateDataStoreSubProcessorSnapInfo(Map<String, Boolean> lastProcResult, VsConfigDataStoreSubProcessor proc, Set<String> lunWwns, Map<String, String> lunIdAndWwn) {
        logger.debug((Object)"updateDataStoreSubProcessorSnapInfo start");
        for (Map.Entry<String, Boolean> entry : lastProcResult.entrySet()) {
            String key = entry.getKey();
            String[] preProps = key.split(":");
            if (preProps.length <= 1) continue;
            String preKey = preProps[1];
            boolean preResult = entry.getValue();
            int index = 1;
            String[] props = preKey.split(";");
            String lunId = props[index++].split("=")[1];
            String snapshotId = props[index++].split("=")[1];
            String snapshotWwn = props[index++].split("=")[1];
            if (lunWwns.contains(lunId) && !VerifyUtil.isEmpty((String)snapshotId)) {
                logger.info((Object)("now\uff1a" + lunIdAndWwn.get(lunId) + "   reuslt:" + snapshotWwn));
                proc.getLunWwnsMapsnapshotWwn().put(lunIdAndWwn.get(lunId), snapshotWwn);
                proc.setPreResult(preResult);
            }
            if (proc.getLunWwnsMapsnapshotWwn().size() != lunWwns.size()) continue;
            return;
        }
        if (lastProcResult.isEmpty()) {
            boolean mapped;
            RecoveryPlan plan = this.context.getRecoveryPlan();
            boolean isNas = false;
            Iterator itr = plan.getProtectGroups().iterator();
            if (itr.hasNext()) {
                ProtectGroup pg = (ProtectGroup)itr.next();
                isNas = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)pg);
            }
            if (!isNas && (mapped = this.checkIsLunMapped(proc, lunWwns, lunIdAndWwn)) && proc.getLunWwnsMapsnapshotWwn().size() == lunWwns.size()) {
                proc.setPreResult(true);
                return;
            }
        }
        for (String lunWwn : lunWwns) {
            proc.getLunWwnsMapsnapshotWwn().put(lunWwn, "null");
            proc.setPreResult(false);
        }
        proc.setIsMapping(false);
    }

    private boolean checkIsLunMapped(VsConfigDataStoreSubProcessor proc, Set<String> lunWwns, Map<String, String> lunIdAndWwn) {
        boolean mapped = true;
        StorageLunManagerProxy storageManagerProxy = StorageLunManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Set recoveryTasks = RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)((Collection)this.context.getAttribute("recoveryTasks")), (String)String.valueOf(this.context.getAttribute("DISASTER_SITE_ID")));
        if (recoveryTasks != null && !recoveryTasks.isEmpty()) {
            block0: for (RecoveryTask task : recoveryTasks) {
                if (!mapped) break;
                String deviceType = recoveryService.getStorageType(task.getTgtDevcieId());
                IStorageLunBaseManager proxy = storageManagerProxy.getStorageLunMgrByDevType(deviceType);
                Map lunAndHostMap = task.getLunAndHostMap();
                Set lunAndHostEntries = lunAndHostMap.entrySet();
                for (Map.Entry entry : lunAndHostEntries) {
                    String slaveLunKey = (String)entry.getKey();
                    String[] strArray = slaveLunKey.split(":");
                    String tgtLunId = strArray[4];
                    if (proxy.isLunMapped(task.getTgtDevcieId(), tgtLunId)) {
                        Lun lun = recoveryService.getTargetLunById(task.getTgtDevcieId(), tgtLunId);
                        if (lunWwns.contains(tgtLunId)) {
                            proc.getLunWwnsMapsnapshotWwn().put(lunIdAndWwn.get(tgtLunId), lun.getWwn());
                        }
                        logger.debug((Object)("checked mapping true\uff1a" + tgtLunId));
                        continue;
                    }
                    logger.debug((Object)("checked mapping false\uff1a" + tgtLunId));
                    mapped = false;
                    continue block0;
                }
            }
        }
        return mapped;
    }

    private void updateRDMSubProcessorSnapInfo(Map<String, Boolean> lastProcResult, VsConfigRDMSubProcessor proc, String procDeviceId, String procLunId) {
        for (Map.Entry<String, Boolean> entry : lastProcResult.entrySet()) {
            String key = entry.getKey();
            String[] preProps = key.split(":");
            if (preProps.length <= 1) continue;
            String preKey = preProps[1];
            boolean preResult = entry.getValue();
            int index = 0;
            String[] props = preKey.split(";");
            String deviceId = props[index++].split("=")[1];
            String lunId = props[index++].split("=")[1];
            String snapshotId = props[index++].split("=")[1];
            String snapshotWwn = props[index++].split("=")[1];
            if (!procDeviceId.equals(deviceId) || !procLunId.equals(lunId)) continue;
            logger.debug((Object)("snapshotId is " + snapshotId), 90160758786988L);
            proc.setLunOrSnapshotWwn(snapshotWwn);
            proc.setPreResult(preResult);
            return;
        }
        proc.setPreResult(false);
    }

    protected boolean calcProcessResultBySubProc() {
        logger.debug((Object)"calcProcessResultBySubProc start");
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreProcessor.des");
    }
}

