/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.tools.FileHelperEx;
import com.huawei.ism.drm.vsphere.tools.FileHelperMgr;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class VsConfigVMProfileSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1355637619079998831L;
    private static final String AUTO_ANSWER_KEY = "answer.msg.uuid.altered";
    private static final String AUTO_ANSWER_CONFIG = "answer.msg.uuid.altered = \"I copied it\"";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String INCLINED_BAR = "/";
    private static final String MATCH_SNAPSHOT_STR = "snapshot\\d+\\.disk\\d+.fileName = \"";
    private static final Log logger = LogFactory.getInstance(VsConfigVMProfileSubProcessor.class);
    private String poId;
    private String vmName;
    private String vmxPath;
    private String oldvmxPath;
    private String vcUuid;
    private String vcName;
    private String dcName;
    private String dsName;

    public String getDcName() {
        return this.dcName;
    }

    public void setDcName(String dcName) {
        this.dcName = dcName;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVmxPath() {
        return this.vmxPath;
    }

    public void setVmxPath(String vmxPath) {
        this.vmxPath = vmxPath;
    }

    public String getOldvmxPath() {
        return this.oldvmxPath;
    }

    public void setOldvmxPath(String oldvmxPath) {
        this.oldvmxPath = oldvmxPath;
    }

    public String getVcUuid() {
        return this.vcUuid;
    }

    public void setVcUuid(String vcUuid) {
        this.vcUuid = vcUuid;
    }

    public String getVcName() {
        return this.vcName;
    }

    public void setVcName(String vcName) {
        this.vcName = vcName;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getVmName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.vmfile.already.config", new String[0]);
            logger.debug((Object)("vmfile has been config succ, dbName=" + this.getVmName()), 90160758786988L);
            return true;
        }
        ProtectGroup pg = context.getRecoveryPlan().getProtectGroup();
        boolean useNas = RecoveryProcessUtil.isProtectGroupUseNasFileSystem((ProtectGroup)pg);
        if (useNas) {
            return this.configProfileWithNas();
        }
        return this.configProfileWithSan();
    }

    private boolean configProfileWithNas() {
        int lastDotIndex;
        String tempPath;
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.vcUuid);
        this.setVcName(vCenter.getName());
        List processsors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsCreateNasDsSubProcessor.class);
        boolean matched = this.updateNasInfo(processsors);
        if (!matched) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail2", new String[0]);
            return true;
        }
        Map<String, String> dsUrlMap = this.getNasUrlMap(processsors);
        boolean ret = this.modConfigFile(dsUrlMap, vCenter, (tempPath = this.oldvmxPath.substring(0, lastDotIndex = this.oldvmxPath.lastIndexOf("."))) + ".vmsd", true);
        if (!ret) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            logger.error((Object)("modify the vmsd file failed:vmName=" + this.vmName), 90160758786989L);
            return true;
        }
        ret = this.modConfigFile(dsUrlMap, vCenter, this.oldvmxPath, true);
        if (!ret) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean configProfileWithSan() {
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.vcUuid);
        this.setVcName(vCenter.getName());
        List processors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsConfigDataStoreSubProcessor.class);
        boolean matched = this.updateSanInfo(processors);
        if (!matched) {
            logger.info((Object)("modify the vmsd file failed:vmName=" + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail2", new String[0]);
            return true;
        }
        Map<String, String> dsUrlMap = this.getSanUrlMap(processors);
        int lastDotIndex = this.oldvmxPath.lastIndexOf(".");
        String tempPath = this.oldvmxPath.substring(0, lastDotIndex);
        boolean ret = false;
        ret = this.modConfigFile(dsUrlMap, vCenter, tempPath + ".vmsd", false);
        if (!ret) {
            logger.info((Object)("modify the vmsd file failed:vmName=" + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail4", new String[0]);
            return true;
        }
        ret = this.modConfigFile(dsUrlMap, vCenter, this.oldvmxPath, false);
        if (!ret) {
            logger.info((Object)("modify the vmsd file failed:vmName=" + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail4", new String[0]);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private Map<String, String> getNasUrlMap(List<RecoveryProcessor> processors) {
        logger.debug((Object)"getNasUrlMap start");
        HashMap<String, String> map = new HashMap<String, String>();
        for (RecoveryProcessor proc : processors) {
            VsCreateNasDsSubProcessor configDsProc = (VsCreateNasDsSubProcessor)proc;
            String key = configDsProc.getOldDataStoreUrl().substring(5);
            String value = configDsProc.getNewDataStoreUrl().substring(5);
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> getSanUrlMap(List<RecoveryProcessor> processors) {
        logger.debug((Object)"getSanUrlMap start");
        HashMap<String, String> map = new HashMap<String, String>();
        for (RecoveryProcessor proc : processors) {
            VsConfigDataStoreSubProcessor configDsProc = (VsConfigDataStoreSubProcessor)proc;
            String key = configDsProc.getOldDataStoreUrl().substring(5);
            String value = configDsProc.getNewDataStoreUrl().substring(5);
            map.put(key, value);
        }
        return map;
    }

    private boolean updateNasInfo(List<RecoveryProcessor> processors) {
        boolean matched = false;
        for (RecoveryProcessor proc : processors) {
            VsCreateNasDsSubProcessor configDsProc = (VsCreateNasDsSubProcessor)proc;
            if (this.oldvmxPath.indexOf("[" + configDsProc.getDsName() + "]") < 0) continue;
            this.setVmxPath(this.oldvmxPath);
            this.setDsName(configDsProc.getDsName());
            matched = true;
            break;
        }
        return matched;
    }

    private boolean updateSanInfo(List<RecoveryProcessor> processors) {
        boolean matched = false;
        for (RecoveryProcessor proc : processors) {
            VsConfigDataStoreSubProcessor configDsProc = (VsConfigDataStoreSubProcessor)proc;
            if (this.oldvmxPath.indexOf("[" + configDsProc.getOldDataStoreName() + "]") < 0) continue;
            String oldDataStoreName = configDsProc.getOldDataStoreName();
            String regex = oldDataStoreName.replaceAll("\\?", "\\\\?").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
            this.setVmxPath(this.oldvmxPath.replaceFirst(regex, configDsProc.getNewDataStoreName()));
            this.setDsName(configDsProc.getNewDataStoreName());
            matched = true;
            break;
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean modConfigFile(Map<String, String> dsUrlMap, VsphereCenter vCenter, String fileFullPath, boolean isNas) {
        boolean bl;
        boolean changedFile;
        AtomicBoolean replaceDsUrlSuccess;
        String url;
        String tempFilePath;
        String tmpFilePath;
        FileHelperEx fh;
        String filePath;
        String fullFileName;
        block23: {
            block25: {
                Map<String, String> snapFileKeyAndScsiNum;
                boolean isVmxFile;
                block24: {
                    block22: {
                        logger.info((Object)("start modify config file:dsName=" + this.dsName + " dsUrlMap=" + dsUrlMap));
                        int lastIndex = fileFullPath.lastIndexOf(INCLINED_BAR);
                        fullFileName = fileFullPath.substring(lastIndex + 1);
                        int lastDotIndex = fullFileName.lastIndexOf(".");
                        String fileName = fullFileName.substring(0, lastDotIndex);
                        String filePostfix = fullFileName.substring(lastDotIndex + 1);
                        String folderName = fileName;
                        String tempFileName = fileName + "_temp." + filePostfix + System.nanoTime();
                        filePath = null;
                        NeMgrProtocolExtend neMgr = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByMoId(vCenter.getMoId());
                        if (null == neMgr) {
                            logger.error((Object)"NeMgrProtocolExtend Not Found.", 90160758786989L);
                            return false;
                        }
                        String ip = neMgr.getNetworkIpAddress();
                        String userName = neMgr.getNetworkUserName();
                        String passWd = neMgr.getNetworkPassword();
                        String port = (String)neMgr.getExtendParams().get("port");
                        fh = null;
                        tmpFilePath = VsphereCommUtil.getTempFilePath();
                        tempFilePath = tmpFilePath + tempFileName;
                        isVmxFile = "vmx".equals(filePostfix);
                        url = this.makeUrl(fullFileName, folderName, ip, port);
                        fullFileName = fullFileName + System.nanoTime();
                        filePath = tmpFilePath + fullFileName;
                        fh = FileHelperMgr.getInstance().getFileHelper(ip, port, userName, passWd);
                        boolean opStatus = VsphereCommUtil.getFileWithRetry(tempFileName, fh, url);
                        if (opStatus) break block22;
                        logger.error((Object)"get file failed.");
                        this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail4", new String[0]);
                        boolean bl2 = false;
                        if (null != fh) {
                            fh.deleteLocalFile(tempFilePath);
                            fh.deleteLocalFile(filePath);
                        }
                        return bl2;
                    }
                    replaceDsUrlSuccess = new AtomicBoolean(false);
                    changedFile = this.generateConfigFile(dsUrlMap, tempFilePath, filePath, isVmxFile, replaceDsUrlSuccess);
                    if (isNas || replaceDsUrlSuccess.get()) break block23;
                    logger.error((Object)"change file failed, will use scsi NO match .");
                    snapFileKeyAndScsiNum = null;
                    if (!isVmxFile) {
                        snapFileKeyAndScsiNum = this.getSnapFileKeyAndScsiNum(tempFilePath);
                    }
                    if (null != snapFileKeyAndScsiNum && !snapFileKeyAndScsiNum.isEmpty() || isVmxFile) break block24;
                    logger.info((Object)"vm no sanpshot");
                    boolean bl3 = true;
                    if (null != fh) {
                        fh.deleteLocalFile(tempFilePath);
                        fh.deleteLocalFile(filePath);
                    }
                    return bl3;
                }
                boolean replaceDsUrlSucc = this.generateConfigFileByScsiNum(tempFilePath, filePath, isVmxFile, snapFileKeyAndScsiNum);
                if (!replaceDsUrlSucc) break block25;
                logger.info((Object)("use scsi NO match resuilt : " + replaceDsUrlSucc));
                boolean bl4 = fh.putFile(url, tmpFilePath, fullFileName);
                if (null != fh) {
                    fh.deleteLocalFile(tempFilePath);
                    fh.deleteLocalFile(filePath);
                }
                return bl4;
            }
            logger.error((Object)"use scsi NO match failed");
            boolean bl5 = false;
            if (null != fh) {
                fh.deleteLocalFile(tempFilePath);
                fh.deleteLocalFile(filePath);
            }
            return bl5;
        }
        try {
            if (isNas && changedFile || !isNas && replaceDsUrlSuccess.get()) {
                boolean bl6 = fh.putFile(url, tmpFilePath, fullFileName);
                if (null != fh) {
                    fh.deleteLocalFile(tempFilePath);
                    fh.deleteLocalFile(filePath);
                }
                return bl6;
            }
            if (null != fh) {
                fh.deleteLocalFile(tempFilePath);
                fh.deleteLocalFile(filePath);
            }
        }
        catch (IOException e) {
            logger.error((Object)("IOException" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail4", new String[0]);
            bl = false;
            if (null != fh) {
                fh.deleteLocalFile(tempFilePath);
                fh.deleteLocalFile(filePath);
            }
            return bl;
        }
        catch (Exception e2) {
            logger.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)e2)), 90160758786989L);
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigVMProfileSubProcessor.fail4", new String[0]);
            bl = false;
            if (null != fh) {
                fh.deleteLocalFile(tempFilePath);
                fh.deleteLocalFile(filePath);
            }
            return bl;
            {
                catch (Throwable throwable) {
                    if (null != fh) {
                        fh.deleteLocalFile(tempFilePath);
                        fh.deleteLocalFile(filePath);
                    }
                    throw throwable;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getSnapFileKeyAndScsiNum(String srvFilePath) throws IOException {
        SafeBufferedReader in = null;
        FileInputStream fileInputStream = null;
        HashMap<String, String> snapFileKeyAndScsiNum = new HashMap<String, String>();
        try {
            String fileLine;
            fileInputStream = new FileInputStream(srvFilePath);
            in = new SafeBufferedReader((Reader)new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            while ((fileLine = in.readLine()) != null) {
                if (!fileLine.matches("snapshot\\d+\\.disk\\d+.node = \"scsi\\d+:\\d+.+")) continue;
                String[] vmConf = fileLine.split("=");
                String confKey = vmConf[0].trim();
                String confValue = vmConf[1].trim();
                snapFileKeyAndScsiNum.put(confKey.substring(0, confKey.indexOf("node") - 1), confValue.substring(1, confValue.length() - 1) + "." + FILE_NAME_KEY);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(in);
            this.closeInputStream(fileInputStream);
            throw throwable;
        }
        CommonUtil.close((Closeable)in);
        this.closeInputStream(fileInputStream);
        logger.info((Object)("snapFileKeyAndScsiNum : " + snapFileKeyAndScsiNum));
        return snapFileKeyAndScsiNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateConfigFileByScsiNum(String srvFilePath, String localFilePath, boolean isVmxFile, Map<String, String> snapFileKeyAndScsiNum) throws IOException {
        JSONObject scsiNumAndLunWwn = this.getScsiNOAndLunWwn();
        if (null == scsiNumAndLunWwn) {
            logger.error((Object)"can't find scsi No. and lun wwn mapping");
            return false;
        }
        Map<String, String> wwnAndDsUrl = this.getWwnAndDsUrl();
        AtomicBoolean changedFile = new AtomicBoolean(false);
        boolean hasCfgAutoAnswer = false;
        SafeBufferedReader in = null;
        BufferedWriter out = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            boolean isVmxFileAndNoCfgAutoAnswer;
            String fileLine;
            fileInputStream = new FileInputStream(srvFilePath);
            in = new SafeBufferedReader((Reader)new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            fileOutputStream = new FileOutputStream(localFilePath);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            while ((fileLine = in.readLine()) != null) {
                fileLine = this.rebuildLine(fileLine, scsiNumAndLunWwn, snapFileKeyAndScsiNum, wwnAndDsUrl, changedFile);
                out.write(fileLine);
                out.newLine();
                if (!fileLine.contains(AUTO_ANSWER_KEY)) continue;
                hasCfgAutoAnswer = true;
            }
            boolean bl = isVmxFileAndNoCfgAutoAnswer = isVmxFile && !hasCfgAutoAnswer;
            if (isVmxFileAndNoCfgAutoAnswer) {
                out.write(AUTO_ANSWER_CONFIG);
                out.newLine();
            }
            out.flush();
            this.closeBuffer((BufferedReader)in, out);
            this.closeOutputStream(fileOutputStream);
            this.closeInputStream(fileInputStream);
        }
        catch (LegoCheckedException e) {
            try {
                logger.error((Object)("generateConfigFileByScsiNum error." + ExceptionUtil.getErrorMessage((Throwable)e)));
                boolean bl = false;
                this.closeBuffer((BufferedReader)in, out);
                this.closeOutputStream(fileOutputStream);
                this.closeInputStream(fileInputStream);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeBuffer((BufferedReader)in, out);
                this.closeOutputStream(fileOutputStream);
                this.closeInputStream(fileInputStream);
                throw throwable;
            }
        }
        logger.info((Object)("generateConfigFileByScsiNum result : " + changedFile));
        return changedFile.get();
    }

    private String rebuildLine(String fileLine, JSONObject scsiNumAndLunWwn, Map<String, String> snapFileKeyAndScsiNum, Map<String, String> wwnAndDsUrl, AtomicBoolean changedFile) {
        boolean matchScsiOrSwap;
        boolean bl = matchScsiOrSwap = fileLine.matches("scsi\\d+:\\d\\.fileName = \"/vmfs/volumes/.+") || fileLine.startsWith("sched.swap.derivedName = \"/vmfs/volumes/");
        if (matchScsiOrSwap) {
            fileLine = this.getFileLineString(fileLine, scsiNumAndLunWwn, wwnAndDsUrl, changedFile);
        } else if (fileLine.matches("snapshot\\d+\\.disk\\d+.fileName = \".+")) {
            if (fileLine.matches("snapshot\\d+\\.disk\\d+.fileName = \"/vmfs/volumes/.+")) {
                fileLine = this.getExtraFileLineStr(fileLine, scsiNumAndLunWwn, snapFileKeyAndScsiNum, wwnAndDsUrl, changedFile);
            } else {
                changedFile.set(true);
            }
        }
        return fileLine;
    }

    private String getExtraFileLineStr(String fileLine, JSONObject scsiNumAndLunWwn, Map<String, String> snapFileKeyAndScsiNum, Map<String, String> wwnAndDsUrl, AtomicBoolean changedFile) {
        String[] vmConf = fileLine.split("=");
        String confKey = vmConf[0].trim();
        String confValue = vmConf[1].trim();
        String[] confValueArr = confValue.split(INCLINED_BAR);
        if (confValueArr.length < 4) {
            logger.error((Object)"Conf value Incomplete, confValue: %s", new Object[]{confValue});
            throw new LegoCheckedException(1073947393L);
        }
        String snapFileKey = confKey.substring(0, confKey.indexOf(FILE_NAME_KEY) - 1);
        if (snapFileKeyAndScsiNum == null) {
            logger.error((Object)"Map object snapFileKeyAndScsiNum is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String scsiNum = snapFileKeyAndScsiNum.get(snapFileKey);
        if (scsiNum == null) {
            logger.error((Object)"Can't get scsi number, snapFileKey: %s", new Object[]{snapFileKey});
            throw new LegoCheckedException(1073947393L);
        }
        if (!scsiNumAndLunWwn.containsKey((Object)scsiNum)) {
            logger.error((Object)"Can't find scsi No. and lun wwn mapping. confKey: %s", new Object[]{confKey});
            throw new LegoCheckedException(1073947393L);
        }
        Object[] wwns = scsiNumAndLunWwn.getString(scsiNum).split(",");
        String dsUrl = this.getDsUrl((String[])wwns, wwnAndDsUrl);
        if (dsUrl == null) {
            logger.error((Object)"Can't get datastore url. wwn: %s ,and wwnAndDsUrl is: %s", new Object[]{Arrays.toString(wwns), wwnAndDsUrl.toString()});
            throw new LegoCheckedException(1073947393L);
        }
        fileLine = this.getFileLine(confKey, confValueArr, dsUrl);
        changedFile.set(true);
        return fileLine;
    }

    private String getFileLineString(String fileLine, JSONObject scsiNumAndLunWwn, Map<String, String> wwnAndDsUrl, AtomicBoolean changedFile) {
        String[] vmConf = fileLine.split("=");
        String confKey = vmConf[0].trim();
        String confValue = vmConf[1].trim();
        String[] confValueArr = confValue.split(INCLINED_BAR);
        if (confValueArr.length < 4) {
            logger.error((Object)"Conf value Incomplete, confValue: %s", new Object[]{confValue});
            throw new LegoCheckedException(1073947393L);
        }
        if (!scsiNumAndLunWwn.containsKey((Object)confKey)) {
            logger.error((Object)"Can't find scsi No. and lun wwn mapping. confKey: %s", new Object[]{confKey});
            throw new LegoCheckedException(1073947393L);
        }
        String[] wwns = scsiNumAndLunWwn.getString(confKey).split(",");
        String dsUrl = this.getDsUrl(wwns, wwnAndDsUrl);
        if (null == dsUrl) {
            logger.error((Object)"Can't get datastore url. wwn: %s", new Object[]{wwns[0]});
            throw new LegoCheckedException(1073947393L);
        }
        fileLine = this.getFileLine(confKey, confValueArr, dsUrl);
        changedFile.set(true);
        return fileLine;
    }

    private String getDsUrl(String[] wwns, Map<String, String> wwnAndDsUrl) {
        for (int i = 0; i < wwns.length; ++i) {
            String tempDsUrl = wwnAndDsUrl.get(wwns[i]);
            if (null == tempDsUrl || tempDsUrl.trim().isEmpty()) continue;
            return tempDsUrl;
        }
        return null;
    }

    private String getFileLine(String confKey, String[] confValueArr, String dsUrl) {
        StringBuilder buildLine = new StringBuilder();
        buildLine.append(confKey).append(" = \"/vmfs/volumes/").append(dsUrl, 19, dsUrl.length() - 1);
        for (int i = 4; i < confValueArr.length; ++i) {
            buildLine.append(INCLINED_BAR).append(confValueArr[i]);
        }
        return buildLine.toString();
    }

    private JSONObject getScsiNOAndLunWwn() {
        String scsiConf = (String)this.getProps().get(this.vmName + "_scsi_number");
        if (null == scsiConf || scsiConf.trim().isEmpty()) {
            logger.error((Object)"can't find vm scsi conf");
            return null;
        }
        HashMap<String, String> srcAndSlaveMapping = new HashMap<String, String>();
        HashMap<String, String> srcSnLunIdAndWwn = new HashMap<String, String>();
        HashMap<String, String> slaveSnLunIdAndWwn = new HashMap<String, String>();
        VsphereCommUtil.initMasterAndSlaveMap(srcAndSlaveMapping, srcSnLunIdAndWwn, slaveSnLunIdAndWwn, this.getContextRef().getProtectGroup());
        JSONObject newScsiNOAndLunWwn = new JSONObject();
        JSONObject scsiNOAndLunWwn = JSONObject.fromObject((Object)scsiConf);
        Set entries = scsiNOAndLunWwn.entrySet();
        for (Map.Entry entry : entries) {
            String masterWwn = this.convertMasterWwn((String)entry.getValue(), srcSnLunIdAndWwn, slaveSnLunIdAndWwn, srcAndSlaveMapping);
            newScsiNOAndLunWwn.put(entry.getKey(), (Object)masterWwn);
        }
        logger.info((Object)("newScsiNOAndLunWwn : " + newScsiNOAndLunWwn));
        return newScsiNOAndLunWwn;
    }

    private String convertMasterWwn(String value, Map<String, String> srcSnLunIdAndWwn, Map<String, String> slaveSnLunIdAndWwn, Map<String, String> srcAndSlaveMapping) {
        String[] wwns;
        if (VerifyUtil.isEmpty((String)value)) {
            logger.info((Object)"scsiNOAndLunWwn is null.");
            return null;
        }
        for (String wwn : wwns = value.split(",")) {
            if (srcSnLunIdAndWwn.containsValue(wwn)) {
                return value;
            }
            if (!slaveSnLunIdAndWwn.containsValue(wwn)) continue;
            this.getMasterWwnBySlaveWwn(wwn, srcSnLunIdAndWwn, slaveSnLunIdAndWwn, srcAndSlaveMapping);
        }
        return null;
    }

    private String getMasterWwnBySlaveWwn(String wwn, Map<String, String> srcSnLunIdAndWwn, Map<String, String> slaveSnLunIdAndWwn, Map<String, String> srcAndSlaveMapping) {
        Set<Map.Entry<String, String>> entries = slaveSnLunIdAndWwn.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!wwn.equals(entry.getValue())) continue;
            for (Map.Entry<String, String> srcAndSlave : srcAndSlaveMapping.entrySet()) {
                if (!srcAndSlave.getValue().equals(entry.getKey())) continue;
                return srcSnLunIdAndWwn.get(srcAndSlave.getKey());
            }
        }
        return null;
    }

    private Map<String, String> getWwnAndDsUrl() {
        HashMap<String, String> wwnAndDsUrl = new HashMap<String, String>();
        List mountprocessors = this.getRecoveryProcessors(this.getContextRef().getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), VsConfigDataStoreSubProcessor.class);
        for (RecoveryProcessor processor : mountprocessors) {
            VsConfigDataStoreSubProcessor mountProcessor = (VsConfigDataStoreSubProcessor)((Object)VsConfigDataStoreSubProcessor.class.cast(processor));
            String wwns = (String)mountProcessor.getProps().get("mount_lun_wwns");
            if (null == wwns || "null".equals(wwns)) {
                logger.error((Object)"can't get wwns");
                continue;
            }
            String dsUrl = mountProcessor.getNewDataStoreUrl();
            String[] wwnsArr = wwns.split(",");
            for (int i = 0; i < wwnsArr.length; ++i) {
                wwnAndDsUrl.put(wwnsArr[i], dsUrl);
            }
        }
        return wwnAndDsUrl;
    }

    private String makeUrl(String fullFileName, String folderName, String ip, String port) throws UnsupportedEncodingException {
        String encodeDcName = URLEncoder.encode(this.dcName, "UTF-8");
        String encodeDsName = URLEncoder.encode(this.dsName, "UTF-8");
        String encodeFolderName = URLEncoder.encode(folderName, "UTF-8");
        String encodeFullFileName = URLEncoder.encode(fullFileName, "UTF-8");
        StringBuilder sb = new StringBuilder();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        sb.append("https://").append(ip).append(":").append(port).append("/folder/").append(encodeFolderName).append(INCLINED_BAR).append(encodeFullFileName).append("?dcPath=").append(encodeDcName).append("&dsName=").append(encodeDsName);
        String url = sb.toString();
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateConfigFile(Map<String, String> dsUrlMap, String srvFilePath, String localFilePath, boolean isVmxFile, AtomicBoolean replaceDsUrl) throws IOException {
        AtomicInteger replaceCount = new AtomicInteger(0);
        int needReplaceCount = 0;
        AtomicBoolean changedFile = new AtomicBoolean(false);
        boolean hasCfgAutoAnswer = false;
        SafeBufferedReader in = null;
        BufferedWriter out = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String s;
            fileInputStream = new FileInputStream(srvFilePath);
            in = new SafeBufferedReader((Reader)new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            fileOutputStream = new FileOutputStream(localFilePath);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            while ((s = in.readLine()) != null) {
                boolean needReplace;
                boolean bl = needReplace = s.matches("scsi\\d+:\\d\\.fileName = \"/vmfs/volumes/.+") || s.startsWith("sched.swap.derivedName = \"/vmfs/volumes/") || s.matches("snapshot\\d+\\.disk\\d+.fileName = \"/vmfs/volumes/.+");
                if (needReplace) {
                    ++needReplaceCount;
                    s = this.replaceLine(dsUrlMap, replaceCount, changedFile, s);
                }
                out.write(s);
                out.newLine();
                if (!s.contains(AUTO_ANSWER_KEY)) continue;
                hasCfgAutoAnswer = true;
            }
            if (isVmxFile && !hasCfgAutoAnswer) {
                out.write(AUTO_ANSWER_CONFIG);
                out.newLine();
                changedFile.set(true);
            }
            out.flush();
            this.closeBuffer((BufferedReader)in, out);
            this.closeOutputStream(fileOutputStream);
            this.closeInputStream(fileInputStream);
        }
        catch (Throwable throwable) {
            this.closeBuffer((BufferedReader)in, out);
            this.closeOutputStream(fileOutputStream);
            this.closeInputStream(fileInputStream);
            throw throwable;
        }
        if (replaceCount.get() == needReplaceCount) {
            replaceDsUrl.set(true);
        } else {
            logger.error((Object)"replaceCount:%d not equal needReplaceCount:%d", new Object[]{replaceCount.get(), needReplaceCount});
        }
        return changedFile.get();
    }

    private String replaceLine(Map<String, String> dsUrlMap, AtomicInteger replaceCount, AtomicBoolean changedFile, String s) {
        for (Map.Entry<String, String> entry : dsUrlMap.entrySet()) {
            String oldUrl = entry.getKey();
            String newUrl = entry.getValue();
            if (s.indexOf(oldUrl) < 0) continue;
            if (VerifyUtil.isEmpty((String)newUrl)) {
                logger.error((Object)("mapping is error:oldUrl=" + oldUrl), 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            changedFile.set(true);
            replaceCount.addAndGet(1);
            s = s.replace(oldUrl, newUrl);
            break;
        }
        return s;
    }

    private void closeBuffer(BufferedReader in, BufferedWriter out) {
        if (null != in) {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.error((Object)("close stream error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)("close stream error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private void closeOutputStream(OutputStream out) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("close stream error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void closeInputStream(InputStream in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.error((Object)("close stream error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    protected String generateResultKey() {
        return "VsConfigVM:" + this.poId;
    }
}

