/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.util.Map;

public class VsCreateNasDsSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7203446010307663609L;
    private static final Log logger = LogFactory.getInstance(VsCreateNasDsSubProcessor.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor.";
    private static final String ALREADY_CREATED = "com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor.already.created";
    private static final String CREATE_NAS_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsCreateNasDsSubProcessor.createNas.failed";
    private String vcenterUuid;
    private String compResUuid;
    private String dsName;
    private String storageSrvIp;
    private String sharePath;
    private String dsUuid;
    private String oldDataStoreUrl;
    private String newDataStoreUrl;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.dsName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(ALREADY_CREATED, new String[]{this.dsName});
            logger.info((Object)("The NAS datastore has been created:dsName=" + this.dsName), 90160758786988L);
            return true;
        }
        this.initVars();
        DataStoreAction dsAction = new DataStoreAction();
        try {
            logger.info((Object)("start create nas datastore:dsName=" + this.dsName + " compResUuid=" + this.compResUuid + " storageSrvIp=" + this.storageSrvIp + " sharePath=" + this.sharePath));
            ManagedObjectReference dsMor = dsAction.createNasDatastoreForCompRes(this.vcenterUuid, this.compResUuid, this.storageSrvIp, this.sharePath, this.dsName);
            if (dsMor == null) {
                this.updateProcessDetail(CREATE_NAS_FAILED, null);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return true;
            }
            this.dsUuid = this.vcenterUuid + ":" + dsMor.getValue();
            this.newDataStoreUrl = (String)GetMoPropsValueUtils.getInstance().entityProps(VmwareConnectionManager.getInstance().getVmwareConnection(this.vcenterUuid), dsMor, new String[]{"summary.url"}).get("summary.url");
            logger.info((Object)("end create nas datastore:dsName=" + this.dsName + " dsUuid=" + this.dsUuid + " newDataStoreUrl=" + this.newDataStoreUrl));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create nas datastore failed", (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("create nas datastore failed:dsName=" + this.dsName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(CREATE_NAS_FAILED, null);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void initVars() {
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        if (14 != pg.getTemplate().getType() && 17 != pg.getTemplate().getType() && 28 != pg.getTemplate().getType()) {
            Map globalSettings = plan.getGlobalSettings();
            this.storageSrvIp = (String)globalSettings.get("nasSharePortIp");
        }
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.dsName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getCompResUuid() {
        return this.compResUuid;
    }

    public void setCompResUuid(String compResUuid) {
        this.compResUuid = compResUuid;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getSharePath() {
        return this.sharePath;
    }

    public void setSharePath(String sharePath) {
        this.sharePath = sharePath;
    }

    public String getStorageSrvIp() {
        return this.storageSrvIp;
    }

    public void setStorageSrvIp(String storageSrvIp) {
        this.storageSrvIp = storageSrvIp;
    }

    public String getDsUuid() {
        return this.dsUuid;
    }

    public void setDsUuid(String dsUuid) {
        this.dsUuid = dsUuid;
    }

    public String getOldDataStoreUrl() {
        return this.oldDataStoreUrl;
    }

    public void setOldDataStoreUrl(String oldDataStoreUrl) {
        this.oldDataStoreUrl = oldDataStoreUrl;
    }

    public String getNewDataStoreUrl() {
        return this.newDataStoreUrl;
    }

    public void setNewDataStoreUrl(String newDataStoreUrl) {
        this.newDataStoreUrl = newDataStoreUrl;
    }
}

