/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.model.NonCriticalVm;
import com.huawei.ism.drm.vsphere.recovery.process.VsHangupNoncriticalVmSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class VsHangupNoncriticalVmProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 5157033972220916505L;
    private static final Log logger = LogFactory.getInstance(VsHangupNoncriticalVmProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.debug((Object)"Storage Recovery HangUpNoncriticalVm Setp:Ready to hangup vms.", 90160758786816L);
        this.updateSubProcessors(context);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            logger.debug((Object)"No vm need hangup", 90160758786816L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.getChildProc());
        RecoveryProcessConcurrentExecutor executor = RecoveryProcessConcurrentExecutor.createExecutor(list);
        executor.process(context);
        logger.debug((Object)"complete the process of hangup vms.", 90160758786816L);
        this.calcProcessResultBySubProc();
        return true;
    }

    private boolean updateSubProcessors(RecoveryProcessorContext context) {
        RecoveryPlan plan = context.getRecoveryPlan();
        String vmStr = (String)plan.getGlobalSettings().get("NoncritialVM");
        if (VerifyUtil.isEmpty((String)vmStr) || "null".equals(vmStr)) {
            logger.info((Object)"global setting has no vms", 90160758786988L);
            return false;
        }
        logger.info((Object)("recoveryplan:" + plan.getName() + " golbal settings:vmStr=" + vmStr), 90160758786988L);
        JSONArray jsonArr = JSONArray.fromObject((Object)vmStr);
        List vmList = JSONArray.toCollection((JSONArray)jsonArr, NonCriticalVm.class);
        HashSet<VsHangupNoncriticalVmSubProcessor> subProcSet = new HashSet<VsHangupNoncriticalVmSubProcessor>();
        for (NonCriticalVm vm : vmList) {
            VsHangupNoncriticalVmSubProcessor subProc = new VsHangupNoncriticalVmSubProcessor();
            subProc.setVmName(vm.getName());
            subProc.setVmUuid(vm.getUuid());
            this.initProc((RecoveryProcessor)subProc);
            subProcSet.add(subProc);
        }
        this.setChildProc(subProcSet);
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).deleteSubRecoveryProcessor(this.getProcId());
        }
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private void initProc(RecoveryProcessor proc) {
        proc.setProcName(proc.getName());
        proc.setProcType(this.getProcType());
        proc.setPlanId(this.getPlanId());
        proc.setProcessId(this.getProcessId());
        proc.setParentProc((RecoveryProcessor)this);
        proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean endRecoveryProcessWithoutProcessor(String tip, boolean result) {
        this.updateProcessDetail(tip, new String[0]);
        int procStatus = result ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        this.setProcStatus(procStatus);
        return result;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsHangupNoncriticalVmProcessor.des");
    }
}

