/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMSnapshotAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class VsInitVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5269604109719570188L;
    private static final Log logger = LogFactory.getInstance(VsInitVmSubProcessor.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor.";
    private static final String INIT_YET = "com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor.inityet";
    private String dcMoId = "";
    private String compResMoId;
    private String vmName = "";
    private String vmxFilePath = "";
    private String vmMoId = "";
    private String vcenterUuid = "";
    private String poId;
    private boolean templateFlag;
    private String hostMoId;

    protected boolean execute(RecoveryProcessorContext context) {
        boolean flag;
        boolean hasVmSnap;
        this.updateProcessNameParams(new String[]{this.vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(INIT_YET, new String[0]);
            this.setPoRecoveryStatus();
            logger.debug((Object)("initialize vm yet " + this.getVmName()), 90160758786988L);
            return true;
        }
        this.initVars();
        logger.info((Object)("start register vm:vmName=" + this.vmName + " compResMoId=" + this.compResMoId + " hostMoId=" + this.hostMoId));
        boolean ret = this.registerVm();
        if (!ret) {
            logger.error((Object)("register VM failed " + this.vmName), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.setPoRecoveryStatus();
            return false;
        }
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            this.updateProtectObjectForPg();
        }
        if (!this.templateFlag && (hasVmSnap = VsphereRecoveryUtils.getInstance().isVmHasSnapShotConfig(this.getContextRef())) && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() && !(flag = this.revertToSnapshot())) {
            logger.info((Object)("revert to snapshot failed " + this.vmName), 90160758786989L);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        this.setPoRecoveryStatus();
        return true;
    }

    private void setPoRecoveryStatus() {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            return;
        }
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)this.poId, (int)DrmEnumDefine.AppType.VM.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.getContextRef().getProcessResult().addProcessResult(key, true);
        } else {
            this.getContextRef().getProcessResult().addProcessResult(key, false);
        }
    }

    private void initVars() {
        Map settings = this.getContextRef().getRecoveryPlan().getGlobalSettings();
        this.dcMoId = (String)settings.get("VSDATACENTERID");
        ProtectObject po = this.getPoById(this.poId);
        this.templateFlag = null == po || null == po.getProps().get("ISTEMPLATE") ? Boolean.FALSE : Boolean.parseBoolean((String)po.getProps().get("ISTEMPLATE"));
        int planType = this.getProcType();
        String key = "testHosts";
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
            key = "testHosts";
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryHosts";
        }
        String setting = (String)settings.get(key);
        if (!VerifyUtil.isEmpty((String)setting)) {
            JSONObject json = JSONObject.fromObject((Object)JSONArray.fromObject((Object)setting).get(0));
            this.compResMoId = json.getString("remoteHostId").split(":")[1];
        }
        if (this.templateFlag) {
            if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
                this.getHostMoId(po);
            } else {
                HostSystemAction action = new HostSystemAction();
                Set<String> hostMoIdSet = action.getAllHostsByComputeResId(this.vcenterUuid, this.compResMoId);
                if (!VerifyUtil.isEmpty(hostMoIdSet)) {
                    this.hostMoId = hostMoIdSet.iterator().next();
                }
            }
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
            ProtectGroup pg = this.getContextRef().getProtectGroup();
            String tempStr = (String)pg.getProps().get("pg_topo");
            JSONArray jsonArray = JSONArray.fromObject((Object)tempStr);
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonArray.get(0));
            this.compResMoId = jsonObj.getString("computResourceUuid").split(":")[1];
        }
    }

    private void getHostMoId(ProtectObject po) {
        String hostUuid = (String)po.getProps().get("HOSTUUID");
        if (VerifyUtil.isEmpty((String)hostUuid)) {
            return;
        }
        String[] array = hostUuid.split(":");
        if (array.length >= 2) {
            this.hostMoId = array[1];
        }
    }

    private void updateProtectObjectForPg() {
        VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
        ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)this.getContextRef().getRecoveryPlan().getProtectGroups());
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pg.getUuid(), false);
        for (ProtectObject obj : protectGroup.getPolist()) {
            if (!obj.getName().equals(this.vmName) || VerifyUtil.isEmpty((String)this.vmMoId)) continue;
            obj.setMoUuid(this.vcenterUuid + ":" + this.vmMoId);
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)obj);
            break;
        }
    }

    private boolean registerVm() {
        VMAction action = new VMAction();
        ManagedObjectReference dcMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.dcMoId, "Datacenter");
        ManagedObjectReference compResMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.compResMoId, "ComputeResource");
        try {
            ManagedObjectReference tempMor = action.findVmByPath(this.vcenterUuid, this.dcMoId, this.vmxFilePath);
            if (tempMor != null) {
                logger.info((Object)("vm alreay registerd:" + this.vmName), 90160758786988L);
                this.setVmMoId(tempMor.getValue());
                return true;
            }
            ManagedObjectReference vmMor = this.templateFlag ? action.registerTemplate(this.vcenterUuid, dcMor, this.hostMoId, this.vmxFilePath, this.vmName) : action.registerVm(this.vcenterUuid, dcMor, compResMor, this.vmxFilePath, this.vmName);
            if (null == vmMor) {
                logger.error((Object)("register VM failed:" + this.vmName), 90160758786989L);
                this.updateProcessDetail("lego.err.1073948887", null);
                return false;
            }
            this.setVmMoId(vmMor.getValue());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("register VM failed:" + this.vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("register VM failed:" + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("lego.err.1073948887", null);
            return false;
        }
        logger.debug((Object)("register VM " + this.vmName + " sucessfully"), 90160758786988L);
        return true;
    }

    private boolean revertToSnapshot() {
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.vmMoId, "VirtualMachine");
        VMSnapshotAction snapshotAction = new VMSnapshotAction();
        boolean revertRet = false;
        try {
            for (int i = 1; i <= 3; ++i) {
                try {
                    revertRet = snapshotAction.revertToSnapshot(this.vcenterUuid, this.vmMoId);
                }
                catch (Exception e) {
                    logger.error((Object)("revert snapshot failed with times=" + i + " vmname=" + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
                if (!revertRet) {
                    if (i >= 3) continue;
                    Thread.sleep(5 * i * 1000);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)("sleep faild:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        logger.debug((Object)(this.vmName + "revert to snapshot result=" + revertRet), 90160758786988L);
        if (revertRet) {
            if (null == vmMor) {
                logger.error((Object)"remove snapshot faild ", 90160758786989L);
                return false;
            }
            revertRet = snapshotAction.removeAllRdSnapshotReferenceOfVM(this.vcenterUuid, vmMor);
            logger.debug((Object)(this.vmName + "remove snapshot result=" + revertRet), 90160758786988L);
        }
        return revertRet;
    }

    private ProtectObject getPoById(String poUuid) {
        ProtectObject ret = null;
        for (ProtectObject tempPo : this.getContextRef().getRecoveryProtectObjects()) {
            if (!tempPo.getUuid().equals(poUuid)) continue;
            ret = tempPo;
            break;
        }
        return ret;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.vmMoId;
    }

    public String getDcMoId() {
        return this.dcMoId;
    }

    public void setDcMoId(String dcMoId) {
        this.dcMoId = dcMoId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVmxFilePath() {
        return this.vmxFilePath;
    }

    public void setVmxFilePath(String vmxFilePath) {
        this.vmxFilePath = vmxFilePath;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getCompResMoId() {
        return this.compResMoId;
    }

    public void setCompResMoId(String compResMoId) {
        this.compResMoId = compResMoId;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public boolean isTemplateFlag() {
        return this.templateFlag;
    }

    public void setTemplateFlag(boolean templateFlag) {
        this.templateFlag = templateFlag;
    }
}

