/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.RollbackSnapshotSubProcessor;
import java.util.LinkedHashSet;
import java.util.Set;

public class VsRdmRollbackProcessor
extends BaseRecoveryProcessor {
    private Set<RecoveryProcessor> processors;

    public VsRdmRollbackProcessor(Set<RecoveryProcessor> rollbackProcessor, RecoveryProcessor parentProcessor) {
        this.processors = rollbackProcessor;
        this.setParentProc(parentProcessor);
    }

    public VsRdmRollbackProcessor() {
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateRollbackProcessor();
        return this.executeSubProcessor(context);
    }

    private void updateRollbackProcessor() {
        LinkedHashSet<RollbackSnapshotSubProcessor> childProcessors = new LinkedHashSet<RollbackSnapshotSubProcessor>();
        for (RecoveryProcessor recoveryProcessor : this.processors) {
            if (!(recoveryProcessor instanceof CreateSnapshotCopySubProcessor)) continue;
            CreateSnapshotCopySubProcessor copySubProcessor = (CreateSnapshotCopySubProcessor)recoveryProcessor;
            RollbackSnapshotSubProcessor processor = new RollbackSnapshotSubProcessor();
            processor.setProcName(this.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            processor.setDeviceId(copySubProcessor.getDeviceId());
            processor.setLunId(copySubProcessor.getLunId());
            processor.setSnapshotId(copySubProcessor.getSnapshotId());
            processor.setSnapshotName(copySubProcessor.getSnapshotName());
            childProcessors.add(processor);
        }
        this.setChildProc(childProcessors);
    }
}

