/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VsRefreshVcenterProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 4569490702424968581L;
    private static final Log logger = LogFactory.getInstance(VsRefreshVcenterProcessor.class);
    private static final String PREFIX_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsRefreshVcenterProcessor";
    private static final String REFRESH_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsRefreshVcenterProcessor.failed";
    private static final String REFRESH_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsRefreshVcenterProcessor.timeout";
    private static final String OTHER_TASK_PROCESSING = "com.huawei.ism.drm.vsphere.recovery.process.VsRefreshVcenterProcessor.othertask.processing";
    private static final long QUERY_INTERVAL = 15000L;
    private static final long QUERY_TIMES = 60L;
    private boolean isComplete = false;
    private boolean taskResult = true;

    protected boolean execute(RecoveryProcessorContext context) {
        String vcenterUuid;
        RecoveryPlan plan = context.getRecoveryPlan();
        String planId = plan.getPlanId();
        ProtectGroup pg = context.getProtectGroup();
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue()) {
            vcenterUuid = pg.getPoProviderSN();
            this.unlockProtectGroup(pg.getUuid());
        } else {
            RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)planId, (String)pg.getUuid(), (String)"PG_DISASTER_HOST", (Set)plan.getRecoverySettings());
            vcenterUuid = setting.getValue();
        }
        if (null == vcenterUuid || vcenterUuid.isEmpty()) {
            logger.error((Object)"uuid is empty, and refreshing Host failed", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947394", null);
            return false;
        }
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)vcenterUuid);
        if (null == vCenter) {
            logger.error((Object)("vCenter(" + vcenterUuid + ") dosen't exist.Failed to refresh."), 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947394", null);
            return false;
        }
        long moId = vCenter.getMoId();
        NeMgrProtocolExtend extend = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByMoId(Long.valueOf(moId));
        if (null == extend) {
            logger.error((Object)("vCenter(" + vcenterUuid + ")'NeMgrProtocolExtend dosen't exist.Failed to refresh."), 90160777660713L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947394", null);
            return false;
        }
        logger.info((Object)("start refresh vcenter:vcenterUuid=" + vcenterUuid + " vcenterName=" + vCenter.getName()));
        int counter = this.commitRefreshTask(vCenter, context);
        return this.calcProcessorRet(context, vCenter, counter);
    }

    private void unlockProtectGroup(String pgUuid) {
        ProtectGroup pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgUuid, false);
        if (null != pg && pg.getStatus() == DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus()) {
            IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            recoveryProcessHandler.unlockProtectGroups(this.getContextRef().getRecoveryPlan().getProtectGroups());
            this.getContextRef().removeAttribute("LockProtectGroup");
            logger.info((Object)("unlock protectgroup:name=" + pg.getName()));
        }
    }

    private int commitRefreshTask(VsphereCenter vCenter, RecoveryProcessorContext context) {
        int counter = 0;
        try {
            AbstractBackTask task = this.constructAbBackTask(vCenter, context);
            BackTaskHandler.getInstance().submitTask(task);
            while (!this.isComplete && (long)counter < 60L) {
                ++counter;
                Thread.sleep(15000L);
            }
        }
        catch (Exception e) {
            this.taskResult = false;
            logger.error((Object)("submit task and wait failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return counter;
    }

    private boolean calcProcessorRet(RecoveryProcessorContext context, VsphereCenter vCenter, int counter) {
        if (this.taskResult && (long)counter < 60L) {
            if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()) {
                VsphereRecoveryUtils.getInstance().resetProtectObjectAfterRefresh(context, this.getProcType(), DrmEnumDefine.AppType.VM.getValue());
            }
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (counter == 0) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(OTHER_TASK_PROCESSING, new String[]{vCenter.getName()});
            return false;
        }
        if ((long)counter < 60L) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(REFRESH_FAILED, new String[]{vCenter.getName()});
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.updateProcessDetail(REFRESH_TIMEOUT, new String[]{vCenter.getName()});
        return false;
    }

    private AbstractBackTask constructAbBackTask(VsphereCenter vCenter, final RecoveryProcessorContext recoveryContext) {
        BackTask bt = BackTaskUtil.buildBackTask((String)vCenter.getName(), (String)"ism.srm.server.vsphere.refresh.operationName", (String)"System", (String)"", null);
        AbstractBackTask task = new AbstractBackTask(vCenter.getUuid(), bt, true){

            protected void doWork() {
                VsphereCenter vc = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)this.getTaskId());
                RefreshContext context = new RefreshContext((ManagedObject)vc);
                context.setAttribute("refreshTask", (Object)this);
                List<Integer> forceRefreshExecuteType = Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue(), DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK.getValue());
                if (forceRefreshExecuteType.contains(VsRefreshVcenterProcessor.this.getProcType())) {
                    HashSet<String> pgUuidSet = new HashSet<String>();
                    pgUuidSet.add(recoveryContext.getProtectGroup().getUuid());
                    context.setAttribute("PG_FORCE_REFRESH_SET", pgUuidSet);
                }
                context.setAttribute("PROTECTGROUP_REFRESH_TYPE", (Object)"sync");
                CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Vsphere");
                if (refreshTemplate == null) {
                    VsRefreshVcenterProcessor.this.isComplete = true;
                    VsRefreshVcenterProcessor.this.taskResult = false;
                    throw new LegoCheckedException(127402L);
                }
                try {
                    refreshTemplate.process((AbstractContext)context);
                }
                catch (Exception e) {
                    logger.error((Object)("task excute exception " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                    VsRefreshVcenterProcessor.this.taskResult = false;
                }
                Long errorCode = (Long)context.getAttribute("icommand:errorcode");
                if (errorCode != null) {
                    VsRefreshVcenterProcessor.this.isComplete = true;
                    VsRefreshVcenterProcessor.this.taskResult = false;
                    throw new LegoCheckedException(errorCode.longValue());
                }
                VsRefreshVcenterProcessor.this.isComplete = true;
            }
        };
        return task;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsRefreshVcenterProcessor.des");
    }
}

