/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.ism.drm.virtualization.recovery.process.MappingSnapshotSubProcessor;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VsConfigDataStoreSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsClSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsPmSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsUnmountLunSubProcessor;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsUnmountDsAndLunProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5541792266450647907L;
    private static final String DS_MOUNT_PRIFIX = "ds:///vmfs/volumes/";
    private static final Integer UNMOUNT_DS_PRIORITY = 0;
    private static final Integer UNMOUNT_LUN_PRIORITY = 1;
    private static final Log logger = LogFactory.getInstance(VsUnmountDsAndLunProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        Set subProcessors = this.getChildProc();
        if (null == subProcessors || subProcessors.isEmpty()) {
            if (!this.downLoadAndParseVmFile()) {
                logger.error((Object)"downLoadAndParseVmFile failed.", 90160758786989L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            if (!this.createSubProcessorsAndSetPriority(context)) {
                logger.error((Object)"create subprocessors failed.", 90160758786989L);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType());
        Map<Integer, List<IProcessor>> processorsWithPriority = this.getSubProcessByPriority();
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessUtil.createSerialExecutorWithConcurrentSubExecutor(processorsWithPriority, (DrmEnumDefine.RecoveryPlanExecuteTypeE)type, (boolean)true);
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private boolean downLoadAndParseVmFile() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        int ptType = pg.getTemplate().getType();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType() && PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(ptType)) {
            Map<String, String> scsiInfo = VsphereCommUtil.getPoScsiNumInfo(pg);
            if (scsiInfo.isEmpty()) {
                logger.error((Object)"getPoScsiNumInfo error.");
                return false;
            }
            this.getProps().putAll(VsphereCommUtil.getPoScsiNumInfo(pg));
        }
        return true;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private boolean createSubProcessorsAndSetPriority(RecoveryProcessorContext context) {
        int procType = this.getProcType();
        Set<RecoveryProcessor> subProcessors = procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() ? this.createPlannedSubProcessors(context) : this.createClearSubProcessors(context);
        this.setChildProc(subProcessors);
        boolean result = ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private Set<RecoveryProcessor> createClearSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> childProcessors = new HashSet<RecoveryProcessor>();
        List createProcessors = this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue() ? this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA, VsConfigDataStoreSubProcessor.class) : this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, VsConfigDataStoreSubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createProcessors)) {
            logger.debug((Object)"start SubProcessor is empty", 90160758786988L);
            return childProcessors;
        }
        String dsHostMoId = "";
        for (RecoveryProcessor p : createProcessors) {
            VsConfigDataStoreSubProcessor createDsSubProcessor = (VsConfigDataStoreSubProcessor)p;
            String newDsUuid = createDsSubProcessor.getNewDataStoreUuid();
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != createDsSubProcessor.getProcStatus()) continue;
            VsUnmountDsClSubProcessor processor = this.getVsUnmountDsClSubProcessorWhenClear(createDsSubProcessor, newDsUuid);
            dsHostMoId = createDsSubProcessor.getHostMoId();
            childProcessors.add((RecoveryProcessor)processor);
        }
        if (VerifyUtil.isEmpty((String)dsHostMoId)) {
            return childProcessors;
        }
        List mappingToHostProcessors = this.getRecoveryProcessors(context.getRecoveryPlan(), DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, MappingSnapshotSubProcessor.class);
        for (RecoveryProcessor lunProc : mappingToHostProcessors) {
            MappingSnapshotSubProcessor lunSubProc = (MappingSnapshotSubProcessor)lunProc;
            if (lunSubProc.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue()) continue;
            String snapShotWwn = lunSubProc.getSnapshotWWN();
            VsUnmountLunSubProcessor processor = this.getVsUnmountLunSubProcessorWhenClear(context, snapShotWwn);
            if (dsHostMoId != null && dsHostMoId.contains(":")) {
                dsHostMoId = dsHostMoId.split(":")[1];
            }
            processor.setHostMoId(dsHostMoId);
            childProcessors.add((RecoveryProcessor)processor);
        }
        return childProcessors;
    }

    private VsUnmountLunSubProcessor getVsUnmountLunSubProcessorWhenClear(RecoveryProcessorContext context, String snapShotWwn) {
        VsUnmountLunSubProcessor processor = new VsUnmountLunSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setLunWwn(snapShotWwn);
        processor.setVcenterUuid(this.getRecoveryVCenterUuid(context));
        processor.setIsPlanned(false);
        return processor;
    }

    private VsUnmountDsClSubProcessor getVsUnmountDsClSubProcessorWhenClear(VsConfigDataStoreSubProcessor createDsSubProcessor, String newDsUuid) {
        VsUnmountDsClSubProcessor processor = new VsUnmountDsClSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDataStoreUuid(newDsUuid);
        processor.setDataStoreName(createDsSubProcessor.getNewDataStoreName());
        processor.setHostMoId(createDsSubProcessor.getHostMoId());
        processor.setVcenterUuid(createDsSubProcessor.getVcenterUuid());
        return processor;
    }

    private Set<RecoveryProcessor> createPlannedSubProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> childProcessors = new HashSet<RecoveryProcessor>();
        HashSet<String> dsUuidSet = new HashSet<String>();
        HashSet<String> lunWwnSet = new HashSet<String>();
        HashMap<String, String> dsUuidNameMap = new HashMap<String, String>();
        for (ProtectGroup pg : this.getPgs(context)) {
            BaseRecoveryProcessor processor;
            String vCenterUuid = "";
            for (ProtectObject po : pg.getPolist()) {
                vCenterUuid = po.getProviderSN();
                this.generateDsAndLunStorageInfo(po, dsUuidSet, lunWwnSet, dsUuidNameMap);
            }
            for (String ds : dsUuidSet) {
                processor = this.getVsUnmountDsPmSubProcessorWhenMotion(dsUuidNameMap, vCenterUuid, ds);
                childProcessors.add((RecoveryProcessor)processor);
            }
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) continue;
            for (String lunWwn : lunWwnSet) {
                processor = this.getVsUnmountLunSubProcessorWhenMotion(vCenterUuid, lunWwn);
                childProcessors.add((RecoveryProcessor)processor);
            }
        }
        return childProcessors;
    }

    private VsUnmountLunSubProcessor getVsUnmountLunSubProcessorWhenMotion(String vCenterUuid, String lunWwn) {
        VsUnmountLunSubProcessor processor = new VsUnmountLunSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setLunWwn(lunWwn);
        processor.setVcenterUuid(vCenterUuid);
        processor.setIsPlanned(true);
        return processor;
    }

    private VsUnmountDsPmSubProcessor getVsUnmountDsPmSubProcessorWhenMotion(Map<String, String> dsUuidNameMap, String vCenterUuid, String ds) {
        VsUnmountDsPmSubProcessor processor = new VsUnmountDsPmSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        processor.setDatastoreMoId(ds);
        processor.setDataStoreName(dsUuidNameMap.get(ds));
        processor.setVcenterUuid(vCenterUuid);
        return processor;
    }

    private void generateDsAndLunStorageInfo(ProtectObject po, Set<String> dsMoIdSet, Set<String> lunWwnSet, Map<String, String> dsUuidNameMap) {
        for (ProtectObjectStorageInfo storageInfo : po.getUsedStorageResourceSet()) {
            String dataUuid = this.getDatastoreUuid(storageInfo.getMountPoint());
            dsMoIdSet.add(dataUuid);
            dsUuidNameMap.put(dataUuid, storageInfo.getDeviceName());
            lunWwnSet.add(storageInfo.getLunWWN());
        }
    }

    private Set<ProtectGroup> getPgs(RecoveryProcessorContext context) {
        Set pgs = context.getRecoveryPlan().getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            throw new LegoCheckedException(1073947394L);
        }
        return pgs;
    }

    private String getRecoveryVCenterUuid(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
        ProtectGroup protectGroup = (ProtectGroup)util.getElementFromCollection((Collection)recoveryPlan.getProtectGroups());
        RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)protectGroup.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
        if (null == setting) {
            return null;
        }
        return setting.getValue();
    }

    private Map<Integer, List<IProcessor>> getSubProcessByPriority() {
        Set childProcessor = this.getChildProc();
        HashMap<Integer, List<IProcessor>> processorsWithPriority = new HashMap<Integer, List<IProcessor>>();
        for (RecoveryProcessor childProc : childProcessor) {
            int priValue = UNMOUNT_DS_PRIORITY;
            if (childProc instanceof VsUnmountLunSubProcessor) {
                priValue = UNMOUNT_LUN_PRIORITY;
            }
            if (processorsWithPriority.containsKey(priValue)) {
                ((List)processorsWithPriority.get(priValue)).add(childProc);
                continue;
            }
            ArrayList<RecoveryProcessor> processList = new ArrayList<RecoveryProcessor>();
            processList.add(childProc);
            processorsWithPriority.put(priValue, processList);
        }
        return processorsWithPriority;
    }

    protected boolean calcProcessResultBySubProc() {
        DrmEnumDefine.RecoveryPlanExecuteResultE procStatus = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(procStatus.getValue());
        return DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue() != procStatus.getValue() && DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() != procStatus.getValue();
    }

    private String getDatastoreUuid(String mountPoint) {
        String dataUuid = mountPoint.substring(DS_MOUNT_PRIFIX.length(), mountPoint.length() - 1);
        return dataUuid;
    }

    public void updateDescription() {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor.pm.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor.cr.des");
        } else if (DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.vsphere.recovery.process.VsUnmountDsAndLunProcessor.sr.des");
        }
    }
}

